/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.aggregate;

import java.util.Collection;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.aggregate.Bicycle;
import org.eclipse.persistence.testing.models.aggregate.Transport;

public class AggregateInheritanceTestCase
extends AutoVerifyTestCase {
    private int transportId = 0;

    public void reset() {
        DatabaseSession session = (DatabaseSession)this.getSession();
        UnitOfWork uow = session.acquireUnitOfWork();
        ExpressionBuilder transport = new ExpressionBuilder();
        Expression expression = transport.get("id").equal(this.transportId);
        uow.deleteAllObjects((Collection)uow.readAllObjects(Transport.class, expression));
        uow.commit();
    }

    public void setup() {
    }

    public void test() {
        DatabaseSession session = (DatabaseSession)this.getSession();
        UnitOfWork uow = session.acquireUnitOfWork();
        Transport transport = Transport.example1();
        Transport transportClone = (Transport)uow.registerNewObject((Object)transport);
        uow.commitAndResume();
        this.transportId = transportClone.getId();
        transportClone.setVehicle(Bicycle.example1());
        uow.commit();
    }

    public void verify() {
        DatabaseSession session = (DatabaseSession)this.getSession();
        ExpressionBuilder transport = new ExpressionBuilder();
        Expression expression = transport.get("id").equal(this.transportId);
        Transport testTransport = Transport.example1();
        Transport transportFromTL = (Transport)session.readObject(Transport.class, expression);
        if (testTransport.getVehicle().getColour().equals(transportFromTL.getVehicle().getColour()) && testTransport.getVehicle().getCapacity() == transportFromTL.getVehicle().getCapacity()) {
            throw new TestErrorException("The Aggregate was changed, but the database was not updated.");
        }
    }
}

