/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.async.perf;

import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.kv.impl.async.perf.CountMetrics;
import oracle.kv.impl.async.perf.DialogDetail;
import oracle.kv.impl.async.perf.DialogLatency;
import oracle.kv.impl.async.perf.DialogPerf;
import oracle.kv.impl.async.perf.PerfCondition;
import oracle.kv.impl.async.perf.PerfFilter;

public class EndpointHandlerPerf {
    private final String handlerId;
    private final Logger logger;
    private static final long rateUpdatePeriodMillis = 100L;
    private static final long loggingMonitorPeriodMillis = 1000L;
    private final CountMetrics dialogStartMetric = new CountMetrics("dialog start", 100L);
    private final CountMetrics dialogDropMetric = new CountMetrics("dialog drop", 100L);
    private final CountMetrics dialogFinishMetric = new CountMetrics("dialog finish", 100L);
    private final CountMetrics dialogAbortMetric = new CountMetrics("dialog abort", 100L);
    private final DialogLatency dialogFinishLatency = new DialogLatency("dialog finish latency");
    private final DialogLatency dialogAbortLatency = new DialogLatency("dialog abort latency");
    private final DialogDetail dialogDetail = new DialogDetail();
    private volatile Future<?> updateFuture = null;
    private volatile Future<?> monitorFuture = null;

    public EndpointHandlerPerf(String id, Logger logger) {
        this.handlerId = id;
        this.logger = logger;
    }

    public void schedule(ScheduledExecutorService executor) {
        if (PerfCondition.SYSTEM_PERF_ENABLED.holds()) {
            try {
                this.updateFuture = executor.scheduleAtFixedRate(new RateMetricsUpdater(), 100L, 100L, TimeUnit.MILLISECONDS);
                this.monitorFuture = executor.scheduleAtFixedRate(new LoggingMonitor(), 1000L, 1000L, TimeUnit.MILLISECONDS);
            }
            catch (RejectedExecutionException e) {
                this.logger.log(Level.WARNING, "Unable to start updating and monitoring tasks for perf: ", e);
            }
        }
    }

    public void close() {
        if (this.updateFuture != null) {
            this.updateFuture.cancel(false);
        }
        if (this.monitorFuture != null) {
            this.monitorFuture.cancel(false);
        }
    }

    public boolean onDialogStarted() {
        long count = this.dialogStartMetric.incrementAndGet();
        return PerfFilter.SYSTEM_SAMPLING.accept(count);
    }

    public void onDialogDropped() {
        this.dialogDropMetric.incrementAndGet();
    }

    public void onDialogFinished(DialogPerf dperf) {
        this.dialogFinishMetric.incrementAndGet();
        this.dialogFinishLatency.update(dperf);
        this.dialogDetail.update(dperf);
    }

    public void onDialogAborted(DialogPerf dperf) {
        this.dialogAbortMetric.incrementAndGet();
        this.dialogAbortLatency.update(dperf);
        this.dialogDetail.update(dperf);
    }

    public String getPerfString() {
        return String.format("Perf stats from async:\n[endpoint id]%s\n%s\n%s\n%s\n%s\n%s\n%s\n%s\n", this.handlerId, this.dialogStartMetric.get(), this.dialogDropMetric.get(), this.dialogFinishMetric.get(), this.dialogAbortMetric.get(), this.dialogFinishLatency.get(), this.dialogAbortLatency.get(), this.dialogDetail.get());
    }

    public class LoggingMonitor
    implements Runnable {
        @Override
        public void run() {
            if (EndpointHandlerPerf.this.logger.isLoggable(Level.INFO)) {
                EndpointHandlerPerf.this.logger.log(Level.INFO, "{0}", EndpointHandlerPerf.this.getPerfString());
            }
        }
    }

    public class RateMetricsUpdater
    implements Runnable {
        @Override
        public void run() {
            EndpointHandlerPerf.this.dialogStartMetric.update();
            EndpointHandlerPerf.this.dialogDropMetric.update();
            EndpointHandlerPerf.this.dialogFinishMetric.update();
            EndpointHandlerPerf.this.dialogAbortMetric.update();
        }
    }
}

