/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.junit.helper;

import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Vector;
import org.eclipse.persistence.internal.helper.Helper;
import org.junit.Assert;
import org.junit.Test;

public class HelperTest {
    @Test
    public void basicTest() {
        Assert.assertFalse((String)"Failed to compare two different BigDecimal numbers.", (boolean)Helper.compareBigDecimals((BigDecimal)new BigDecimal(0.01), (BigDecimal)new BigDecimal(0.001)));
        Assert.assertFalse((String)"Failed to compare two equal BigDecimal numbers.", (boolean)Helper.compareBigDecimals((BigDecimal)new BigDecimal(1.01), (BigDecimal)new BigDecimal(1.001)));
        Assert.assertEquals((String)"Failed to replace single slash with double slashes from the String.", (Object)"c:\\\\test1\\\\test2\\\\test3\\\\", (Object)Helper.doubleSlashes((String)"c:\\test1\\test2\\test3\\"));
        Assert.assertEquals((String)"Failed to remove vowels from String.", (Object)"llllll", (Object)Helper.removeVowels((String)"lalelilolule"));
        Assert.assertEquals((String)"Failed to remove Character to fit String.", (Object)"123x", (Object)Helper.removeCharacterToFit((String)"1x2x3x", (char)'x', (int)4));
        Helper.printTimeFromMilliseconds((long)100L);
        Helper.printTimeFromMilliseconds((long)10000L);
        Helper.printTimeFromMilliseconds((long)100000L);
        Assert.assertTrue((String)"Failed to get instance from Class.", (boolean)(Helper.getInstanceFromClass(this.getClass()) instanceof HelperTest));
        Assert.assertTrue((String)"Failed to check if Character.class is a primitive wrapper.", (boolean)Helper.isPrimitiveWrapper(Character.class));
        Assert.assertTrue((String)"Failed to check if Boolean.class is a primitive wrapper.", (boolean)Helper.isPrimitiveWrapper(Boolean.class));
        Assert.assertTrue((String)"Failed to check if Byte.class is a primitive wrapper.", (boolean)Helper.isPrimitiveWrapper(Byte.class));
        Assert.assertTrue((String)"Failed to check if Short.class is a primitive wrapper.", (boolean)Helper.isPrimitiveWrapper(Short.class));
        Assert.assertTrue((String)"Failed to check if Integer.class is a primitive wrapper.", (boolean)Helper.isPrimitiveWrapper(Integer.class));
        Assert.assertTrue((String)"Failed to check if Long.class is a primitive wrapper.", (boolean)Helper.isPrimitiveWrapper(Long.class));
        Assert.assertTrue((String)"Failed to check if Float.class is a primitive wrapper.", (boolean)Helper.isPrimitiveWrapper(Float.class));
        Assert.assertTrue((String)"Failed to check if Double.class is a primitive wrapper.", (boolean)Helper.isPrimitiveWrapper(Double.class));
        Vector<Object> aVector = new Vector<Object>();
        String elem = new String("dummy");
        aVector.addElement(elem);
        Assert.assertEquals((String)"Failed to make a java.util.Vector from a java.util.Vector.", aVector, (Object)Helper.makeVectorFromObject(aVector));
        HashSet<String> set = new HashSet<String>();
        set.add(elem);
        Assert.assertEquals((String)"Failed to make a java.util.Vector from a java.util.Set.", aVector, (Object)Helper.makeVectorFromObject(set));
        aVector.clear();
        for (int i = 0; i < 3; ++i) {
            aVector.add(i, new Integer(i));
        }
        Vector reverseVector = Helper.reverseVector(aVector);
        for (int i = 0; i < 3; ++i) {
            Assert.assertEquals((String)"Failed to reverse elements of java.util.Vector", (long)(2 - i), (long)((Integer)reverseVector.elementAt(i)).intValue());
        }
    }

    @Test
    public void checkAreVectorTypesAssignableTest() {
        Vector<Class<Integer>> v1 = new Vector<Class<Integer>>();
        v1.addElement(Integer.class);
        Vector<Class<String>> v2 = new Vector<Class<String>>();
        v2.addElement(String.class);
        Assert.assertFalse((String)"An exception should not have been thrown when checking if vectors are assignable.", (boolean)Helper.areTypesAssignable(v1, v2));
    }

    @Test
    public void checkAreVectorTypesAssignableWithNullVectorTest() {
        Vector<Integer> v1 = new Vector<Integer>();
        v1.addElement(new Integer(1));
        Assert.assertFalse((String)"An exception should not have been thrown when checking if vectors are assignable - when one of the vectors is null.", (boolean)Helper.areTypesAssignable(v1, null));
    }

    @Test
    public void checkClassIsSubclassWithNullSuperclassTest() {
        Assert.assertFalse((String)"Helper.classIsSubclass(Class subClass, Class superClass) does not recognize that parent class is null.", (boolean)Helper.classIsSubclass(HashMap.class, null));
    }

    @Test
    public void checkCompareBigDecimalsTest() {
        BigDecimal bd1 = new BigDecimal(1);
        bd1.setScale(1);
        BigDecimal bd2 = new BigDecimal(-2);
        bd2.setScale(2);
        BigDecimal bd3 = new BigDecimal(1);
        bd3.setScale(3);
        Assert.assertFalse((String)"Helper.compareBigDecimals(java.math.BigDecimal one, java.math.BigDecimal two) - with two non-infinity but different argurments - returns incorrectly.", (boolean)Helper.compareBigDecimals((BigDecimal)bd1, (BigDecimal)bd2));
        Assert.assertTrue((String)"Helper.compareBigDecimals(java.math.BigDecimal one, java.math.BigDecimal two) - with two non-infinity but identical argurments - returns incorrectly.", (boolean)Helper.compareBigDecimals((BigDecimal)bd1, (BigDecimal)bd3));
    }

    @Test
    public void checkCompareByteArraysWithDifferentElementsTest() {
        byte[] b1 = "12345".getBytes();
        byte[] b2 = "12346".getBytes();
        Assert.assertFalse((String)"Helper.compareByteArrays(b1,b2) when comparing byte arrays with different elements.", (boolean)Helper.compareByteArrays((byte[])b1, (byte[])b2));
    }

    @Test
    public void compareArrayContentTest() {
        Object[] array1 = new Integer[3];
        Object[] array2 = new Integer[3];
        Object[] array3 = new Integer[3];
        for (int count = 0; count < 3; ++count) {
            Integer counter = new Integer(count);
            Integer counter2 = new Integer(count + 9);
            array1[count] = counter;
            array2[count] = counter;
            array3[count] = counter2;
        }
        Assert.assertTrue((String)"Helper.compareArrays(Object[] array1, Object[] array2) does not recognize that object arrays contain identical elements.", (boolean)Helper.compareArrays((Object[])array1, (Object[])array2));
        Assert.assertFalse((String)"Helper.compareArrays(Object[] array1, Object[] array2) does not recognize that object arrays contain different elements.", (boolean)Helper.compareArrays((Object[])array1, (Object[])array3));
    }

    @Test
    public void compareArrayLengthTest() {
        Object[] array1 = new Integer[2];
        Object[] array2 = new Integer[2];
        Object[] array3 = new Integer[3];
        for (int count = 0; count < 2; ++count) {
            Integer counter;
            array1[count] = counter = new Integer(count);
            array2[count] = counter;
            array3[count] = counter;
        }
        array3[2] = new Integer(10);
        Assert.assertTrue((String)"Helper.compareArrays(Object[] array1, Object[] array2) does not recognize that object arrays are of same length.", (boolean)Helper.compareArrays((Object[])array1, (Object[])array2));
        Assert.assertFalse((String)"Helper.compareArrays(Object[] array1, Object[] array2) does not recognize that object arrays are of different length.", (boolean)Helper.compareArrays((Object[])array1, (Object[])array3));
    }

    @Test
    public void compareCharArrayContentTest() {
        char[] array1 = new char[]{'a', 'b', 'c'};
        char[] array2 = new char[]{'a', 'b', 'c'};
        char[] array3 = new char[]{'x', 'y', 'z'};
        Assert.assertTrue((String)"Helper.compareCharArrays(char[] array1, char[] array2) does not recognize that arrays contain the same elements.", (boolean)Helper.compareCharArrays((char[])array1, (char[])array2));
        Assert.assertFalse((String)"Helper.compareCharArrays(char[] array1, char[] array2) does not recognize that arrays contain different elements.", (boolean)Helper.compareCharArrays((char[])array1, (char[])array3));
    }

    @Test
    public void compareCharArrayLengthTest() {
        char[] array1 = new char[]{'a', 'b'};
        char[] array2 = new char[]{'a', 'b'};
        char[] array3 = new char[]{'a', 'b', 'c'};
        Assert.assertTrue((String)"Helper.compareCharArrays(char[] array1, char[] array2) does not recognize that arrays are of same length.", (boolean)Helper.compareCharArrays((char[])array1, (char[])array2));
        Assert.assertFalse((String)"Helper.compareCharArrays(char[] array1, char[] array2) does not recognize that arrays are of different length.", (boolean)Helper.compareCharArrays((char[])array1, (char[])array3));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void timeFromDateTest() {
        boolean optimizedDatesState = Helper.shouldOptimizeDates();
        try {
            Date testDate = Helper.utilDateFromLong((Long)new Long(System.currentTimeMillis()));
            String testTime = new Time(testDate.getTime()).toString();
            Helper.setShouldOptimizeDates((boolean)false);
            Assert.assertEquals((String)"Failed to convert java.util.Date to java.sql.Time when shouldOptimizedDates is off", (Object)testTime, (Object)Helper.timeFromDate((Date)testDate).toString());
            Helper.setShouldOptimizeDates((boolean)true);
            Assert.assertEquals((String)"Failed to convert java.util.Date to java.sql.Time when shouldOptimizedDates is on", (Object)testTime, (Object)Helper.timeFromDate((Date)testDate).toString());
        }
        finally {
            Helper.setShouldOptimizeDates((boolean)optimizedDatesState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void TimeFromLongTest() {
        boolean optimizedDatesState = Helper.shouldOptimizeDates();
        try {
            Long currentTime = new Long(System.currentTimeMillis());
            Time expectedTestTime = new Time(currentTime);
            Helper.setShouldOptimizeDates((boolean)false);
            Time actualTime = Helper.timeFromLong((Long)currentTime);
            Assert.assertEquals((String)"Failed to convert Long to java.sql.Time when shouldOptimizedDates is off", (Object)expectedTestTime, (Object)actualTime);
            Assert.assertEquals((String)"Failed to convert Long to java.sql.Time when shouldOptimizedDates is off", (Object)expectedTestTime.toString(), (Object)actualTime.toString());
            Helper.setShouldOptimizeDates((boolean)true);
            actualTime = Helper.timeFromLong((Long)currentTime);
            Assert.assertEquals((String)"Failed to convert Long to java.sql.Time when shouldOptimizedDates is on", (Object)expectedTestTime, (Object)actualTime);
            Assert.assertEquals((String)"Failed to convert Long to java.sql.Time when shouldOptimizedDates is on", (Object)expectedTestTime.toString(), (Object)actualTime.toString());
        }
        finally {
            Helper.setShouldOptimizeDates((boolean)optimizedDatesState);
        }
    }

    @Test
    public void timeFromStringTest() {
        boolean optimizedDatesState = Helper.shouldOptimizeDates();
        try {
            String currentTime = new Time(System.currentTimeMillis()).toString();
            Helper.setShouldOptimizeDates((boolean)false);
            Assert.assertEquals((String)"Failed to convert String to java.sql.Time when shouldOptimizedDates is off", (Object)currentTime, (Object)Helper.timeFromString((String)currentTime).toString());
            Helper.setShouldOptimizeDates((boolean)true);
            Assert.assertEquals((String)"Failed to convert String to java.sql.Time when shouldOptimizedDates is on", (Object)currentTime, (Object)Helper.timeFromString((String)currentTime).toString());
        }
        finally {
            Helper.setShouldOptimizeDates((boolean)optimizedDatesState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void timestampFromDateTest() {
        boolean optimizedDatesState = Helper.shouldOptimizeDates();
        try {
            Date currentTime = Helper.utilDateFromLong((Long)new Long(System.currentTimeMillis()));
            String testTime = new Timestamp(currentTime.getTime()).toString();
            Helper.setShouldOptimizeDates((boolean)true);
            Assert.assertEquals((String)"Failed to convert java.util.Date to java.sql.Timestamp when shouldOptimizedDates is on", (Object)testTime, (Object)Helper.timestampFromDate((Date)currentTime).toString());
        }
        finally {
            Helper.setShouldOptimizeDates((boolean)optimizedDatesState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void timestampFromLongTest() {
        boolean optimizedDatesState = Helper.shouldOptimizeDates();
        try {
            Long currentTime = new Long(System.currentTimeMillis());
            String testTime = new Timestamp(currentTime).toString();
            Helper.setShouldOptimizeDates((boolean)true);
            Assert.assertEquals((String)"Failed to convert Long to java.sql.Timestamp when shouldOptimizedDates is on", (Object)testTime, (Object)Helper.timestampFromLong((Long)currentTime).toString());
        }
        finally {
            Helper.setShouldOptimizeDates((boolean)optimizedDatesState);
        }
    }

    @Test
    public void timestampFromStringTest() {
        boolean optimizedDatesState = Helper.shouldOptimizeDates();
        try {
            Helper.setShouldOptimizeDates((boolean)true);
            String currentTime = new Timestamp(System.currentTimeMillis()).toString();
            Assert.assertEquals((String)"Failed to convert String to java.sql.Timestamp when shouldOptimizedDates is on", (Object)currentTime, (Object)Helper.timestampFromString((String)currentTime).toString());
            Assert.assertEquals((String)"Failed to convert String to java.sql.Timestamp when shouldOptimizedDates is on", (Object)Timestamp.valueOf("2018-01-01 16:24:33.00013"), (Object)Helper.timestampFromString((String)"2018-01-01 16:24:33.00013+02"));
            Assert.assertEquals((String)"Failed to convert String to java.sql.Timestamp when shouldOptimizedDates is on", (Object)Timestamp.valueOf("2018-01-01 16:24:33.0"), (Object)Helper.timestampFromString((String)"2018-01-01 16:24:33+02"));
            Assert.assertEquals((String)"Failed to convert String to java.sql.Timestamp when shouldOptimizedDates is on", (Object)Timestamp.valueOf("2018-01-01 16:24:33.1"), (Object)Helper.timestampFromString((String)"2018-01-01 16:24:33.1+02"));
            Assert.assertEquals((String)"Failed to convert String to java.sql.Timestamp when shouldOptimizedDates is on", (Object)Timestamp.valueOf("2018-01-01 16:24:33.0"), (Object)Helper.timestampFromString((String)"2018-01-01 16:24:33.0000000+02"));
            Assert.assertEquals((String)"Failed to convert String to java.sql.Timestamp when shouldOptimizedDates is on", (Object)Timestamp.valueOf("2018-01-01 16:24:33.0"), (Object)Helper.timestampFromString((String)"2018-01-01 16:24:33.0000000"));
            Assert.assertEquals((String)"Failed to convert String to java.sql.Timestamp when shouldOptimizedDates is on", (Object)Timestamp.valueOf("2018-01-01 16:24:33.0"), (Object)Helper.timestampFromString((String)"2018-01-01 16:24:33"));
        }
        finally {
            Helper.setShouldOptimizeDates((boolean)optimizedDatesState);
        }
    }
}

