/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.topo.split;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.kv.Consistency;
import oracle.kv.impl.topo.Datacenter;
import oracle.kv.impl.topo.PartitionId;
import oracle.kv.impl.topo.RepGroupId;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.topo.split.TopoSplit;

public class SplitBuilder {
    private static final int TARGET_STREAMS_PER_RN = 2;
    private static final int TARGET_STREAMS_PER_SPLIT = 3;
    private final Topology topo;
    private final int storeRf;

    public SplitBuilder(Topology topology) {
        this.topo = topology;
        if (this.topo.getRepGroupMap().size() < 1) {
            throw new IllegalArgumentException("Number of shards in store is 0");
        }
        int totalRf = 0;
        for (Datacenter dc : this.topo.getDatacenterMap().getAll()) {
            if (!dc.getDatacenterType().isPrimary()) continue;
            totalRf += dc.getRepFactor();
        }
        if (totalRf == 0) {
            throw new IllegalArgumentException("Store replication factor is 0");
        }
        this.storeRf = totalRf;
    }

    public List<TopoSplit> createPartitionSplits(int nSplits, Consistency consistency) {
        int nPartitions;
        if (nSplits < 1) {
            throw new IllegalArgumentException("nSplits must be > 0");
        }
        ArrayList<TopoSplit> splits = new ArrayList<TopoSplit>(nSplits);
        for (int i = 1; i <= nSplits; ++i) {
            splits.add(new TopoSplit(i));
        }
        int nShards = this.topo.getRepGroupMap().size();
        int streamsPerShard = this.calcShardConcurrency(consistency) * 2;
        int totalStreams = streamsPerShard * nShards;
        int streamsPerSplit = totalStreams / nSplits;
        if (totalStreams % nSplits != 0) {
            ++streamsPerSplit;
        }
        int splitSize = (nPartitions = this.topo.getPartitionMap().getNPartitions()) < nSplits ? 1 : nPartitions / nSplits;
        int start = 1;
        int end = splitSize;
        for (TopoSplit split : splits) {
            PartitionSelector selector;
            Set<Integer> pSet;
            if (split.getId() == nSplits) {
                end = nPartitions;
            }
            Map<RepGroupId, Set<Integer>> map = this.createPartitionMap(start, end);
            while (!map.isEmpty() && (pSet = (selector = new PartitionSelector(map, streamsPerShard)).getNextSet(streamsPerSplit)) != null) {
                split.add(pSet);
            }
            start = end + 1;
            end += splitSize;
            if (start <= nPartitions) continue;
            break;
        }
        return splits;
    }

    List<TopoSplit> createShardSplits(int nSplits, Consistency consistency) {
        if (nSplits < 1) {
            throw new IllegalArgumentException("nSplits must be > 0");
        }
        return this.createShardSplitsInternal(nSplits, consistency);
    }

    public List<TopoSplit> createShardSplits(Consistency consistency) {
        return this.createShardSplitsInternal(Integer.MAX_VALUE, consistency);
    }

    private List<TopoSplit> createShardSplitsInternal(int targetSplits, Consistency consistency) {
        int nShards = this.topo.getRepGroupMap().size();
        assert (nShards != 0);
        int streamsPerShard = this.calcShardConcurrency(consistency) * 2;
        int totalStreams = streamsPerShard * nShards;
        int optimalNSplits = totalStreams > 3 ? totalStreams / 3 : 1;
        int nSplits = optimalNSplits <= targetSplits ? optimalNSplits : targetSplits;
        ArrayList<TopoSplit> splits = new ArrayList<TopoSplit>(nSplits);
        for (int i = 1; i <= nSplits; ++i) {
            splits.add(new TopoSplit(i));
        }
        int streamsPerSplit = totalStreams / nSplits;
        if (totalStreams % nSplits != 0) {
            ++streamsPerSplit;
        }
        Map<RepGroupId, Set<Integer>> map = this.createPartitionMap(1, this.topo.getPartitionMap().getNPartitions());
        while (!map.isEmpty()) {
            PartitionSelector selector = new PartitionSelector(map, streamsPerShard);
            for (TopoSplit split : splits) {
                Set<Integer> pSet = selector.getNextSet(streamsPerSplit);
                if (pSet == null) break;
                split.add(pSet);
            }
            assert (selector.getNextSet(streamsPerSplit) == null);
        }
        return splits;
    }

    private Map<RepGroupId, Set<Integer>> createPartitionMap(int startPartition, int endPartition) {
        int nPartitions = 1 + (endPartition - startPartition);
        assert (startPartition > 0);
        assert (nPartitions > 0);
        HashMap<RepGroupId, Set<Integer>> map = new HashMap<RepGroupId, Set<Integer>>();
        for (int i = startPartition; i <= endPartition; ++i) {
            PartitionId partId = new PartitionId(i);
            RepGroupId rgid = this.topo.getRepGroupId(partId);
            HashSet<Integer> parts = (HashSet<Integer>)map.get(rgid);
            if (parts == null) {
                parts = new HashSet<Integer>();
                map.put(rgid, parts);
            }
            parts.add(i);
        }
        return map;
    }

    private int calcShardConcurrency(Consistency consistency) {
        if (consistency == Consistency.ABSOLUTE) {
            return 1;
        }
        if (consistency == Consistency.NONE_REQUIRED_NO_MASTER) {
            return this.storeRf - 1;
        }
        return this.storeRf;
    }

    private class PartitionSelector {
        final int maxSelectFromShard;
        private final Iterator<Set<Integer>> shardItr;
        Iterator<Integer> partitionItr;
        int selected = 0;

        PartitionSelector(Map<RepGroupId, Set<Integer>> map, int maxSelectFromShard) {
            this.maxSelectFromShard = maxSelectFromShard;
            this.shardItr = map.values().iterator();
            this.nextPartitionItr();
        }

        private boolean nextPartitionItr() {
            this.partitionItr = this.shardItr.hasNext() ? this.shardItr.next().iterator() : null;
            return this.partitionItr != null;
        }

        private Integer getNextPartition() {
            if (this.partitionItr == null) {
                return null;
            }
            if (this.selected >= this.maxSelectFromShard) {
                if (!this.nextPartitionItr()) {
                    return null;
                }
                this.selected = 0;
            }
            assert (this.partitionItr != null);
            while (!this.partitionItr.hasNext()) {
                this.shardItr.remove();
                if (!this.nextPartitionItr()) {
                    return null;
                }
                assert (this.partitionItr != null);
            }
            ++this.selected;
            Integer ret = this.partitionItr.next();
            this.partitionItr.remove();
            return ret;
        }

        Set<Integer> getNextSet(int setSize) {
            Integer p;
            assert (this.selected >= 0);
            HashSet<Integer> pSet = null;
            for (int i = 0; i < setSize && (p = this.getNextPartition()) != null; ++i) {
                if (pSet == null) {
                    pSet = new HashSet<Integer>();
                }
                pSet.add(p);
            }
            return pSet;
        }
    }
}

