/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.parallelscan;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import oracle.kv.Consistency;
import oracle.kv.Direction;
import oracle.kv.impl.api.KVStoreImpl;
import oracle.kv.impl.api.Request;
import oracle.kv.impl.api.TopologyManager;
import oracle.kv.impl.api.ops.InternalOperation;
import oracle.kv.impl.api.ops.Result;
import oracle.kv.impl.api.parallelscan.BaseParallelScanIteratorImpl;
import oracle.kv.impl.api.parallelscan.DetailedMetricsImpl;
import oracle.kv.impl.async.IterationHandleNotifier;
import oracle.kv.impl.topo.RepGroupId;
import oracle.kv.impl.topo.Topology;
import oracle.kv.query.ExecuteOptions;
import oracle.kv.stats.DetailedMetrics;

public abstract class ShardScanIterator<K>
extends BaseParallelScanIteratorImpl<K>
implements TopologyManager.PostUpdateListener {
    protected final Consistency consistency;
    private final int nGroups;
    private final int partitionMapHashCode;
    protected final int batchSize;
    private final Map<RepGroupId, DetailedMetricsImpl> shardMetrics = new HashMap<RepGroupId, DetailedMetricsImpl>();

    public ShardScanIterator(KVStoreImpl store, ExecuteOptions options, Direction dir, Set<RepGroupId> shardSet, IterationHandleNotifier iterHandleNotifier) {
        super(store, store.getLogger(), ShardScanIterator.computeRequestTimeout(store, options), dir, 0, options.getDoPrefetching(), iterHandleNotifier);
        this.consistency = options.getConsistency();
        this.batchSize = options.getResultsBatchSize();
        TopologyManager topoManager = store.getDispatcher().getTopologyManager();
        Topology topology = topoManager.getTopology();
        Set<RepGroupId> groups = shardSet == null ? topology.getRepGroupIds() : shardSet;
        this.nGroups = groups.size();
        if (this.nGroups == 0) {
            throw new IllegalStateException("Store not yet initialized");
        }
        this.partitionMapHashCode = topology.getPartitionMap().hashCode();
        this.setTaskExecutor(this.nGroups * 2);
        for (RepGroupId groupId : groups) {
            ShardStream stream = this.createStream(groupId);
            this.streams.add(stream);
            stream.submit();
        }
        topoManager.addPostUpdateListener(this, true);
    }

    private static long computeRequestTimeout(KVStoreImpl store, ExecuteOptions options) {
        long requestTimeoutMs;
        long timeout = options.getTimeout();
        long l = requestTimeoutMs = timeout == 0L ? (long)store.getDefaultRequestTimeoutMs() : options.getTimeoutUnit().toMillis(timeout);
        if (requestTimeoutMs <= 0L) {
            throw new IllegalArgumentException("Timeout must be > 0 ms");
        }
        return requestTimeoutMs;
    }

    protected ShardStream createStream(RepGroupId groupId) {
        return new ShardStream(groupId, null, null);
    }

    @Override
    public List<DetailedMetrics> getPartitionMetrics() {
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DetailedMetrics> getShardMetrics() {
        Map<RepGroupId, DetailedMetricsImpl> map = this.shardMetrics;
        synchronized (map) {
            ArrayList<DetailedMetrics> ret = new ArrayList<DetailedMetrics>(this.shardMetrics.size());
            ret.addAll(this.shardMetrics.values());
            return ret;
        }
    }

    protected abstract InternalOperation createOp(byte[] var1, byte[] var2);

    protected byte[] extractResumeSecondaryKey(Result result) {
        return result.getSecondaryResumeKey();
    }

    @Override
    protected boolean close(Throwable reason) {
        return this.close(reason, true);
    }

    private boolean close(Throwable reason, boolean remove) {
        List<Runnable> unfinishedBusiness;
        if (!super.close(reason)) {
            return false;
        }
        if (remove) {
            this.storeImpl.getDispatcher().getTopologyManager().removePostUpdateListener(this);
        }
        if (!(unfinishedBusiness = this.getTaskExecutor().shutdownNow()).isEmpty()) {
            this.logger.log(Level.FINE, "IndexScan executor didn''t shutdown cleanly. {0} tasks remaining.", unfinishedBusiness.size());
        }
        return true;
    }

    @Override
    public boolean postUpdate(Topology topology) {
        if (this.closed) {
            return true;
        }
        int newGroupSize = topology.getRepGroupIds().size();
        if (this.nGroups > newGroupSize) {
            this.close(new UnsupportedOperationException("The number of shards has decreased during the iteration"), false);
        }
        if (this.nGroups < newGroupSize) {
            this.close(new UnsupportedOperationException("The number of shards has increased during the iteration"), false);
        }
        if (this.partitionMapHashCode != topology.getPartitionMap().hashCode()) {
            this.close(new UnsupportedOperationException("The location of one or more partitions has changed during the iteration"), false);
        }
        return this.closed;
    }

    protected class ShardStream
    extends BaseParallelScanIteratorImpl.Stream {
        protected final RepGroupId groupId;
        protected byte[] resumeSecondaryKey;
        protected byte[] resumePrimaryKey;

        protected ShardStream(RepGroupId groupId, byte[] resumeSecondaryKey, byte[] resumePrimaryKey) {
            this.groupId = groupId;
            this.resumeSecondaryKey = resumeSecondaryKey;
            this.resumePrimaryKey = resumePrimaryKey;
        }

        protected RepGroupId getGroupId() {
            return this.groupId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void updateDetailedMetrics(long timeInMs, long recordCount) {
            DetailedMetricsImpl dmi;
            Map map = ShardScanIterator.this.shardMetrics;
            synchronized (map) {
                dmi = (DetailedMetricsImpl)ShardScanIterator.this.shardMetrics.get(this.groupId);
                if (dmi == null) {
                    dmi = new DetailedMetricsImpl(this.groupId.toString(), timeInMs, recordCount);
                    ShardScanIterator.this.shardMetrics.put(this.groupId, dmi);
                    return;
                }
            }
            dmi.inc(timeInMs, recordCount);
        }

        @Override
        protected Request makeReadRequest() {
            return ShardScanIterator.this.storeImpl.makeReadRequest(ShardScanIterator.this.createOp(this.resumeSecondaryKey, this.resumePrimaryKey), this.groupId, ShardScanIterator.this.consistency, ShardScanIterator.this.requestTimeoutMs, TimeUnit.MILLISECONDS, null);
        }

        @Override
        protected void setResumeKey(Result result) {
            this.resumeSecondaryKey = ShardScanIterator.this.extractResumeSecondaryKey(result);
            this.resumePrimaryKey = result.getPrimaryResumeKey();
        }

        public String toString() {
            return "ShardStream[" + this.groupId + ", " + this.getStatus() + "]";
        }
    }
}

