/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.returning;

import java.math.BigDecimal;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.ReturningPolicy;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.InsertObjectQuery;
import org.eclipse.persistence.queries.StoredProcedureCall;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestProblemException;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.relational.EmployeeProject;

public class DescriptorExceptionTest
extends AutoVerifyTestCase {
    int errorCode;
    String more;
    DatabaseSession dbSession;
    DescriptorException exception;

    public DescriptorExceptionTest(int errorCode) {
        this.errorCode = errorCode;
        this.setName(this.getName() + " errorCode=" + Integer.toString(errorCode));
    }

    public DescriptorExceptionTest(int errorCode, String more) {
        this(errorCode);
        this.more = more;
        if (more != null) {
            this.setName(this.getName() + " " + more);
        }
    }

    protected void setup() {
        this.exception = null;
        Project project = this.getProject();
        project.setLogin((DatabaseLogin)this.getSession().getLogin().clone());
        this.dbSession = project.createDatabaseSession();
        this.dbSession.setSessionLog(this.getSession().getSessionLog());
        this.dbSession.setLogLevel(this.getSession().getLogLevel());
        this.dbSession.getIntegrityChecker().setShouldCatchExceptions(false);
    }

    protected Project getProject() {
        EmployeeProject project = new EmployeeProject();
        switch (this.errorCode) {
            case 185: {
                ClassDescriptor desc = DescriptorExceptionTest.getDescriptor(project, Employee.class);
                desc.getReturningPolicy().addFieldForInsert("EMPLOYEE.L_NAME", String.class);
                desc.getReturningPolicy().addFieldForUpdate("EMPLOYEE.L_NAME", BigDecimal.class);
                break;
            }
            case 186: {
                ClassDescriptor desc = DescriptorExceptionTest.getDescriptor(project, Employee.class);
                desc.getReturningPolicy().addFieldForInsert("EMPLOYEE.L_NAME");
                desc.getReturningPolicy().addFieldForInsertReturnOnly("EMPLOYEE.L_NAME");
                break;
            }
            case 187: {
                ClassDescriptor desc = DescriptorExceptionTest.getDescriptor(project, Employee.class);
                desc.getReturningPolicy().addFieldForInsert("EMPLOYEE.L_NAME", BigDecimal.class);
                break;
            }
            case 188: {
                ClassDescriptor desc = DescriptorExceptionTest.getDescriptor(project, Employee.class);
                desc.setOptimisticLockingPolicy(null);
                desc.getReturningPolicy().addFieldForInsert("EMPLOYEE.VERSION");
                break;
            }
            case 190: {
                ClassDescriptor desc = DescriptorExceptionTest.getDescriptor(project, Employee.class);
                desc.getReturningPolicy().addFieldForInsert("EMPLOYEE.ADDR_ID");
                break;
            }
            case 191: {
                if (this.more == null || this.more.equals("sequence")) {
                    ClassDescriptor desc = DescriptorExceptionTest.getDescriptor(project, Employee.class);
                    desc.getReturningPolicy().addFieldForInsert("EMPLOYEE.EMP_ID");
                    break;
                }
                if (this.more.equals("locking")) {
                    ClassDescriptor desc = DescriptorExceptionTest.getDescriptor(project, Employee.class);
                    desc.getReturningPolicy().addFieldForInsert("EMPLOYEE.VERSION");
                    break;
                }
                if (this.more.equals("class")) {
                    ClassDescriptor desc = DescriptorExceptionTest.getDescriptor(project, org.eclipse.persistence.testing.models.employee.domain.Project.class);
                    desc.getReturningPolicy().addFieldForInsert("PROJECT.PROJ_TYPE");
                    break;
                }
                throw new TestProblemException("Unknown case specified for RETURNING_POLICY_FIELD_NOT_SUPPORTED");
            }
            case 192: {
                ClassDescriptor desc = DescriptorExceptionTest.getDescriptor(project, Employee.class);
                desc.getReturningPolicy().addFieldForInsert("EMPLOYEE.L_NAME");
                desc.getReturningPolicy().addFieldForInsert("SALARY.SALARY");
                InsertObjectQuery insertQuery = new InsertObjectQuery();
                StoredProcedureCall call = new StoredProcedureCall();
                call.setProcedureName("Insert_Employee");
                call.addNamedArgument("P_EMP_ID", "EMP_ID");
                call.addNamedArgument("P_SALARY", "SALARY");
                call.addNamedOutputArgument("L_NAME", "L_NAME", String.class);
                insertQuery.setCall((Call)call);
                desc.getQueryManager().setInsertQuery(insertQuery);
                break;
            }
            case 193: {
                if (this.getSession().getPlatform().isOracle()) {
                    throw new TestWarningException("Test for NO_CUSTOM_QUERY_FOR_RETURNING_POLICY doesn't work on Oracle");
                }
                ClassDescriptor desc = DescriptorExceptionTest.getDescriptor(project, Employee.class);
                desc.getReturningPolicy().addFieldForInsert("EMPLOYEE.L_NAME");
            }
        }
        return project;
    }

    protected static ClassDescriptor getDescriptor(Project project, Class type) {
        ClassDescriptor desc = project.getDescriptor(type);
        if (!desc.hasReturningPolicy()) {
            desc.setReturningPolicy(new ReturningPolicy());
        }
        return desc;
    }

    protected void test() {
        try {
            this.dbSession.login();
            this.dbSession.logout();
        }
        catch (DescriptorException ex) {
            this.exception = ex;
        }
    }

    protected void verify() {
        if (this.exception == null) {
            throw new TestErrorException("No DescriptorException thrown");
        }
        if (this.exception.getErrorCode() != this.errorCode) {
            throw new TestErrorException("Wrong DescriptorException thrown: " + this.exception.getErrorCode() + "; expected: " + this.errorCode);
        }
    }
}

