/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.expressions;

import junit.framework.Test;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.expressions.ExpressionMath;
import org.eclipse.persistence.platform.database.AccessPlatform;
import org.eclipse.persistence.platform.database.DerbyPlatform;
import org.eclipse.persistence.platform.database.MySQLPlatform;
import org.eclipse.persistence.platform.database.OraclePlatform;
import org.eclipse.persistence.platform.database.SymfowarePlatform;
import org.eclipse.persistence.platform.database.TimesTenPlatform;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.testing.framework.TestSuite;
import org.eclipse.persistence.testing.models.employee.domain.Address;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.domain.LargeProject;
import org.eclipse.persistence.testing.models.employee.domain.PhoneNumber;
import org.eclipse.persistence.testing.models.employee.domain.Project;
import org.eclipse.persistence.testing.models.inheritance.Vehicle;
import org.eclipse.persistence.testing.tests.expressions.ReadAllExpressionTest;
import org.eclipse.persistence.testing.tests.expressions.ReadObjectExpressionTest;
import org.eclipse.persistence.tools.schemaframework.PopulationManager;

public class ExpressionSubSelectTestSuite
extends TestSuite {
    protected PopulationManager manager;

    public ExpressionSubSelectTestSuite() {
        this.setDescription("This suite tests expressions.");
    }

    private void addAggregateObjectJoiningTest() {
        ExpressionBuilder builder = new ExpressionBuilder();
        ExpressionBuilder parallelBuilder = new ExpressionBuilder(Employee.class);
        Expression expression = builder.get("period").equal(parallelBuilder.get("period")).and(builder.notEqual((Expression)parallelBuilder));
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 9);
        test.setExpression(expression);
        test.getQuery(true).useDistinct();
        test.setName("AggregateObjectJoiningTest");
        test.setDescription("Test .period.equal(parallelBuilder.period).  a.k.a. employees with same employment  period as someone else.");
        this.addTest((Test)test);
    }

    private void addAggregateObjectComparisonTest() {
        ExpressionBuilder builder = new ExpressionBuilder();
        ExpressionBuilder parallelBuilder = new ExpressionBuilder(Employee.class);
        Expression expression = builder.notEqual((Expression)parallelBuilder).and(builder.get("period").get("startDate").equal(parallelBuilder.get("period").get("startDate")).and(builder.get("period").get("endDate").equal(parallelBuilder.get("period").get("endDate"))));
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 9);
        test.setExpression(expression);
        test.getQuery(true).useDistinct();
        test.setName("AggregateObjectComparisonTest");
        test.setDescription("Test .period.startDate.equal(parallelBuilder.period.startDate).and(...)  a.k.a. employees with same employment  period as someone else.");
        this.addTest((Test)test);
    }

    private void addCorrelatedSubSelectTest() {
        ExpressionBuilder manager = new ExpressionBuilder(Employee.class);
        Expression employee = manager.anyOf("managedEmployees");
        Expression outerExpression = employee.anyOf("projects").get("name").equal((Object)"Problem Reporter");
        ReportQuery subQuery = new ReportQuery(Project.class, new ExpressionBuilder());
        subQuery.addCount();
        ExpressionBuilder swirlyDirlProject = subQuery.getExpressionBuilder();
        Expression correlateExpression = swirlyDirlProject.equal(employee.anyOf("projects"));
        Expression innerExpression = swirlyDirlProject.get("name").in(new Object[]{"Swirly Dirly", "Swirly Dirl"});
        subQuery.setSelectionCriteria(correlateExpression.and(innerExpression));
        Expression expression = outerExpression.and(manager.subQuery(subQuery).greaterThan(0));
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 1);
        test.setExpression(expression);
        test.setName("Correlated SubSelect Test");
        test.setDescription("Tests correlated subselects, using attributes selected in enclosing query to refine the subquery.  In this test find managers with an employee working on the problem reporter project.  Refine the query with a subselect to check if this employee also works on the Swirly Dirly project.");
        test.addUnsupportedPlatform(TimesTenPlatform.class);
        this.addTest((Test)test);
    }

    private void addSameManagerTest() {
        ExpressionBuilder emp = new ExpressionBuilder();
        ExpressionBuilder coworker = new ExpressionBuilder(Employee.class);
        Expression exp = emp.get("manager").equal(coworker.get("manager")).and(emp.notEqual((Expression)coworker));
        ReadAllQuery query = new ReadAllQuery(Employee.class, exp);
        query.useDistinct();
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 5);
        test.setExpression(exp);
        test.setQuery(query);
        test.setName("SameManagerTest");
        test.setDescription("Tests whether a parallel select will use distinct.");
        this.addTest((Test)test);
    }

    private void addParallelCorrelatedSubSelectsTest() {
        ExpressionBuilder manager = new ExpressionBuilder(Employee.class);
        Expression employee = manager.anyOf("managedEmployees");
        Expression outerAddress = employee.get("address");
        Expression expression = null;
        String[] cities = new String[]{"Ottawa", "Vancouver"};
        for (int i = 0; i < cities.length; ++i) {
            ReportQuery subQuery = new ReportQuery(Address.class, new ExpressionBuilder(Address.class));
            ExpressionBuilder address = subQuery.getExpressionBuilder();
            subQuery.addAttribute("fish", address.value(1));
            Expression correlateExpression = address.equal(outerAddress);
            Expression innerExpression = address.get("city").equal((Object)cities[i]);
            subQuery.setSelectionCriteria(correlateExpression.and(innerExpression));
            expression = manager.exists(subQuery).or(expression);
        }
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 2);
        test.setExpression(expression);
        test.getQuery(true).addNonFetchJoin(employee);
        test.setName("Parallel Correlated SubSelect Test");
        test.setDescription("Finds managers with an employee in Ottawa or an employee in Vancouver.  For bug 3381830.");
        this.addTest((Test)test);
    }

    private void addCorrelatedSubSelectExpressionsReorderedTest() {
        ExpressionBuilder manager = new ExpressionBuilder(Employee.class);
        Expression employee = manager.anyOf("managedEmployees");
        Expression outerExpression = employee.anyOf("projects").get("name").equal((Object)"Problem Reporter");
        ReportQuery subQuery = new ReportQuery(Project.class, new ExpressionBuilder());
        subQuery.addCount();
        ExpressionBuilder swirlyDirlProject = subQuery.getExpressionBuilder();
        Expression correlateExpression = swirlyDirlProject.equal(employee.anyOf("projects"));
        Expression innerExpression = swirlyDirlProject.get("name").in(new Object[]{"Swirly Dirly", "Swirly Dirl"});
        subQuery.setSelectionCriteria(correlateExpression.and(innerExpression));
        Expression expression = manager.subQuery(subQuery).greaterThan(0).and(outerExpression);
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 1);
        test.setExpression(expression);
        test.setName("Correlated SubSelect Expressions Reordered Test");
        test.setDescription("Tests correlated subselects, with the expressions to be correlated normalized by the subselect first.");
        test.addUnsupportedPlatform(TimesTenPlatform.class);
        this.addTest((Test)test);
    }

    private void addObjectEqualOrObjectEqualTest() {
        ExpressionBuilder employee = new ExpressionBuilder(Employee.class);
        Expression employeeProject = employee.anyOf("projects");
        ExpressionBuilder project = new ExpressionBuilder(Project.class);
        ReportQuery subQuery = new ReportQuery(Project.class, project);
        subQuery.addAttribute("id");
        Expression condition1 = project.equal(employeeProject).and(project.get("name").equal((Object)"Problem Reporter"));
        Expression condition2 = project.equal(employeeProject).and(project.get("name").equal((Object)"Sales Reporter"));
        subQuery.setSelectionCriteria(condition1.or(condition2));
        Expression expression = employee.exists(subQuery);
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 4);
        test.setExpression(expression);
        test.setName("Object Equal Or Object Equal Test");
        test.setDescription("Finds employees working on one of two projects.  Trying to break CR2456 with bizarre expression structure.");
        this.addTest((Test)test);
    }

    private void addOracleExampleCorrelatedSubSelectTest() {
        ExpressionBuilder wellpaidEmployee = new ExpressionBuilder(Employee.class);
        ExpressionBuilder averageEmployee = new ExpressionBuilder(Employee.class);
        ReportQuery subQuery = new ReportQuery(Employee.class, averageEmployee);
        subQuery.addAverage("salary");
        subQuery.setSelectionCriteria(averageEmployee.get("address").get("province").equal(wellpaidEmployee.get("address").get("province")));
        Expression expression = wellpaidEmployee.subQuery(subQuery).lessThan(wellpaidEmployee.get("salary"));
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 2);
        test.setExpression(expression);
        test.setName("Oracle Example Correlated SubSelect Test");
        test.setDescription("Tests correlated subselects, finds all employees who make more on average than other employees in their city.");
        test.addUnsupportedPlatform(TimesTenPlatform.class);
        this.addTest((Test)test);
    }

    private void addParralelSelectCityTest() {
        ExpressionBuilder builder = new ExpressionBuilder();
        ExpressionBuilder otherBuilder = new ExpressionBuilder(Address.class);
        Expression expression = builder.get("address").get("city").equal(otherBuilder.get("city")).and(otherBuilder.get("country").equalsIgnoreCase("canada"));
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 12);
        test.setExpression(expression);
        test.setName("ParralelSelectCityTest");
        test.setDescription("Test using two object builds in one expression");
        this.addTest((Test)test);
    }

    private void addParralelSelectSameCityTest() {
        ExpressionBuilder builder = new ExpressionBuilder();
        ExpressionBuilder otherBuilder = new ExpressionBuilder(Employee.class);
        Expression expression = builder.get("address").get("city").equal(otherBuilder.get("address").get("city")).and(builder.notEqual((Expression)otherBuilder));
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 0);
        test.setExpression(expression);
        test.setName("ParralelSelectSameCityTest");
        test.setDescription("Test using two object builds in one expression");
        this.addTest((Test)test);
    }

    private void addParralelSelectObjectComparisonTest() {
        ExpressionBuilder builder = new ExpressionBuilder();
        ExpressionBuilder otherBuilder = new ExpressionBuilder(LargeProject.class);
        Expression expression = builder.anyOf("managedEmployees").equal(otherBuilder.get("teamLeader"));
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 2);
        test.setExpression(expression);
        test.setName("ParralelSelectObjectComparisonTest");
        test.setDescription("Test using two object builders in one expression and comparing with an object comparison");
        this.addTest((Test)test);
    }

    private void addParralelSelectSameNameInsideSubSelectTest() {
        ExpressionBuilder innerBuilder = new ExpressionBuilder(Employee.class);
        ExpressionBuilder otherBuilder = new ExpressionBuilder(Employee.class);
        ExpressionBuilder outerBuilder = new ExpressionBuilder(Employee.class);
        Expression parallelExpression = innerBuilder.get("lastName").equal(otherBuilder.get("lastName")).and(innerBuilder.notEqual((Expression)otherBuilder));
        Expression correlatingExpression = innerBuilder.equal((Expression)outerBuilder);
        Expression innerExpression = correlatingExpression.and(parallelExpression);
        ReportQuery subQuery = new ReportQuery(Employee.class, innerBuilder);
        subQuery.setSelectionCriteria(innerExpression);
        subQuery.addAttribute("id");
        Expression expression = outerBuilder.exists(subQuery);
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 6);
        test.setExpression(expression);
        test.setName("ParralelSelectSameNameInsideSubSelectTest");
        test.setDescription("Tests using two object builders in one subselect expression, for 2639318");
        this.addTest((Test)test);
    }

    private void addParralelSelectSameNameTest() {
        ExpressionBuilder builder = new ExpressionBuilder();
        ExpressionBuilder otherBuilder = new ExpressionBuilder(Employee.class);
        Expression expression = builder.get("lastName").equal(otherBuilder.get("lastName")).and(builder.notEqual((Expression)otherBuilder));
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 6);
        test.setExpression(expression);
        test.setName("ParralelSelectSameNameTest");
        test.setDescription("Test using two object builds in one expression");
        this.addTest((Test)test);
    }

    private void addParallelSelectWithBatchAttributeTest() {
        ExpressionBuilder builder = new ExpressionBuilder();
        ExpressionBuilder otherBuilder = new ExpressionBuilder(Address.class);
        Expression expression = builder.getField("ADDR_ID").equal(otherBuilder.getField("ADDRESS_ID"));
        expression = expression.and(otherBuilder.get("province").equal((Object)"ONT"));
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 6);
        test.setExpression(expression);
        test.testBatchAttributesOnEmployee();
        test.setName("ParallelSelectWithBatchAttributeTest");
        test.setDescription("Test batch reading attributes from query with parallel selects.  For 2637484");
        this.addTest((Test)test);
    }

    private void addManagersOfWealthyMarriedAtWorkEmployeesTest() {
        ExpressionBuilder builder = new ExpressionBuilder();
        ExpressionBuilder innerBuilder = new ExpressionBuilder(Employee.class);
        ExpressionBuilder innerSpouses = new ExpressionBuilder(Employee.class);
        Expression innerExpression = innerBuilder.get("manager").equal((Expression)builder);
        innerExpression = innerExpression.and(innerBuilder.get("lastName").equal(innerSpouses.get("lastName")));
        innerExpression = innerExpression.and(innerBuilder.get("gender").notEqual(innerSpouses.get("gender")));
        ReportQuery subquery = new ReportQuery(Employee.class, innerBuilder);
        subquery.addAverage("family income", ExpressionMath.add((Expression)innerBuilder.get("salary"), (Object)innerSpouses.get("salary")));
        subquery.setSelectionCriteria(innerExpression);
        Expression expression = builder.subQuery(subquery).equal(140000);
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 2);
        test.setExpression(expression);
        test.testBatchAttributesOnEmployee();
        test.setName("ManagersOfWealthyMarriedAtWorkEmployeesTest");
        test.setDescription("Test executing query where subselect is a ReportQuery with ReportItems from multiple builders.  Tests batch reading too.  For 2612185.");
        test.addUnsupportedPlatform(TimesTenPlatform.class);
        this.addTest((Test)test);
    }

    private void addNotInTest() {
        ReadAllQuery query = new ReadAllQuery(Employee.class);
        ExpressionBuilder emp = new ExpressionBuilder(Employee.class);
        ExpressionBuilder phone = new ExpressionBuilder();
        ReportQuery subquery = new ReportQuery(PhoneNumber.class, phone);
        Expression subexp = phone.get("areaCode").equal((Object)"613");
        subquery.setSelectionCriteria(subexp);
        subquery.addAttribute("id");
        Expression expression = emp.get("id").notIn(subquery);
        query.setSelectionCriteria(expression);
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 2);
        test.setExpression(expression);
        test.setName("NotInTest");
        test.setDescription("Finds all employees who are not within the 613 area code.");
        this.addTest((Test)test);
    }

    private void addObjectComparisonWithBatchAttributeTest() {
        ExpressionBuilder builder = new ExpressionBuilder();
        ExpressionBuilder otherBuilder = new ExpressionBuilder(Employee.class);
        Expression expression = builder.get("lastName").equal(otherBuilder.get("lastName")).and(builder.notEqual((Expression)otherBuilder));
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 6);
        test.setExpression(expression);
        test.testBatchAttributesOnEmployee();
        test.setName("ObjectComparisonWithBatchAttributeTest");
        test.setDescription("Test batch reading attributes from query with object comparisons.  Bug 2718460.");
        this.addTest((Test)test);
    }

    private void addExistsWithBatchAttributeTest() {
        ExpressionBuilder builder = new ExpressionBuilder(Employee.class);
        ExpressionBuilder innerBuilder = new ExpressionBuilder(Address.class);
        Expression innerExpression = innerBuilder.equal(builder.get("address"));
        innerExpression = innerExpression.and(innerBuilder.get("province").equal((Object)"ONT"));
        ReportQuery subquery = new ReportQuery(Address.class, innerBuilder);
        subquery.addAttribute("id");
        subquery.setSelectionCriteria(innerExpression);
        Expression expression = builder.exists(subquery);
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 6);
        test.setExpression(expression);
        test.testBatchAttributesOnEmployee();
        test.setName("ExistsWithBatchAttributeTest");
        test.setDescription("Test batch reading attributes from query with exists (correlatedsub selects).  For 2612140.");
        this.addTest((Test)test);
    }

    private void addSubSelectInWithBatchAttributeTest() {
        ExpressionBuilder innerBuilder = new ExpressionBuilder();
        ExpressionBuilder outerBuilder = new ExpressionBuilder();
        ReportQuery subQuery = new ReportQuery(Employee.class, innerBuilder);
        subQuery.addAttribute("lastName");
        subQuery.setSelectionCriteria(innerBuilder.get("firstName").like("B%"));
        Expression expression = outerBuilder.get("lastName").in(subQuery);
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 4);
        test.setExpression(expression);
        test.testBatchAttributesOnEmployee();
        test.setName("SubSelectInWithBatchAttributeTest");
        test.setDescription("Regression test batch reading attributes from query with IN sub select, for 2612567.");
        this.addTest((Test)test);
    }

    private void addSubSelectCountTest() {
        ExpressionBuilder builder = new ExpressionBuilder();
        ExpressionBuilder innerBuilder = new ExpressionBuilder();
        ReportQuery subQuery = new ReportQuery(Employee.class, innerBuilder);
        subQuery.addCount("Count", innerBuilder.anyOf("projects").distinct());
        subQuery.setSelectionCriteria(innerBuilder.equal(builder.anyOf("managedEmployees")));
        Expression expression = builder.subQuery(subQuery).greaterThanEqual(4);
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 2);
        test.setExpression(expression);
        test.setName("SubSelectCountTest");
        test.setDescription("Test subselects with count on an object attribute.  All managers whose employees work on 4 or more projects.");
        test.addUnsupportedPlatform(TimesTenPlatform.class);
        this.addTest((Test)test);
    }

    private void addSubSelectCustomSQLTest() {
        ExpressionBuilder builder = new ExpressionBuilder();
        ReportQuery subQuery = new ReportQuery(Employee.class, new ExpressionBuilder());
        subQuery.addMinimum("salary");
        subQuery.setSQLString("Select Min(s.SALARY) from EMPLOYEE e, SALARY s where e.EMP_ID = s.EMP_ID");
        Expression expression = builder.get("salary").equal((Object)subQuery);
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 1);
        test.setExpression(expression);
        test.setName("SubSelectCustomSQLTest");
        test.setDescription("Test subselects with max salary through custom SQL");
        this.addTest((Test)test);
    }

    private void addSubSelectEmployeeWithBusyManagerTest() {
        ExpressionBuilder employee = new ExpressionBuilder(Employee.class);
        Expression manager = employee.get("manager");
        ExpressionBuilder otherEmployee = new ExpressionBuilder(Employee.class);
        ReportQuery subQuery = new ReportQuery(Employee.class, otherEmployee);
        subQuery.addAttribute("id");
        subQuery.setSelectionCriteria(otherEmployee.get("manager").equal(manager).and(otherEmployee.equal((Expression)employee).not()));
        Expression expression = employee.exists(subQuery);
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 5);
        test.setExpression(expression);
        test.setName("SubSelect Employee With Busy Manager Test");
        test.setDescription("Tests obj equals obj with 1:1 join optimization.  Finds employees whos managers manage at least one other.");
        this.addTest((Test)test);
    }

    private void addSubSelectMaxManagerSalaryTest() {
        ExpressionBuilder builder = new ExpressionBuilder();
        ReportQuery subQuery = new ReportQuery(Employee.class, new ExpressionBuilder());
        subQuery.addMaximum("salary");
        Expression expression = builder.get("manager").get("salary").equal((Object)subQuery);
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 0);
        test.setExpression(expression);
        test.setName("SubSelectMaxManagerSalaryTest");
        test.setDescription("Test subselects with max and equals");
        this.addTest((Test)test);
    }

    private void addSubSelectMaxPostalCodeTest() {
        ExpressionBuilder builder = new ExpressionBuilder();
        ReportQuery subQuery = new ReportQuery(Address.class, new ExpressionBuilder());
        subQuery.addMaximum("postalCode");
        Expression expression = builder.get("postalCode").equal((Object)subQuery);
        ReadAllExpressionTest test = new ReadAllExpressionTest(Address.class, 1);
        test.setExpression(expression);
        test.setName("SubSelectMaxPostalCodeTest");
        test.setDescription("Test subselects with max and equals");
        this.addTest((Test)test);
    }

    private void addSubSelectMaxSalaryInOttawaTest() {
        ExpressionBuilder builder = new ExpressionBuilder();
        ReportQuery subQuery = new ReportQuery(Employee.class, new ExpressionBuilder());
        subQuery.addMaximum("salary");
        subQuery.setSelectionCriteria(subQuery.getExpressionBuilder().get("address").get("city").equal((Object)"Ottawa"));
        Expression expression = builder.get("salary").equal((Object)subQuery);
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 1);
        test.setExpression(expression);
        test.setName("SubSelectMaxSalaryInOttawaTest");
        test.setDescription("Test subselects with max and equals with values");
        this.addTest((Test)test);
    }

    private void addSubSelectMaxSalaryTest() {
        ExpressionBuilder builder = new ExpressionBuilder();
        ReportQuery subQuery = new ReportQuery(Employee.class, new ExpressionBuilder());
        subQuery.addMaximum("salary");
        Expression expression = builder.get("salary").equal((Object)subQuery);
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 1);
        test.setExpression(expression);
        test.setName("SubSelectMaxSalaryTest");
        test.setDescription("Test subselects with max and equals");
        this.addTest((Test)test);
    }

    private void addSubSelectNestedSalaryTest() {
        ExpressionBuilder builder = new ExpressionBuilder();
        ReportQuery subQuery1 = new ReportQuery(Address.class, new ExpressionBuilder());
        subQuery1.addAttribute("city");
        subQuery1.setSelectionCriteria(subQuery1.getExpressionBuilder().get("country").likeIgnoreCase("canada"));
        ReportQuery subQuery2 = new ReportQuery(Employee.class, new ExpressionBuilder());
        subQuery2.addMaximum("salary");
        subQuery2.setSelectionCriteria(subQuery2.getExpressionBuilder().get("address").get("city").in(subQuery1));
        Expression expression = builder.get("salary").greaterThan((Object)subQuery2).and(builder.get("address").get("country").likeIgnoreCase("canada").not());
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 0);
        test.setExpression(expression);
        test.setName("SubSelectNestedSalaryTest");
        test.setDescription("Test nested subselects with max salary and in cities");
        this.addTest((Test)test);
    }

    private void addSubSelectNoProjectsTest() {
        ExpressionBuilder builder = new ExpressionBuilder();
        ReportQuery subQuery = new ReportQuery(Project.class, new ExpressionBuilder());
        subQuery.addAttribute("id");
        subQuery.setSelectionCriteria(subQuery.getExpressionBuilder().equal(builder.anyOf("projects")));
        Expression expression = builder.notExists(subQuery);
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 6);
        test.setExpression(expression);
        test.setName("SubSelectNoProjectsTest");
        test.setDescription("Test subselects with employees with no projects");
        this.addTest((Test)test);
    }

    private void addSubSelectCorrelatedNestedTest() {
        ExpressionBuilder builder = new ExpressionBuilder();
        ExpressionBuilder subQueryBuilder = new ExpressionBuilder();
        ReportQuery nestedSubQuery = new ReportQuery(Employee.class, new ExpressionBuilder());
        nestedSubQuery.addCount();
        nestedSubQuery.setSelectionCriteria(nestedSubQuery.getExpressionBuilder().equal(subQueryBuilder.anyOf("managedEmployees")));
        ReportQuery subQuery = new ReportQuery(Employee.class, subQueryBuilder);
        subQuery.addCount();
        subQuery.setSelectionCriteria(subQueryBuilder.equal(builder.anyOf("managedEmployees")).and(subQueryBuilder.subQuery(nestedSubQuery).greaterThan(0)));
        Expression expression = builder.subQuery(subQuery).greaterThan(0);
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 3);
        test.setExpression(expression);
        test.setName("SubSelectCorrelatedNestedTest");
        test.setDescription("Finds all managers of managers.  Tests nested correlated subselects for bug 2627019");
        test.addUnsupportedPlatform(TimesTenPlatform.class);
        this.addTest((Test)test);
    }

    private void addSubSelectTwoManagedEmployeesAnyOfTest() {
        ExpressionBuilder builder = new ExpressionBuilder();
        ReportQuery subQuery = new ReportQuery(Employee.class, new ExpressionBuilder());
        subQuery.addCount();
        subQuery.setSelectionCriteria(subQuery.getExpressionBuilder().equal(builder.anyOf("managedEmployees")));
        Expression expression = builder.subQuery(subQuery).greaterThan(2);
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 1);
        test.setExpression(expression);
        test.setName("SubSelectTwoManagedEmployeesAnyOfTest");
        test.setDescription("Test subselects with employees with more than 2 managed employees");
        test.addUnsupportedPlatform(TimesTenPlatform.class);
        this.addTest((Test)test);
    }

    private void addSubSelectTwoManagedEmployeesTest() {
        ExpressionBuilder builder = new ExpressionBuilder();
        ReportQuery subQuery = new ReportQuery(Employee.class, new ExpressionBuilder());
        subQuery.addCount();
        subQuery.setSelectionCriteria(subQuery.getExpressionBuilder().get("manager").equal((Expression)builder));
        Expression expression = builder.subQuery(subQuery).greaterThan(2);
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 1);
        test.setExpression(expression);
        test.setName("SubSelectTwoManagedEmployeesTest");
        test.setDescription("Test subselects with employees with more than 2 managed employees");
        test.addUnsupportedPlatform(AccessPlatform.class);
        test.addUnsupportedPlatform(TimesTenPlatform.class);
        this.addTest((Test)test);
    }

    private void addSubSelectTwoProjectsTest() {
        ExpressionBuilder builder = new ExpressionBuilder();
        ReportQuery subQuery = new ReportQuery(Project.class, new ExpressionBuilder());
        subQuery.addCount();
        subQuery.setSelectionCriteria(subQuery.getExpressionBuilder().equal(builder.anyOf("projects")));
        Expression expression = builder.subQuery(subQuery).lessThan(2).not();
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 4);
        test.setExpression(expression);
        test.setName("SubSelectTwoProjectsTest");
        test.setDescription("Test subselects with employees with 2 projects");
        test.addUnsupportedPlatform(TimesTenPlatform.class);
        this.addTest((Test)test);
    }

    private void addSubSelectUnderpaidManagersTest() {
        ExpressionBuilder manager = new ExpressionBuilder(Employee.class);
        ExpressionBuilder employee = new ExpressionBuilder(Employee.class);
        ReportQuery subQuery = new ReportQuery(Employee.class, employee);
        subQuery.addAttribute("id");
        Expression managedCriteria = employee.get("manager").equal((Expression)manager);
        Expression overPaidCriteria = employee.get("salary").greaterThan(manager.get("salary"));
        subQuery.setSelectionCriteria(managedCriteria.and(overPaidCriteria));
        Expression underpaidManager = manager.exists(subQuery);
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 3);
        test.setExpression(underpaidManager);
        test.setName("SubSelect Underpaid Managers Test");
        test.setDescription("Tests correlated subselects, finds all managers who make less than an employee they manage.");
        this.addTest((Test)test);
    }

    private void addVehicleViewTest() {
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = builder.get("owner").get("name").equal((Object)"ABC").and(builder.get("owner").get("name").equal((Object)"ABC")).and(builder.get("passengerCapacity").equal(-1).not());
        ExpressionBuilder sub = new ExpressionBuilder(Vehicle.class);
        ReportQuery subQuery = new ReportQuery(Vehicle.class, sub);
        subQuery.addAttribute("passengerCapacity");
        Expression subExpression = sub.get("owner").get("name").equal((Object)"ABC").and(sub.get("owner").get("name").equal((Object)"ABC")).and(sub.get("passengerCapacity").equal(-1).not()).and(builder.equal((Expression)sub));
        subQuery.setSelectionCriteria(subExpression);
        expression = expression.and(builder.exists(subQuery));
        ReadAllExpressionTest test = new ReadAllExpressionTest(Vehicle.class, 5);
        ReadAllQuery query = new ReadAllQuery(Vehicle.class, expression);
        query.addOrdering(builder.get("owner").get("name"));
        query.addJoinedAttribute("owner");
        query.useDistinct();
        test.setQuery(query);
        test.setName("VehicleViewOrderByJoinTest");
        test.setDescription("Test inheritance view with ordering and joining.");
        test.addSupportedPlatform(OraclePlatform.class);
        this.addTest((Test)test);
    }

    public void addTests() {
        this.setManager(PopulationManager.getDefaultManager());
        this.addAggregateObjectJoiningTest();
        this.addAggregateObjectComparisonTest();
        this.addCorrelatedSubSelectTest();
        this.addCorrelatedSubSelectExpressionsReorderedTest();
        this.addParallelCorrelatedSubSelectsTest();
        this.addExistsWithBatchAttributeTest();
        this.addManagersOfWealthyMarriedAtWorkEmployeesTest();
        this.addNotInTest();
        this.addObjectComparisonWithBatchAttributeTest();
        this.addObjectEqualOrObjectEqualTest();
        this.addOracleExampleCorrelatedSubSelectTest();
        this.addParralelSelectCityTest();
        this.addParralelSelectSameCityTest();
        this.addParralelSelectSameNameInsideSubSelectTest();
        this.addParralelSelectSameNameTest();
        this.addParallelSelectWithBatchAttributeTest();
        this.addParralelSelectObjectComparisonTest();
        this.addSubSelectCorrelatedNestedTest();
        this.addSubSelectCountTest();
        this.addSubSelectEmployeeTest();
        this.addSubSelectEmployeeWithBusyManagerTest();
        this.addSubSelectInWithBatchAttributeTest();
        this.addSubSelectMaxSalaryTest();
        this.addSubSelectMaxPostalCodeTest();
        this.addSubSelectMaxSalaryInOttawaTest();
        this.addSubSelectMaxManagerSalaryTest();
        this.addSubSelectNoProjectsTest();
        this.addSubSelectCustomSQLTest();
        this.addSubSelectTwoManagedEmployeesTest();
        this.addSubSelectTwoManagedEmployeesAnyOfTest();
        this.addSubSelectNestedSalaryTest();
        this.addSubSelectTwoProjectsTest();
        this.addSubSelectUnderpaidManagersTest();
        this.addVehicleViewTest();
        this.addUpperCaseTest();
        this.addVehicleViewTest1();
        this.addSameManagerTest();
        this.addSubSelectSelectClauseTest();
        this.addSubSelectSelectClauseTest2();
        this.addSubSelectFromClauseTest();
        this.addSubSelectFromClauseTest2();
        this.addSubSelectObjectEqualsTest();
    }

    private void addSubSelectEmployeeTest() {
        ReadAllQuery query = new ReadAllQuery(Employee.class);
        ExpressionBuilder raqb = new ExpressionBuilder(Employee.class);
        ExpressionBuilder rqb = new ExpressionBuilder();
        ReportQuery rq = new ReportQuery(PhoneNumber.class, rqb);
        Expression exp = rqb.get("id").equal(raqb.get("id"));
        rq.setSelectionCriteria(exp);
        rq.addAttribute("id");
        Expression expression = raqb.get("id").in(rq);
        query.setSelectionCriteria(expression);
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 12);
        test.setExpression(expression);
        test.setName("SubSelectEmployeeTest");
        test.setDescription("Test subselects with employees and PhoneNumbers");
        this.addTest((Test)test);
    }

    private void addUpperCaseTest() {
        Employee employee = (Employee)this.getManager().getObject(new Employee().getClass(), "0002");
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = builder.get("address").get("city").toUpperCase().equal((Object)"OTTAWA");
        ReadObjectExpressionTest test = new ReadObjectExpressionTest(employee, expression);
        test.setName("UpperCaseExpressionTest");
        test.setDescription("Test UPPER expression");
        this.addTest((Test)test);
    }

    private void addVehicleViewTest1() {
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = builder.get("owner").get("name").equal((Object)"ABC").and(builder.get("owner").get("name").equal((Object)"ABC")).and(builder.get("passengerCapacity").equal(-1).not());
        ReadAllExpressionTest test = new ReadAllExpressionTest(Vehicle.class, 5);
        test.setExpression(expression);
        test.setName("VehicleViewTest1");
        test.setDescription("Test expression against view, or multiple table subclass read.");
        this.addTest((Test)test);
    }

    private void addSubSelectObjectEqualsTest() {
        ExpressionBuilder builder = new ExpressionBuilder(Employee.class);
        ReportQuery subQuery = new ReportQuery(Project.class, new ExpressionBuilder(Project.class));
        subQuery.addCount("id");
        subQuery.setSelectionCriteria(subQuery.getExpressionBuilder().equal(builder.anyOf("projects")));
        ReportQuery query = new ReportQuery(Employee.class, builder);
        query.addAttribute("id");
        query.addAttribute("firstName");
        query.setSelectionCriteria(builder.exists(subQuery));
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 12);
        test.addUnsupportedPlatform(DerbyPlatform.class);
        test.setQuery((ReadAllQuery)query);
        test.setName("SubSelectObjectEqualsTest");
        test.setDescription("Test subselects that uses an object eqauls");
        this.addTest((Test)test);
    }

    private void addSubSelectSelectClauseTest() {
        ExpressionBuilder builder = new ExpressionBuilder(Employee.class);
        ReportQuery subQuery = new ReportQuery(Project.class, new ExpressionBuilder(Project.class));
        subQuery.addCount("id");
        subQuery.setSelectionCriteria(subQuery.getExpressionBuilder().equal(builder.anyOf("projects")));
        ReportQuery query = new ReportQuery(Employee.class, builder);
        query.addAttribute("id");
        query.addAttribute("firstName");
        query.addItem("count", builder.subQuery(subQuery));
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 12);
        test.addUnsupportedPlatform(SymfowarePlatform.class);
        test.setQuery((ReadAllQuery)query);
        test.setName("SubSelectSelectClauseTest");
        test.setDescription("Test subselects in the select clause");
        this.addTest((Test)test);
    }

    private void addSubSelectSelectClauseTest2() {
        ExpressionBuilder builder = new ExpressionBuilder(Employee.class);
        ReportQuery subQuery = new ReportQuery(Project.class, new ExpressionBuilder(Project.class));
        subQuery.addCount("id");
        subQuery.setSelectionCriteria(subQuery.getExpressionBuilder().get("id").equal(builder.anyOf("projects").get("id")));
        ReportQuery query = new ReportQuery(Employee.class, builder);
        query.addAttribute("id");
        query.addAttribute("firstName");
        query.addItem("count", builder.subQuery(subQuery));
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 12);
        test.addUnsupportedPlatform(SymfowarePlatform.class);
        test.setQuery((ReadAllQuery)query);
        test.setName("SubSelectSelectClauseTest2");
        test.setDescription("Test subselects in the select clause");
        this.addTest((Test)test);
    }

    private void addSubSelectFromClauseTest() {
        ExpressionBuilder builder = new ExpressionBuilder(Employee.class);
        ReportQuery subQuery = new ReportQuery(LargeProject.class, new ExpressionBuilder(LargeProject.class));
        subQuery.addAttribute("id");
        ReportQuery query = new ReportQuery(Employee.class, builder);
        query.addAttribute("id");
        query.addAttribute("firstName");
        Expression alias = builder.getAlias(builder.subQuery(subQuery));
        query.addNonFetchJoin(alias);
        query.setSelectionCriteria(builder.get("id").equal(alias.get("id")).and(builder.get("id").notEqual(alias.get("id"))));
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 0);
        test.setQuery((ReadAllQuery)query);
        test.setName("SubSelectFromClauseTest");
        test.setDescription("Test subselects in the from clause");
        this.addTest((Test)test);
    }

    private void addSubSelectFromClauseTest2() {
        ExpressionBuilder builder = new ExpressionBuilder(Employee.class);
        ReportQuery subQuery = new ReportQuery(LargeProject.class, new ExpressionBuilder(LargeProject.class));
        subQuery.addItem("id", subQuery.getExpressionBuilder().get("id").average());
        subQuery.addItem("id2", subQuery.getExpressionBuilder().get("id").maximum());
        ReportQuery query = new ReportQuery(Employee.class, builder);
        query.addItem("e", (Expression)builder);
        Expression alias = builder.getAlias(builder.subQuery(subQuery));
        query.addNonFetchJoin(alias);
        query.setSelectionCriteria(builder.get("id").equal(alias.get("id")).and(builder.get("id").notEqual(alias.get("id2"))));
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 0);
        test.setQuery((ReadAllQuery)query);
        test.setName("SubSelectFromClauseTest2");
        test.setDescription("Test subselects in the from clause");
        test.addUnsupportedPlatform(MySQLPlatform.class);
        test.addUnsupportedPlatform(DerbyPlatform.class);
        this.addTest((Test)test);
    }

    protected PopulationManager getManager() {
        return this.manager;
    }

    protected void setManager(PopulationManager theManager) {
        this.manager = theManager;
    }
}

