/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.util.registry;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TimeoutSocket
extends Socket {
    private volatile boolean readActivity;
    private int pendingReads = 0;
    private final Object pendingReadsSync = new Object();
    private volatile int timeoutMs;
    private long lastCheckMs = 0L;
    private volatile boolean closedTimeout;

    public TimeoutSocket(int timeoutMs) {
        this.timeoutMs = timeoutMs;
        this.readActivity = true;
    }

    public void setTimeoutMs(int timeoutMs) {
        this.timeoutMs = timeoutMs;
        this.readActivity = true;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new TimeoutInputStream(super.getInputStream());
    }

    @Override
    public synchronized void close() throws IOException {
        super.close();
        this.readActivity = false;
    }

    private void resetActivityCounter(long timeMs) {
        this.lastCheckMs = timeMs;
        this.readActivity = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isActive(long timeMs, Logger logger) {
        block12: {
            if (this.isClosed()) {
                return false;
            }
            if (!this.isConnected()) {
                return true;
            }
            if (this.readActivity) {
                this.resetActivityCounter(timeMs);
                return true;
            }
            if (this.timeoutMs == 0 || timeMs - this.lastCheckMs < (long)this.timeoutMs) {
                return true;
            }
            Object object = this.pendingReadsSync;
            synchronized (object) {
                if (this.pendingReads == 0) {
                    return true;
                }
                this.closedTimeout = true;
            }
            String message = "Inactive socket " + this + " timed out and was forcibly closed, timeout: " + this.timeoutMs + " ms";
            if (logger == null) {
                System.err.println(message);
            } else {
                logger.info(message);
            }
            try {
                this.close();
            }
            catch (IOException e) {
                if (logger == null) break block12;
                logger.log(Level.FINEST, "Exception on close", e);
            }
        }
        return false;
    }

    private class TimeoutInputStream
    extends FilterInputStream {
        private int bytesRead;

        TimeoutInputStream(InputStream in) {
            super(in);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public int read() throws IOException {
            Object object = TimeoutSocket.this.pendingReadsSync;
            synchronized (object) {
                TimeoutSocket.this.pendingReads++;
            }
            try {
                try {
                    object = this;
                    synchronized (object) {
                        int result = super.read();
                        if (result > 0) {
                            TimeoutSocket.this.readActivity = true;
                            this.bytesRead += result;
                        }
                        int n = result;
                    }
                }
                finally {
                    this.checkClosedTimeout();
                }
            }
            catch (Throwable throwable) {
                Object object2 = TimeoutSocket.this.pendingReadsSync;
                synchronized (object2) {
                    TimeoutSocket.this.pendingReads--;
                    throw throwable;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkClosedTimeout() throws SocketTimeoutException {
            if (TimeoutSocket.this.closedTimeout) {
                int br;
                TimeoutInputStream timeoutInputStream = this;
                synchronized (timeoutInputStream) {
                    br = this.bytesRead;
                }
                SocketTimeoutException e = new SocketTimeoutException("Read interrupted after stream transferred " + br + " bytes because inactive socket " + TimeoutSocket.this + " timed out and was forcibly closed, timeout: " + TimeoutSocket.this.timeoutMs + " ms");
                e.bytesTransferred = br;
                throw e;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public int read(byte[] b) throws IOException {
            Object object = TimeoutSocket.this.pendingReadsSync;
            synchronized (object) {
                TimeoutSocket.this.pendingReads++;
            }
            try {
                try {
                    object = this;
                    synchronized (object) {
                        int result = super.read(b);
                        if (result > 0) {
                            TimeoutSocket.this.readActivity = true;
                            this.bytesRead += result;
                        }
                        int n = result;
                    }
                }
                finally {
                    this.checkClosedTimeout();
                }
            }
            catch (Throwable throwable) {
                Object object2 = TimeoutSocket.this.pendingReadsSync;
                synchronized (object2) {
                    TimeoutSocket.this.pendingReads--;
                    throw throwable;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            Object object = TimeoutSocket.this.pendingReadsSync;
            synchronized (object) {
                TimeoutSocket.this.pendingReads++;
            }
            try {
                try {
                    object = this;
                    synchronized (object) {
                        int result = super.read(b, off, len);
                        if (result > 0) {
                            TimeoutSocket.this.readActivity = true;
                            this.bytesRead += result;
                        }
                        int n = result;
                    }
                }
                finally {
                    this.checkClosedTimeout();
                }
            }
            catch (Throwable throwable) {
                Object object2 = TimeoutSocket.this.pendingReadsSync;
                synchronized (object2) {
                    TimeoutSocket.this.pendingReads--;
                    throw throwable;
                }
            }
        }
    }
}

