/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.validation;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.descriptors.copying.CloneCopyPolicy;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.IntegrityChecker;
import org.eclipse.persistence.testing.tests.validation.EmployeeWithProblems;
import org.eclipse.persistence.testing.tests.validation.ExceptionTest;

public class TargetInvocationWhileCloningTest
extends ExceptionTest {
    EmployeeWithProblems person;
    IntegrityChecker orgIntegrityChecker;
    CloneCopyPolicy policy;
    ClassDescriptor descriptor;

    public TargetInvocationWhileCloningTest() {
        this.setDescription("This tests Target Invocation While Cloning (TL-ERROR 97)");
    }

    protected void setup() {
        this.expectedException = DescriptorException.targetInvocationWhileCloning(null, null, null, null);
        this.person = new EmployeeWithProblems();
        this.descriptor = new RelationalDescriptor();
        this.descriptor.setJavaClass(EmployeeWithProblems.class);
        this.policy = new CloneCopyPolicy();
        this.policy.setMethodName("getIllegalAccess");
        this.policy.setDescriptor(this.descriptor);
        this.orgIntegrityChecker = this.getSession().getIntegrityChecker();
        this.getSession().setIntegrityChecker(new IntegrityChecker());
        this.getSession().getIntegrityChecker().dontCatchExceptions();
    }

    @Override
    public void reset() {
        this.getSession().setIntegrityChecker(this.orgIntegrityChecker);
    }

    public void test() {
        try {
            this.policy.initialize(this.getSession());
            this.policy.buildClone((Object)this.person, this.getSession());
        }
        catch (EclipseLinkException exception) {
            this.caughtException = exception;
        }
    }
}

