/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.clientserver;

import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.server.ConnectionPool;
import org.eclipse.persistence.sessions.server.ServerSession;
import org.eclipse.persistence.testing.framework.TestCase;

public class ConnectionPoolSizingTest
extends TestCase {
    protected int minConnections = 64;
    protected int maxConnections = 64;
    protected int initialConnections = 2;
    protected ServerSession serverSession;

    public ConnectionPoolSizingTest() {
        this.setDescription("Validate that the default connection pool's connection settings are initialized correctly");
    }

    public void test() {
        Project project = new Project(new DatabaseLogin());
        this.serverSession = (ServerSession)project.createServerSession(this.initialConnections, this.minConnections, this.maxConnections);
    }

    public void verify() {
        ConnectionPoolSizingTest.assertNotNull((String)"ServerSession is null", (Object)this.serverSession);
        ConnectionPool defaultPool = this.serverSession.getConnectionPool("default");
        ConnectionPoolSizingTest.assertNotNull((String)"Default connection pool is null", (Object)defaultPool);
        ConnectionPoolSizingTest.assertEquals((String)"ConnectionPool has invalid minimum # of connections", (int)this.minConnections, (int)defaultPool.getMinNumberOfConnections());
        ConnectionPoolSizingTest.assertEquals((String)"ConnectionPool has invalid maximum # of connections", (int)this.maxConnections, (int)defaultPool.getMaxNumberOfConnections());
        ConnectionPoolSizingTest.assertEquals((String)"ConnectionPool has invalid initial # of connections", (int)this.initialConnections, (int)defaultPool.getInitialNumberOfConnections());
    }
}

