/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.libraries.asm.util;

import org.eclipse.persistence.internal.libraries.asm.AnnotationVisitor;
import org.eclipse.persistence.internal.libraries.asm.Attribute;
import org.eclipse.persistence.internal.libraries.asm.RecordComponentVisitor;
import org.eclipse.persistence.internal.libraries.asm.TypePath;
import org.eclipse.persistence.internal.libraries.asm.TypeReference;
import org.eclipse.persistence.internal.libraries.asm.util.CheckAnnotationAdapter;
import org.eclipse.persistence.internal.libraries.asm.util.CheckClassAdapter;
import org.eclipse.persistence.internal.libraries.asm.util.CheckMethodAdapter;

public class CheckRecordComponentAdapter
extends RecordComponentVisitor {
    private boolean visitEndCalled;

    public CheckRecordComponentAdapter(RecordComponentVisitor recordComponentVisitor) {
        this(0x1080000, recordComponentVisitor);
        if (this.getClass() != CheckRecordComponentAdapter.class) {
            throw new IllegalStateException();
        }
    }

    protected CheckRecordComponentAdapter(int api, RecordComponentVisitor recordComponentVisitor) {
        super(api, recordComponentVisitor);
    }

    @Override
    public AnnotationVisitor visitAnnotationExperimental(String descriptor, boolean visible) {
        this.checkVisitEndNotCalled();
        CheckMethodAdapter.checkDescriptor(49, descriptor, false);
        return new CheckAnnotationAdapter(super.visitAnnotationExperimental(descriptor, visible));
    }

    @Override
    public AnnotationVisitor visitTypeAnnotationExperimental(int typeRef, TypePath typePath, String descriptor, boolean visible) {
        this.checkVisitEndNotCalled();
        int sort = new TypeReference(typeRef).getSort();
        if (sort != 19) {
            throw new IllegalArgumentException("Invalid type reference sort 0x" + Integer.toHexString(sort));
        }
        CheckClassAdapter.checkTypeRef(typeRef);
        CheckMethodAdapter.checkDescriptor(49, descriptor, false);
        return new CheckAnnotationAdapter(super.visitTypeAnnotationExperimental(typeRef, typePath, descriptor, visible));
    }

    @Override
    public void visitAttributeExperimental(Attribute attribute) {
        this.checkVisitEndNotCalled();
        if (attribute == null) {
            throw new IllegalArgumentException("Invalid attribute (must not be null)");
        }
        super.visitAttributeExperimental(attribute);
    }

    @Override
    public void visitEndExperimental() {
        this.checkVisitEndNotCalled();
        this.visitEndCalled = true;
        super.visitEndExperimental();
    }

    private void checkVisitEndNotCalled() {
        if (this.visitEndCalled) {
            throw new IllegalStateException("Cannot call a visit method after visitEnd has been called");
        }
    }
}

