/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries.optimization;

import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.testing.framework.ReadAllTest;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.domain.LargeProject;

public class ReadAllJoinReadingTest
extends ReadAllTest {
    public String attribute;

    public ReadAllJoinReadingTest(int size, String attribute) {
        super(LargeProject.class, size);
        this.setName("JoinReadingTest" + attribute);
        this.attribute = attribute;
    }

    protected void setup() {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        super.setup();
    }

    protected void verify() throws Exception {
        super.verify();
        ContainerPolicy aContainerPolicy = this.getQuery().getContainerPolicy();
        Object iter = aContainerPolicy.iteratorFor(this.objectsFromDatabase);
        while (aContainerPolicy.hasNext(iter)) {
            LargeProject proj = (LargeProject)aContainerPolicy.next(iter, this.getAbstractSession());
            if (!proj.teamLeader.isInstantiated()) {
                throw new TestErrorException("teamLeader value holder not instantiated.");
            }
            if (!((Employee)proj.getTeamLeader()).address.isInstantiated()) {
                throw new TestErrorException("teamLeader address value holder not instantiated.");
            }
            if (proj.getTeamLeader().getAddress().getCity().length() != 0) continue;
            throw new TestErrorException("Address wrong.");
        }
    }
}

