/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.performance.reading;

import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.models.performance.toplink.Employee;
import org.eclipse.persistence.testing.tests.performance.PerformanceTest;

public class ReadAllComplexExpressionUnitOfWorkConformEmployeeTest
extends PerformanceTest {
    protected UnitOfWork uow;

    public ReadAllComplexExpressionUnitOfWorkConformEmployeeTest() {
        this.setDescription("This tests the performance of conforming queries.");
    }

    @Override
    public void setup() {
        this.uow = this.getSession().acquireUnitOfWork();
        Vector employees = this.uow.readAllObjects(Employee.class);
        for (Employee employee : employees) {
            employee.getAddress();
            employee.getPhoneNumbers().size();
        }
        this.uow.deleteObject(employees.get(5));
        this.uow.registerNewObject((Object)new Employee());
        Employee changedEmployee = (Employee)employees.get(10);
        changedEmployee.setFirstName("Bob");
    }

    @Override
    public void test() throws Exception {
        ReadAllQuery query = new ReadAllQuery(Employee.class);
        ExpressionBuilder employee = new ExpressionBuilder();
        query.conformResultsInUnitOfWork();
        query.setSelectionCriteria(employee.get("firstName").equal((Object)"Brendan").and(employee.get("salary").equal(100000)).and(employee.get("period").get("startDate").equal((Object)Helper.dateFromString((String)"1901-12-31"))).and(employee.get("address").get("city").like("%pean%")).and(employee.anyOf("phoneNumbers").get("areaCode").equal((Object)"613")));
        List result = (List)this.getSession().executeQuery((DatabaseQuery)query);
    }
}

