/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries;

import java.sql.SQLException;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.DirectReadQuery;
import org.eclipse.persistence.queries.ScrollableCursor;
import org.eclipse.persistence.queries.StoredProcedureCall;
import org.eclipse.persistence.testing.framework.TestCase;

public class ScrollableCursorForwardOnlyResultSetTest
extends TestCase {
    protected ScrollableCursor cursor;
    protected DatabaseException caughtException = null;

    public ScrollableCursorForwardOnlyResultSetTest() {
        this.setDescription("Test the scrollable cursor hasNext() on a forward only result set");
    }

    protected void setup() {
        if (!this.getSession().getPlatform().isOracle()) {
            this.throwWarning("This test is intended for Oracle databases only.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test() {
        StoredProcedureCall spCall = new StoredProcedureCall();
        spCall.setProcedureName("Read_All_Employees");
        spCall.useNamedCursorOutputAsResultSet("RESULT_CURSOR");
        DirectReadQuery query = new DirectReadQuery();
        query.setCall((Call)spCall);
        query.useScrollableCursor();
        this.cursor = (ScrollableCursor)this.getSession().executeQuery((DatabaseQuery)query);
        try {
            if (this.cursor.getResultSet().isAfterLast() && this.cursor.getResultSet().getType() == 1003) {
                this.throwWarning("The ResultSet returned from the query is TYPE_FORWARD_ONLY and initialized to afterLast.");
            }
        }
        catch (SQLException sqle) {
            this.throwWarning("Unexpected SQLException thrown while checking the ResultSet.");
        }
        try {
            while (this.cursor.hasNext()) {
                this.cursor.next();
            }
        }
        catch (DatabaseException dbe) {
            this.caughtException = dbe;
        }
        finally {
            if (this.cursor != null) {
                this.cursor.close();
            }
        }
    }

    protected void verify() {
        if (this.caughtException != null) {
            if (this.caughtException.getDatabaseErrorCode() == 17075) {
                this.throwError("The scrollable cursor can't iterate a forward only result set", this.caughtException);
            } else {
                this.throwError(this.caughtException.getMessage(), this.caughtException);
            }
        }
    }
}

