/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.junit.cache;

import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.persistence.internal.cache.AdvancedProcessor;
import org.eclipse.persistence.internal.cache.ComputableTask;
import org.eclipse.persistence.internal.cache.Memoizer;
import org.eclipse.persistence.testing.framework.TestCase;

public class AdvancedProcessorTestCase
extends TestCase {
    private AdvancedProcessor processor;
    private MutableComputableTask<Integer, Integer> computableTask;

    public void test() throws Exception {
        this.testCompute();
        this.testExpire();
    }

    public void testCompute() throws Exception {
        AdvancedProcessorTestCase.assertEquals((Object)this.processor.compute(this.computableTask.setArg(5), (Object)5), (Object)10);
        Field fieldOnProcessor = AdvancedProcessor.class.getDeclaredField("memoizer");
        fieldOnProcessor.setAccessible(true);
        Memoizer memoizer = (Memoizer)fieldOnProcessor.get(this.processor);
        Field fieldOnMemoizer = Memoizer.class.getDeclaredField("cache");
        fieldOnMemoizer.setAccessible(true);
        Map memoizerCache = (Map)fieldOnMemoizer.get(memoizer);
        Object futureAfterFirstComputation = memoizerCache.values().iterator().next();
        this.processor.compute(this.computableTask.setArg(5), (Object)5);
        Object futureAfterSecondComputation = memoizerCache.values().iterator().next();
        AdvancedProcessorTestCase.assertTrue((memoizerCache.values().size() == 1 ? 1 : 0) != 0);
        AdvancedProcessorTestCase.assertTrue((futureAfterFirstComputation == futureAfterSecondComputation ? 1 : 0) != 0);
        fieldOnProcessor.setAccessible(false);
        fieldOnMemoizer.setAccessible(false);
    }

    public void testExpire() throws Exception {
        AdvancedProcessorTestCase.assertEquals((Object)this.processor.compute(this.computableTask.setArg(5), (Object)5), (Object)10);
        Field fieldOnProcessor = AdvancedProcessor.class.getDeclaredField("memoizer");
        fieldOnProcessor.setAccessible(true);
        Memoizer memoizer = (Memoizer)fieldOnProcessor.get(this.processor);
        Field fieldOnMemoizer = Memoizer.class.getDeclaredField("cache");
        fieldOnMemoizer.setAccessible(true);
        Map memoizerCache = (Map)fieldOnMemoizer.get(memoizer);
        Object futureAfterFirstComputation = memoizerCache.values().iterator().next();
        this.processor.clear();
        this.processor.compute(this.computableTask.setArg(5), (Object)5);
        Iterator iteratorAfterSecondComputation = memoizerCache.values().iterator();
        Object futureAfterSecondComputation = iteratorAfterSecondComputation.next();
        AdvancedProcessorTestCase.assertFalse((futureAfterFirstComputation == futureAfterSecondComputation ? 1 : 0) != 0);
        fieldOnProcessor.setAccessible(false);
        fieldOnMemoizer.setAccessible(false);
        AdvancedProcessorTestCase.assertEquals((Object)this.processor.compute(this.computableTask.setArg(7), (Object)5), (Object)12);
    }

    public void setUp() {
        this.processor = new AdvancedProcessor();
        this.computableTask = new Task<Integer, Integer>();
    }

    private static interface MutableComputableTask<A, V>
    extends ComputableTask<A, V> {
        public MutableComputableTask<A, V> setArg(A var1);
    }

    static class Task<A, V>
    implements MutableComputableTask<A, V> {
        private A a;

        Task() {
        }

        public V compute(A arg) throws InterruptedException {
            return (V)Integer.valueOf((Integer)this.a + (Integer)arg);
        }

        @Override
        public MutableComputableTask<A, V> setArg(A arg) {
            this.a = arg;
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Task task = (Task)o;
            return !(this.a != null ? !this.a.equals(task.a) : task.a != null);
        }

        public int hashCode() {
            return this.a != null ? this.a.hashCode() : 0;
        }
    }
}

