/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.identitymaps.cacheinvalidation;

import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.identitymaps.cacheinvalidation.CacheExpiryTest;

public class UpdateQueryChangeExpiryTest
extends CacheExpiryTest {
    protected boolean updateChangeFlag = false;
    protected long originalReadTime = 0L;
    protected long secondReadTime = 0L;
    protected Employee employee = null;
    protected boolean initialUpdateFlag;

    public UpdateQueryChangeExpiryTest(boolean updateChangeFlag) {
        this.setDescription("Test Update Queries which will change the Expiry for an object.");
        this.updateChangeFlag = updateChangeFlag;
    }

    @Override
    public void setup() {
        super.setup();
        this.initialUpdateFlag = this.getSession().getDescriptor(Employee.class).getCacheInvalidationPolicy().shouldUpdateReadTimeOnUpdate();
        this.getSession().getDescriptor(Employee.class).getCacheInvalidationPolicy().setShouldUpdateReadTimeOnUpdate(this.updateChangeFlag);
        this.getSession().readAllObjects(Employee.class);
    }

    public void test() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        this.employee = (Employee)uow.readObject(Employee.class);
        this.originalReadTime = ((AbstractSession)this.getSession()).getIdentityMapAccessorInstance().getCacheKeyForObject((Object)this.employee).getReadTime();
        this.employee.setFirstName(this.employee.getFirstName() + "-mutated");
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        uow.commit();
        this.secondReadTime = this.getAbstractSession().getIdentityMapAccessorInstance().getCacheKeyForObject((Object)this.employee).getReadTime();
    }

    public void verify() {
        if (this.updateChangeFlag && this.originalReadTime >= this.secondReadTime) {
            throw new TestErrorException("Unit of Work Update did not update the expiry time when it was supposed to.");
        }
        if (!this.updateChangeFlag && this.originalReadTime != this.secondReadTime) {
            throw new TestErrorException("Unit of Work Update update expiry time when it was not supposed to.");
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.getSession().getDescriptor(Employee.class).getCacheInvalidationPolicy().setShouldUpdateReadTimeOnUpdate(this.initialUpdateFlag);
    }
}

