/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.customsqlstoredprocedures;

import java.util.Vector;
import org.eclipse.persistence.queries.WriteObjectQuery;
import org.eclipse.persistence.sessions.DatabaseRecord;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.SessionEvent;
import org.eclipse.persistence.sessions.SessionEventListener;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.customsqlstoredprocedures.StoredProcedureOutputListener;

public class OutputParameterEventTest
extends TestCase {
    public Vector events;
    public Employee employee;

    public OutputParameterEventTest(Employee emp) {
        this.employee = emp;
        this.events = new Vector();
    }

    public void reset() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        if (this.getAbstractSession().isInTransaction()) {
            this.getAbstractSession().rollbackTransaction();
        }
    }

    public void setup() {
        if (!(this.getSession().getPlatform().isSQLServer() || this.getSession().getPlatform().isSybase() || this.getSession().getPlatform().isSQLAnywhere())) {
            throw new TestWarningException("This test can only be run in SQLServer until EmployeeCustomeSQLSystem is modified");
        }
        this.getAbstractSession().beginTransaction();
        this.events = new Vector();
    }

    public void test() {
        DatabaseSession session = (DatabaseSession)this.getSession();
        session.getEventManager().addListener((SessionEventListener)new StoredProcedureOutputListener(this.events));
        session.writeObject((Object)this.employee);
    }

    public void verify() {
        if (this.events.isEmpty()) {
            throw new TestErrorException("No session events were thrown and some were expected");
        }
        if (((Number)((DatabaseRecord)((SessionEvent)this.events.firstElement()).getResult()).get("EMPLOYEE.VERSION")).intValue() != 952) {
            throw new TestErrorException("Wrong value returned");
        }
        if (((WriteObjectQuery)((SessionEvent)this.events.firstElement()).getQuery()).getObject() == null) {
            throw new TestErrorException("Object not set");
        }
    }
}

