/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.clientserver;

import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.SessionEvent;
import org.eclipse.persistence.sessions.SessionEventAdapter;
import org.eclipse.persistence.sessions.SessionEventListener;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.sessions.server.ClientSession;
import org.eclipse.persistence.sessions.server.Server;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class CommunicationFailureTest
extends AutoVerifyTestCase {
    protected Accessor non_txn_read;
    protected Server serverSession;

    public CommunicationFailureTest() {
        this.setDescription("Tests that TopLink is correctly handling Accessors that experience exceptions.");
    }

    public void setup() {
        DatabaseLogin login = (DatabaseLogin)this.getSession().getLogin().clone();
        this.serverSession = this.getSession().getProject().createServerSession();
        this.serverSession.setSessionLog(this.getSession().getSessionLog());
        this.serverSession.login();
    }

    public void test() {
        UnitOfWork uow = this.serverSession.acquireUnitOfWork();
        QueryExecuteListener listener = new QueryExecuteListener(this);
        this.getSession().getEventManager().addListener((SessionEventListener)listener);
        try {
            uow.readObject(Employee.class);
        }
        catch (Exception ex) {
            throw new TestErrorException("outside of the transaction TopLink failed to retry the read.");
        }
        if (((ClientSession)uow.getParent()).getParent().getReadConnectionPool().getConnectionsAvailable().contains(this.non_txn_read)) {
            throw new TestErrorException("Failed to remove accessor from pool on exception");
        }
    }

    public void verify() {
    }

    public void reset() {
        this.serverSession.logout();
    }

    public class QueryExecuteListener
    extends SessionEventAdapter {
        protected CommunicationFailureTest test;

        public QueryExecuteListener(CommunicationFailureTest test) {
            this.test = test;
        }

        public void preExecuteQuery(SessionEvent event) {
            this.test.non_txn_read = event.getQuery().getAccessor();
            event.getQuery().getAccessor().closeConnection();
        }
    }
}

