/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.fetchgroups;

import java.util.HashMap;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import junit.framework.TestSuite;
import org.eclipse.persistence.config.DescriptorCustomizer;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.indirection.IndirectCollection;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.queries.FetchGroup;
import org.eclipse.persistence.queries.LoadGroup;
import org.eclipse.persistence.testing.models.jpa.advanced.Address;
import org.eclipse.persistence.testing.models.jpa.advanced.Employee;
import org.eclipse.persistence.testing.models.jpa.advanced.PhoneNumber;
import org.eclipse.persistence.testing.tests.jpa.fetchgroups.BaseFetchGroupTests;
import org.junit.Test;

public class NestedDefaultFetchGroupTests
extends BaseFetchGroupTests {
    public NestedDefaultFetchGroupTests() {
    }

    public NestedDefaultFetchGroupTests(String name) {
        super(name);
    }

    public static junit.framework.Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("NestedDefaultFetchGroupTests");
        suite.addTest((junit.framework.Test)new NestedDefaultFetchGroupTests("testSetup"));
        suite.addTest((junit.framework.Test)new NestedDefaultFetchGroupTests("findMinEmployee"));
        suite.addTest((junit.framework.Test)new NestedDefaultFetchGroupTests("findMinEmployeeLoadAddressAndPhoneUsingFetchGroup"));
        if (!NestedDefaultFetchGroupTests.isJPA10()) {
            suite.addTest((junit.framework.Test)new NestedDefaultFetchGroupTests("findMinEmployeeLoadAddress"));
            suite.addTest((junit.framework.Test)new NestedDefaultFetchGroupTests("findMinEmployeeLoadPhones"));
            suite.addTest((junit.framework.Test)new NestedDefaultFetchGroupTests("findMinEmployeeLoadAddressAndPhones"));
            suite.addTest((junit.framework.Test)new NestedDefaultFetchGroupTests("allAddress"));
            suite.addTest((junit.framework.Test)new NestedDefaultFetchGroupTests("allPhone"));
            suite.addTest((junit.framework.Test)new NestedDefaultFetchGroupTests("singleResultMinEmployeeFetchJoinAddress"));
            suite.addTest((junit.framework.Test)new NestedDefaultFetchGroupTests("singleResultMinEmployeeFetchJoinAddressLoad"));
        }
        return suite;
    }

    @Override
    public void setUp() {
        super.setUp();
        try {
            new EmployeeCustomizer().customize(this.employeeDescriptor);
            new BaseFetchGroupTests.PhoneCustomizer().customize(this.phoneDescriptor);
            this.reprepareReadQueries(this.employeeDescriptor);
            this.reprepareReadQueries(this.phoneDescriptor);
        }
        catch (RuntimeException rtEx) {
            throw rtEx;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        this.assertConfig(this.employeeDescriptor, defaultEmployeeFG, 0);
        this.assertConfig(this.phoneDescriptor, defaultPhoneFG, 0);
    }

    @Test
    public void findMinEmployee() {
        this.internalFindMinEmployee(false, false, false);
    }

    @Test
    public void findMinEmployeeLoadAddress() {
        this.internalFindMinEmployee(true, false, true);
    }

    public void findMinEmployeeLoadPhones() {
        this.internalFindMinEmployee(false, true, true);
    }

    public void findMinEmployeeLoadAddressAndPhones() {
        this.internalFindMinEmployee(true, true, true);
    }

    public void findMinEmployeeLoadAddressAndPhoneUsingFetchGroup() {
        this.internalFindMinEmployee(true, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void internalFindMinEmployee(boolean loadAddress, boolean loadPhones, boolean useLoadGroup) {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        int minId = NestedDefaultFetchGroupTests.minEmployeeIdWithAddressAndPhones(em);
        NestedDefaultFetchGroupTests.assertEquals((int)1, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
        boolean load = false;
        boolean originalLoad = false;
        if (!useLoadGroup) {
            NestedDefaultFetchGroupTests.assertTrue((loadAddress == loadPhones ? 1 : 0) != 0);
            load = loadAddress;
            originalLoad = defaultEmployeeFG.shouldLoad();
            if (load != originalLoad) {
                defaultEmployeeFG.setShouldLoad(load);
            }
        }
        try {
            Employee emp;
            if (useLoadGroup) {
                LoadGroup lg = defaultEmployeeFG.toLoadGroup();
                if (!loadAddress) {
                    lg.removeAttribute("address");
                }
                if (!loadPhones) {
                    lg.removeAttribute("phoneNumbers");
                }
                HashMap<String, LoadGroup> hints = new HashMap<String, LoadGroup>(1);
                hints.put("eclipselink.load-group", lg);
                emp = (Employee)em.find(Employee.class, (Object)minId, hints);
            } else {
                emp = (Employee)em.find(Employee.class, (Object)minId);
            }
            NestedDefaultFetchGroupTests.assertNotNull((Object)emp);
            int nExpected = 2;
            if (loadAddress) {
                ++nExpected;
            }
            if (loadPhones) {
                ++nExpected;
            }
            NestedDefaultFetchGroupTests.assertEquals((int)nExpected, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            boolean addressInstantiated = ((ValueHolderInterface)((ForeignReferenceMapping)this.employeeDescriptor.getMappingForAttributeName("address")).getAttributeValueFromObject((Object)emp)).isInstantiated();
            NestedDefaultFetchGroupTests.assertTrue((loadAddress == addressInstantiated ? 1 : 0) != 0);
            boolean phonesInstantiated = ((IndirectCollection)((ForeignReferenceMapping)this.employeeDescriptor.getMappingForAttributeName("phoneNumbers")).getAttributeValueFromObject((Object)emp)).isInstantiated();
            NestedDefaultFetchGroupTests.assertTrue((loadPhones == phonesInstantiated ? 1 : 0) != 0);
            emp.getAddress();
            emp.getPhoneNumbers().size();
            NestedDefaultFetchGroupTests.assertEquals((int)4, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            this.assertFetched((Object)emp, defaultEmployeeFG);
            this.assertFetchedAttribute(emp, "address");
            this.assertFetchedAttribute(emp, "phoneNumbers");
            FetchGroup fgAddress = defaultEmployeeFG.getGroup("address");
            this.assertFetched((Object)emp.getAddress(), fgAddress);
            FetchGroup fgPhones = defaultEmployeeFG.getGroup("phoneNumbers");
            for (PhoneNumber phone : emp.getPhoneNumbers()) {
                this.assertFetched((Object)phone, fgPhones);
            }
        }
        finally {
            if (!useLoadGroup && load != originalLoad) {
                defaultEmployeeFG.setShouldLoad(originalLoad);
            }
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    @Test
    public void allAddress() {
        EntityManager em = this.createEntityManager();
        List allAddresses = em.createQuery("SELECT a FROM Address a", Address.class).getResultList();
        for (Address address : allAddresses) {
            this.assertNoFetchGroup(address);
        }
    }

    @Test
    public void allPhone() {
        EntityManager em = this.createEntityManager();
        List allPhones = em.createQuery("SELECT p FROM PhoneNumber p", PhoneNumber.class).getResultList();
        for (PhoneNumber phone : allPhones) {
            this.assertFetched((Object)phone, defaultPhoneFG);
        }
    }

    @Test
    public void singleResultMinEmployeeFetchJoinAddress() {
        this.internalSingleResultMinEmployeeFetchJoinAddress(false);
    }

    public void singleResultMinEmployeeFetchJoinAddressLoad() {
        this.internalSingleResultMinEmployeeFetchJoinAddress(true);
    }

    void internalSingleResultMinEmployeeFetchJoinAddress(boolean shouldLoad) {
        EntityManager em = this.createEntityManager();
        TypedQuery query = em.createQuery("SELECT e FROM Employee e JOIN FETCH e.address WHERE e.id IN (SELECT MIN(p.id) FROM PhoneNumber p)", Employee.class);
        if (shouldLoad) {
            query.setHint("eclipselink.load-group.attribute", (Object)"phoneNumbers");
        }
        Employee emp = (Employee)query.getSingleResult();
        NestedDefaultFetchGroupTests.assertNotNull((Object)emp);
        int nExpected = 1;
        if (shouldLoad) {
            ++nExpected;
        }
        NestedDefaultFetchGroupTests.assertEquals((int)nExpected, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
    }

    public static class EmployeeCustomizer
    implements DescriptorCustomizer {
        public void customize(ClassDescriptor descriptor) throws Exception {
            BaseFetchGroupTests.defaultEmployeeFG = new FetchGroup("Employee.default");
            BaseFetchGroupTests.defaultEmployeeFG.addAttribute("firstName");
            BaseFetchGroupTests.defaultEmployeeFG.addAttribute("lastName");
            BaseFetchGroupTests.defaultEmployeeFG.addAttribute("address.country");
            BaseFetchGroupTests.defaultEmployeeFG.addAttribute("phoneNumbers.areaCode");
            descriptor.getFetchGroupManager().setDefaultFetchGroup(BaseFetchGroupTests.defaultEmployeeFG);
        }
    }
}

