/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.identitymaps;

import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class TriggerValueHoldersSelfReferencingOneToOneTest
extends TestCase {
    protected UnitOfWork uow = null;

    public void setup() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        this.uow = this.getSession().acquireUnitOfWork();
        ExpressionBuilder emp = new ExpressionBuilder();
        Expression queryExp = emp.get("firstName").equal((Object)"Charles").and(emp.get("lastName").equal((Object)"Chanley"));
        this.uow.readObject(Employee.class, queryExp);
        emp = new ExpressionBuilder();
        queryExp = emp.get("firstName").equal((Object)"Marcus").and(emp.get("lastName").equal((Object)"Saunders"));
        this.uow.readObject(Employee.class, queryExp);
    }

    public void reset() {
        this.uow.release();
        this.uow = null;
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public void test() {
        ExpressionBuilder emp = new ExpressionBuilder();
        Expression queryExp = emp.get("manager").get("firstName").equal((Object)"Bob");
        ReadObjectQuery query = new ReadObjectQuery(Employee.class, queryExp);
        query.conformResultsInUnitOfWork();
        query.getInMemoryQueryIndirectionPolicy().triggerIndirection();
        Employee bob = (Employee)this.uow.executeQuery((DatabaseQuery)query);
        TriggerValueHoldersSelfReferencingOneToOneTest.assertNotNull((Object)bob);
        TriggerValueHoldersSelfReferencingOneToOneTest.assertEquals((String)"Bob", (String)bob.getManager().getFirstName());
        emp = new ExpressionBuilder();
        queryExp = emp.get("manager").get("firstName").equal((Object)"John");
        query = new ReadObjectQuery(Employee.class, queryExp);
        query.conformResultsInUnitOfWork();
        query.getInMemoryQueryIndirectionPolicy().triggerIndirection();
        Employee john = (Employee)this.uow.executeQuery((DatabaseQuery)query);
        TriggerValueHoldersSelfReferencingOneToOneTest.assertNotNull((Object)john);
        TriggerValueHoldersSelfReferencingOneToOneTest.assertEquals((String)"John", (String)john.getManager().getFirstName());
    }
}

