/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.directmap;

import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.directmap.DirectMapMappings;

public class DirectMapMappingsSerializedConverterTestCase
extends AutoVerifyTestCase {
    public DirectMapMappingsSerializedConverterTestCase() {
        this.setDescription("Ensure SerializedObjectConverter works with DirectMapMapping.");
    }

    public void setup() {
        this.beginTransaction();
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
    }

    public void test() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        DirectMapMappings m1 = new DirectMapMappings();
        m1.blobDirectMap.put(new Integer(1), new Integer(1));
        m1.blobDirectMap.put(new Integer(2), new Integer(2));
        DirectMapMappings maps1 = (DirectMapMappings)uow.registerObject((Object)m1);
        uow.commit();
    }

    public void verify() {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        DirectMapMappings maps = (DirectMapMappings)uow.readObject(DirectMapMappings.class);
        if (!maps.blobDirectMap.get(new Integer(1)).equals(new Integer(1))) {
            throw new TestErrorException("The cloned direct map does not maintain the proper type when used with a SerializedObjectConverter.");
        }
    }

    public void reset() {
        this.rollbackTransaction();
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
    }
}

