/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.validation;

import java.util.Vector;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.domain.EmployeePopulator;
import org.eclipse.persistence.testing.models.employee.domain.PhoneNumber;
import org.eclipse.persistence.testing.tests.validation.ExceptionTest;

public class QueryParameterForOneToOneValidationTest
extends ExceptionTest {
    protected boolean shouldConform;

    public QueryParameterForOneToOneValidationTest(boolean shouldConform) {
        this.shouldConform = shouldConform;
        this.setName(this.getName() + " - conforming: " + shouldConform);
        this.setDescription("Test that an exception is thrown for 1:1 when using a simple parameter instead of a complex object");
    }

    public void setup() {
        this.expectedException = QueryException.incorrectClassForObjectComparison(null, null, null);
    }

    public void test() {
        Employee empExample = (Employee)new EmployeePopulator().basicEmployeeExample10();
        ExpressionBuilder testBuilder = new ExpressionBuilder();
        Expression testExpression = testBuilder.get("firstName").equal((Object)empExample.getFirstName());
        testExpression = testExpression.and(testBuilder.get("lastName").equal((Object)empExample.getLastName()));
        Employee testEmp = (Employee)this.getSession().readObject(Employee.class, testExpression);
        if (testEmp == null) {
            throw new TestErrorException("Employee example was not retrieved from DB (null): " + empExample);
        }
        int id = testEmp.getId().intValue();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        ReadAllQuery query = new ReadAllQuery(PhoneNumber.class);
        ExpressionBuilder builder = query.getExpressionBuilder();
        Expression expression = builder.get("owner").equal(builder.getParameter("the_parameter"));
        query.setSelectionCriteria(expression);
        query.addArgument("the_parameter", Integer.class);
        try {
            Vector<Integer> params = new Vector<Integer>();
            params.add(new Integer(id));
            if (this.shouldConform) {
                query.setCacheUsage(4);
                this.getSession().readAllObjects(PhoneNumber.class);
                this.getSession().readAllObjects(Employee.class);
            }
            this.getSession().executeQuery((DatabaseQuery)query, params);
        }
        catch (EclipseLinkException te) {
            this.caughtException = te;
        }
        catch (Exception e) {
            throw new TestException("Caught exception " + e.toString() + "running test " + this.getName());
        }
    }
}

