/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.unitofwork;

import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.sessions.remote.RemoteSession;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.models.employee.domain.Address;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.domain.EmployeePopulator;

public class ConcurrentNewObjectTest
extends AutoVerifyTestCase {
    public void setup() {
        if (this.getSession() instanceof RemoteSession) {
            throw new TestWarningException("Test not supported in remote, it uses internal jta callbacks.");
        }
        this.getAbstractSession().beginTransaction();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    protected void test() {
        UnitOfWorkImpl unitOfWork1 = (UnitOfWorkImpl)this.getSession().acquireUnitOfWork();
        Address address = new EmployeePopulator().addressExample1();
        Employee originalClone = (Employee)unitOfWork1.readObject(Employee.class);
        originalClone.setAddress(address);
        unitOfWork1.issueSQLbeforeCompletion();
        unitOfWork1.setPendingMerge();
        address = (Address)this.getSession().readObject((Object)address);
        try {
            unitOfWork1.mergeClonesAfterCompletion();
        }
        catch (Exception exception) {
            throw new TestErrorException("New Object was read into Cache before Merged by creator, creator threw error");
        }
    }

    public void reset() {
        this.getAbstractSession().commitTransaction();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }
}

