/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.interfaces;

import java.util.ArrayList;
import junit.framework.Test;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.testing.framework.DeleteObjectTest;
import org.eclipse.persistence.testing.framework.InsertObjectTest;
import org.eclipse.persistence.testing.framework.ReadAllTest;
import org.eclipse.persistence.testing.framework.ReadObjectTest;
import org.eclipse.persistence.testing.framework.TestModel;
import org.eclipse.persistence.testing.framework.TestSuite;
import org.eclipse.persistence.testing.framework.UnitOfWorkBasicUpdateObjectTest;
import org.eclipse.persistence.testing.framework.WriteObjectTest;
import org.eclipse.persistence.testing.models.interfaces.Actor;
import org.eclipse.persistence.testing.models.interfaces.Company;
import org.eclipse.persistence.testing.models.interfaces.Contact;
import org.eclipse.persistence.testing.models.interfaces.ContactHolder;
import org.eclipse.persistence.testing.models.interfaces.CourseDeveloper;
import org.eclipse.persistence.testing.models.interfaces.Documentary;
import org.eclipse.persistence.testing.models.interfaces.Email;
import org.eclipse.persistence.testing.models.interfaces.Employee;
import org.eclipse.persistence.testing.models.interfaces.Film;
import org.eclipse.persistence.testing.models.interfaces.InterfaceWithoutTablesSystem;
import org.eclipse.persistence.testing.models.interfaces.Job;
import org.eclipse.persistence.testing.models.interfaces.ManagerialJob;
import org.eclipse.persistence.testing.models.interfaces.PersonnelManager;
import org.eclipse.persistence.testing.models.interfaces.Phone;
import org.eclipse.persistence.testing.models.interfaces.ProductDeveloper;
import org.eclipse.persistence.testing.models.interfaces.ProductManager;
import org.eclipse.persistence.testing.models.interfaces.Receptionist;
import org.eclipse.persistence.testing.models.interfaces.Secretary;
import org.eclipse.persistence.testing.models.interfaces.Unionized;
import org.eclipse.persistence.testing.models.interfaces.VIP;
import org.eclipse.persistence.testing.tests.interfaces.DescriptorInitTest;
import org.eclipse.persistence.testing.tests.interfaces.OneToManyVariableBackBatchReadingTest;
import org.eclipse.persistence.testing.tests.interfaces.PostCommitEventPrimaryKeyTest;
import org.eclipse.persistence.testing.tests.interfaces.QueryAccrossV11ProxyIndirectionTest;
import org.eclipse.persistence.testing.tests.interfaces.QueryAcrossV11Test;
import org.eclipse.persistence.testing.tests.interfaces.ReadAllBatchTest;
import org.eclipse.persistence.testing.tests.interfaces.ReadAllConformInUowTest;
import org.eclipse.persistence.testing.tests.interfaces.UpdateObjectTest;
import org.eclipse.persistence.testing.tests.interfaces.VariableOneToOneCodeCoverageTest;
import org.eclipse.persistence.testing.tests.interfaces.VariableOneToOneDeepMergeCloneTest;
import org.eclipse.persistence.testing.tests.interfaces.VariableOneToOneDeleteTest;
import org.eclipse.persistence.testing.tests.interfaces.VariableOneToOneGetTypeFieldTest;
import org.eclipse.persistence.testing.tests.interfaces.VariableOneToOneInsertTest;
import org.eclipse.persistence.testing.tests.interfaces.VariableOneToOneNonPrivatelyOwnedTest;
import org.eclipse.persistence.testing.tests.interfaces.VariableOneToOneShallowWriteTest;
import org.eclipse.persistence.testing.tests.interfaces.VariableOneToOneUpdateTest;
import org.eclipse.persistence.tools.schemaframework.PopulationManager;

public class InterfaceWithoutTablesTestModel
extends TestModel {
    public InterfaceWithoutTablesTestModel() {
        this.setDescription("This model tests interface support, where the interfaces have tables in the database");
    }

    public void addRequiredSystems() {
        this.addRequiredSystem(new InterfaceWithoutTablesSystem());
    }

    public void addTests() {
        this.addTest((Test)InterfaceWithoutTablesTestModel.getReadObjectTestSuite());
        this.addTest((Test)InterfaceWithoutTablesTestModel.getReadAllTestSuite());
        this.addTest((Test)InterfaceWithoutTablesTestModel.getDeleteObjectTestSuite());
        this.addTest((Test)InterfaceWithoutTablesTestModel.getInsertObjectTestSuite());
        this.addTest((Test)InterfaceWithoutTablesTestModel.getUpdateObjectTestSuite());
        this.addTest((Test)InterfaceWithoutTablesTestModel.getVariable1To1TestSuite());
        this.addTest((Test)InterfaceWithoutTablesTestModel.getManyDescriptorTestSuite());
    }

    public static TestSuite getDeleteObjectTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("InterfaceWithoutTablesDeleteObjectTestSuite");
        suite.setDescription("This suite tests the deletion of each object in the interface model (without tables).");
        PopulationManager manager = PopulationManager.getDefaultManager();
        suite.addTest((Test)new DeleteObjectTest(manager.getObject(Film.class, "example1")));
        suite.addTest((Test)new DeleteObjectTest(manager.getObject(Documentary.class, "example1")));
        suite.addTest((Test)new DeleteObjectTest(manager.getObject(Secretary.class, "example1")));
        suite.addTest((Test)new DeleteObjectTest(manager.getObject(Receptionist.class, "example1")));
        suite.addTest((Test)new DeleteObjectTest(manager.getObject(ProductDeveloper.class, "example1")));
        suite.addTest((Test)new DeleteObjectTest(manager.getObject(CourseDeveloper.class, "example1")));
        suite.addTest((Test)new DeleteObjectTest(manager.getObject(ProductManager.class, "example1")));
        suite.addTest((Test)new DeleteObjectTest(manager.getObject(PersonnelManager.class, "example1")));
        suite.addTest((Test)new DeleteObjectTest(manager.getObject(Employee.class, "example1")));
        suite.addTest((Test)new DeleteObjectTest(manager.getObject(Phone.class, "example1")));
        suite.addTest((Test)new DeleteObjectTest(manager.getObject(Email.class, "example1")));
        suite.addTest((Test)new DeleteObjectTest(manager.getObject(Company.class, "example1")));
        return suite;
    }

    public static TestSuite getInsertObjectTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("InserfaceWithoutTablesInsertObjectTestSuite");
        suite.setDescription("This suite tests the insertion of each object in the interface model (without tables).");
        suite.addTest((Test)new InsertObjectTest((Object)Film.example2()));
        suite.addTest((Test)new InsertObjectTest((Object)Secretary.example2()));
        suite.addTest((Test)new InsertObjectTest((Object)Company.example3()));
        suite.addTest((Test)new InsertObjectTest((Object)CourseDeveloper.example1()));
        suite.addTest((Test)new InsertObjectTest((Object)Email.example2()));
        suite.addTest((Test)new InsertObjectTest((Object)PersonnelManager.example1()));
        suite.addTest((Test)new InsertObjectTest((Object)Phone.example1()));
        suite.addTest((Test)new InsertObjectTest((Object)ProductDeveloper.example3()));
        suite.addTest((Test)new InsertObjectTest((Object)ProductManager.example1()));
        suite.addTest((Test)new InsertObjectTest((Object)Receptionist.example1()));
        return suite;
    }

    public static TestSuite getManyDescriptorTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("InterfaceWithoutTablesManyDescriptorTestSuite");
        suite.setDescription("This suite tests the support of many descriptors. (without tables).");
        suite.addTest((Test)new DescriptorInitTest());
        return suite;
    }

    public static TestSuite getReadAllTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("InterfaceWithoutTablesReadAllTestSuite");
        suite.setDescription("This suite tests the reading of all the objects of each class in the interface model (without tables).");
        ReadAllQuery query = new ReadAllQuery();
        query.setReferenceClass(Unionized.class);
        query.useCollectionClass(ArrayList.class);
        ReadAllTest aTest = new ReadAllTest(Unionized.class, 6);
        aTest.setQuery(query);
        suite.addTest((Test)aTest);
        suite.addTest((Test)new ReadAllTest(Actor.class, 4));
        suite.addTest((Test)new ReadAllTest(Documentary.class, 1));
        suite.addTest((Test)new ReadAllTest(Film.class, 3));
        suite.addTest((Test)new ReadAllTest(Job.class, 18));
        suite.addTest((Test)new ReadAllTest(ManagerialJob.class, 6));
        suite.addTest((Test)new ReadAllTest(VIP.class, 3));
        ReadAllTest test = new ReadAllTest(VIP.class, 3);
        test.setQuery(new ReadAllQuery());
        test.getQuery().setReferenceClass(VIP.class);
        test.getQuery().useCursoredStream();
        suite.addTest((Test)test);
        test = new ReadAllBatchTest(Employee.class, 3);
        test.setName("Batch Read Test");
        test.setQuery(new ReadAllQuery());
        test.getQuery().setReferenceClass(Employee.class);
        test.getQuery().addBatchReadAttribute("contact");
        suite.addTest((Test)test);
        suite.addTest((Test)new OneToManyVariableBackBatchReadingTest());
        test = new ReadAllTest(Employee.class, 4);
        test.setQuery(new ReadAllQuery());
        test.getQuery().setReferenceClass(Employee.class);
        test.getQuery().cascadeAllParts();
        suite.addTest((Test)test);
        suite.addTest((Test)new ReadAllTest(Employee.class, 4));
        suite.addTest((Test)new ReadAllConformInUowTest());
        return suite;
    }

    public static ReadObjectTest getReadInterfaceObjectTest() {
        TestSuite suite = new TestSuite();
        PopulationManager manager = PopulationManager.getDefaultManager();
        Contact contact = ((Employee)manager.getObject(Employee.class, "example1")).getContact();
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = builder.get("id").equal((Object)contact.getEmp().getId());
        ReadObjectQuery query = new ReadObjectQuery();
        query.setReferenceClass(ContactHolder.class);
        query.setSelectionCriteria(expression);
        ReadObjectTest test = new ReadObjectTest((Object)contact.getEmp());
        test.setQuery(query);
        return test;
    }

    public static TestSuite getReadObjectTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("InterfaceWithoutTablesReadObjectTestSuite");
        suite.setDescription("This suite test the reading of each object in the interface model (without tables).");
        PopulationManager manager = PopulationManager.getDefaultManager();
        suite.addTest((Test)new ReadObjectTest(manager.getObject(Actor.class, "example4")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(Documentary.class, "example1")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(Film.class, "example1")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(Employee.class, "example2")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(CourseDeveloper.class, "example1")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(Email.class, "example1")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(PersonnelManager.class, "example1")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(Phone.class, "example1")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(ProductDeveloper.class, "example1")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(ProductManager.class, "example1")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(Receptionist.class, "example1")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(Secretary.class, "example1")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(Employee.class, "example4")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(Employee.class, "example1")));
        suite.addTest((Test)InterfaceWithoutTablesTestModel.getReadInterfaceObjectTest());
        return suite;
    }

    public static TestSuite getUpdateObjectTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("InterfaceWithoutTablesUpdateObjectTestSuite");
        suite.setDescription("This suite tests the updating of each object in the interface model (without tables).");
        PopulationManager manager = PopulationManager.getDefaultManager();
        suite.addTest((Test)new WriteObjectTest(manager.getObject(Employee.class, "example1")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(Employee.class, "example1")));
        suite.addTest((Test)new WriteObjectTest(manager.getObject(CourseDeveloper.class, "example1")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(CourseDeveloper.class, "example1")));
        suite.addTest((Test)new WriteObjectTest(manager.getObject(Email.class, "example1")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(Email.class, "example1")));
        suite.addTest((Test)new WriteObjectTest(manager.getObject(PersonnelManager.class, "example1")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(PersonnelManager.class, "example1")));
        suite.addTest((Test)new WriteObjectTest(manager.getObject(Phone.class, "example1")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(Phone.class, "example1")));
        suite.addTest((Test)new WriteObjectTest(manager.getObject(ProductDeveloper.class, "example1")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(ProductDeveloper.class, "example1")));
        suite.addTest((Test)new WriteObjectTest(manager.getObject(ProductManager.class, "example1")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(ProductManager.class, "example1")));
        suite.addTest((Test)new WriteObjectTest(manager.getObject(Receptionist.class, "example1")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(Receptionist.class, "example1")));
        suite.addTest((Test)new WriteObjectTest(manager.getObject(Secretary.class, "example1")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(Secretary.class, "example1")));
        suite.addTest((Test)new UpdateObjectTest());
        suite.addTest((Test)new VariableOneToOneNonPrivatelyOwnedTest());
        return suite;
    }

    public static QueryAcrossV11Test getV11QueryTest() {
        return new QueryAcrossV11Test();
    }

    public static TestSuite getVariable1To1TestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("InterfaceWithoutTablesVariable1To1TestSuite");
        suite.setDescription("This suite tests certain aspects of the Variable 1 to 1 implementation using the interface model (without tables).");
        suite.addTest((Test)new VariableOneToOneDeepMergeCloneTest());
        suite.addTest((Test)new VariableOneToOneShallowWriteTest());
        suite.addTest((Test)InterfaceWithoutTablesTestModel.getV11QueryTest());
        suite.addTest((Test)new QueryAccrossV11ProxyIndirectionTest());
        suite.addTest((Test)new PostCommitEventPrimaryKeyTest());
        suite.addTest((Test)new VariableOneToOneUpdateTest());
        suite.addTest((Test)new VariableOneToOneDeleteTest());
        suite.addTest((Test)new VariableOneToOneCodeCoverageTest());
        suite.addTest((Test)new VariableOneToOneInsertTest());
        suite.addTest((Test)new VariableOneToOneGetTypeFieldTest());
        return suite;
    }
}

