/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.identitymaps.cacheinvalidation;

import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.identitymaps.cacheinvalidation.CacheExpiryTest;

public class CacheExpiryUnitOfWorkReadTest
extends CacheExpiryTest {
    protected Employee sessionEmployee = null;
    protected UnitOfWork uow = null;

    public CacheExpiryUnitOfWorkReadTest() {
        this.setDescription("Test to ensure read time is correct in the UnitOfWork cache.");
    }

    @Override
    public void setup() {
        super.setup();
        this.uow = this.getSession().acquireUnitOfWork();
    }

    public void test() {
        this.sessionEmployee = (Employee)this.getSession().readObject(Employee.class);
        Employee uowEmployee = (Employee)this.uow.readObject((Object)this.sessionEmployee);
        this.uow.release();
    }

    public void verify() {
        if (((UnitOfWorkImpl)this.uow).getIdentityMapAccessorInstance().getCacheKeyForObject((Object)this.sessionEmployee).getReadTime() != ((AbstractSession)this.getSession()).getIdentityMapAccessorInstance().getCacheKeyForObject((Object)this.sessionEmployee).getReadTime()) {
            throw new TestErrorException("The read time in the UnitOfWork cache is different from the read time in the session cache.");
        }
    }

    @Override
    public void reset() {
        this.uow.release();
        super.reset();
    }
}

