/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.identitymaps;

import java.util.ConcurrentModificationException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class TriggerValueHoldersSelfReferencingOneToOneTest
extends AutoVerifyTestCase {
    protected UnitOfWork uow = null;
    protected ConcurrentModificationException exception = null;

    public void setup() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        this.uow = this.getSession().acquireUnitOfWork();
        ExpressionBuilder emp = new ExpressionBuilder();
        Expression queryExp = emp.get("firstName").equal((Object)"Charles").and(emp.get("lastName").equal((Object)"Chanley"));
        this.uow.readObject(Employee.class, queryExp);
        emp = new ExpressionBuilder();
        queryExp = emp.get("firstName").equal((Object)"Marcus").and(emp.get("lastName").equal((Object)"Saunders"));
        this.uow.readObject(Employee.class, queryExp);
    }

    public void test() {
        ExpressionBuilder emp = new ExpressionBuilder();
        Expression queryExp = emp.get("manager").get("firstName").equal((Object)"Bob");
        ReadObjectQuery query = new ReadObjectQuery(Employee.class, queryExp);
        query.conformResultsInUnitOfWork();
        query.getInMemoryQueryIndirectionPolicy().triggerIndirection();
        this.uow.executeQuery((DatabaseQuery)query);
        emp = new ExpressionBuilder();
        queryExp = emp.get("manager").get("firstName").equal((Object)"John");
        query = new ReadObjectQuery(Employee.class, queryExp);
        query.conformResultsInUnitOfWork();
        query.getInMemoryQueryIndirectionPolicy().triggerIndirection();
        this.uow.executeQuery((DatabaseQuery)query);
    }

    public void verify() {
        if (this.exception != null) {
            throw new TestErrorException("A ConcurrentModificationException was thrown when using a Self Referencing Relationship and a TriggerIndirection query policy.");
        }
    }

    public void reset() {
        this.uow = null;
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }
}

