/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.models.events;

import java.util.Vector;
import org.eclipse.persistence.descriptors.DescriptorEvent;
import org.eclipse.persistence.descriptors.DescriptorEventListener;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.events.Address;

public class AddressDescriptorEventListener
implements DescriptorEventListener {
    public boolean preInsertExecuted;
    public boolean postInsertExecuted;
    public boolean preUpdateExecuted;
    public boolean postUpdateExecuted;
    public boolean preDeleteExecuted;
    public boolean postDeleteExecuted;
    public boolean preWriteExecuted;
    public boolean postWriteExecuted;
    public boolean postBuildExecuted;
    public boolean postRefreshExecuted;
    public boolean postMergeExecuted;
    public boolean postCloneExecuted;
    public boolean aboutToInsertExecuted;
    public boolean aboutToUpdateExecuted;
    public boolean aboutToDeleteExecuted;

    public AddressDescriptorEventListener() {
        this.resetFlags();
    }

    public void checkEvent(DescriptorEvent event) {
        if (event.getSession() == null) {
            throw new TestErrorException("Session not set.");
        }
        if (event.getDescriptor() == null) {
            throw new TestErrorException("Descriptor not set on event.");
        }
    }

    public void checkQueryEvent(DescriptorEvent event) {
        this.checkEvent(event);
        if (event.getQuery() == null) {
            throw new TestErrorException("Query not set.");
        }
    }

    public void checkRowEvent(DescriptorEvent event) {
        this.checkQueryEvent(event);
        if (event.getRecord() == null) {
            throw new TestErrorException("Row not set.");
        }
    }

    public boolean isOverriddenEvent(DescriptorEvent event, Vector eventManagers) {
        return false;
    }

    public void aboutToInsert(DescriptorEvent event) {
        this.checkRowEvent(event);
        this.aboutToInsertExecuted = true;
    }

    public void aboutToUpdate(DescriptorEvent event) {
        this.checkRowEvent(event);
        this.aboutToUpdateExecuted = true;
    }

    public void aboutToDelete(DescriptorEvent event) {
        this.checkRowEvent(event);
        this.aboutToDeleteExecuted = true;
    }

    public void postBuild(DescriptorEvent event) {
        this.checkRowEvent(event);
        this.postBuildExecuted = true;
    }

    public void postClone(DescriptorEvent event) {
        this.checkEvent(event);
        if (event.getOriginalObject() == null) {
            throw new TestErrorException("Original not set.");
        }
        this.postCloneExecuted = true;
    }

    public void postDelete(DescriptorEvent event) {
        this.checkQueryEvent(event);
        this.postDeleteExecuted = true;
    }

    public void postInsert(DescriptorEvent event) {
        this.checkQueryEvent(event);
        this.postInsertExecuted = true;
    }

    public void postMerge(DescriptorEvent event) {
        this.checkEvent(event);
        if (event.getOriginalObject() == null) {
            throw new TestErrorException("Original not set.");
        }
        this.postMergeExecuted = true;
    }

    public void postRefresh(DescriptorEvent event) {
        this.checkRowEvent(event);
        this.postRefreshExecuted = true;
    }

    public void postUpdate(DescriptorEvent event) {
        this.checkQueryEvent(event);
        this.postUpdateExecuted = true;
    }

    public void postWrite(DescriptorEvent event) {
        this.checkQueryEvent(event);
        this.postWriteExecuted = true;
    }

    public void preCreate(DescriptorEvent event) {
    }

    public void preDelete(DescriptorEvent event) {
        this.checkQueryEvent(event);
        this.preDeleteExecuted = true;
    }

    public void preInsert(DescriptorEvent event) {
        this.checkQueryEvent(event);
        this.preInsertExecuted = true;
    }

    public void preRemove(DescriptorEvent event) {
    }

    public void preUpdate(DescriptorEvent event) {
        this.checkQueryEvent(event);
        ++Address.preUpdateCount;
        this.preUpdateExecuted = true;
    }

    public void preWrite(DescriptorEvent event) {
        this.checkQueryEvent(event);
        this.preWriteExecuted = true;
    }

    public void prePersist(DescriptorEvent event) {
    }

    public void preUpdateWithChanges(DescriptorEvent event) {
    }

    public void resetFlags() {
        this.preInsertExecuted = false;
        this.postInsertExecuted = false;
        this.preUpdateExecuted = false;
        this.postUpdateExecuted = false;
        this.preDeleteExecuted = false;
        this.postDeleteExecuted = false;
        this.preWriteExecuted = false;
        this.postWriteExecuted = false;
        this.postBuildExecuted = false;
        this.aboutToInsertExecuted = false;
        this.aboutToUpdateExecuted = false;
        this.aboutToDeleteExecuted = false;
        this.postCloneExecuted = false;
        this.postMergeExecuted = false;
        this.postRefreshExecuted = false;
    }
}

