/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.parser;

import java.util.Collection;
import java.util.List;
import org.eclipse.persistence.jpa.jpql.WordParser;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.JPQLQueryBNF;

public final class RegexpExpression
extends AbstractExpression {
    private boolean hasSpaceAfterIdentifier;
    private AbstractExpression patternValue;
    private String regexpIdentifier;
    private AbstractExpression stringExpression;

    public RegexpExpression(AbstractExpression parent, AbstractExpression stringExpression) {
        super(parent, "REGEXP");
        if (stringExpression != null) {
            this.stringExpression = stringExpression;
            this.stringExpression.setParent(this);
        }
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        this.acceptUnknownVisitor(visitor);
    }

    @Override
    public void acceptChildren(ExpressionVisitor visitor) {
        this.getStringExpression().accept(visitor);
        this.getPatternValue().accept(visitor);
    }

    @Override
    protected void addChildrenTo(Collection<Expression> children) {
        children.add(this.getStringExpression());
        children.add(this.getPatternValue());
    }

    @Override
    protected void addOrderedChildrenTo(List<Expression> children) {
        if (this.stringExpression != null) {
            children.add(this.stringExpression);
            children.add(this.buildStringExpression(' '));
        }
        children.add(this.buildStringExpression("REGEXP"));
        if (this.hasSpaceAfterIdentifier) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.patternValue != null) {
            children.add(this.patternValue);
        }
    }

    @Override
    public JPQLQueryBNF findQueryBNF(Expression expression) {
        if (this.stringExpression != null && this.stringExpression.isAncestor(expression)) {
            return this.getQueryBNF("string_expression");
        }
        if (this.patternValue != null && this.patternValue.isAncestor(expression)) {
            return this.getQueryBNF("pattern_value");
        }
        return super.findQueryBNF(expression);
    }

    public String getActualRegexpIdentifier() {
        return this.regexpIdentifier;
    }

    public Expression getPatternValue() {
        if (this.patternValue == null) {
            this.patternValue = this.buildNullExpression();
        }
        return this.patternValue;
    }

    @Override
    public JPQLQueryBNF getQueryBNF() {
        return this.getQueryBNF("regexp_expression");
    }

    public Expression getStringExpression() {
        if (this.stringExpression == null) {
            this.stringExpression = this.buildNullExpression();
        }
        return this.stringExpression;
    }

    public boolean hasPatternValue() {
        return this.patternValue != null && !this.patternValue.isNull();
    }

    public boolean hasSpaceAfterIdentifier() {
        return this.hasSpaceAfterIdentifier;
    }

    public boolean hasSpaceAfterStringExpression() {
        return this.hasStringExpression();
    }

    public boolean hasStringExpression() {
        return this.stringExpression != null && !this.stringExpression.isNull();
    }

    @Override
    protected boolean isParsingComplete(WordParser wordParser, String word, Expression expression) {
        char character = word.charAt(0);
        if (this.getQueryBNF("pattern_value").handleAggregate() && (character == '+' || character == '-' || character == '*' || character == '/')) {
            return false;
        }
        return super.isParsingComplete(wordParser, word, expression) || word.equalsIgnoreCase("AND") || word.equalsIgnoreCase("OR") || expression != null;
    }

    @Override
    protected void parse(WordParser wordParser, boolean tolerant) {
        this.regexpIdentifier = wordParser.moveForward("REGEXP");
        this.hasSpaceAfterIdentifier = wordParser.skipLeadingWhitespace() > 0;
        this.patternValue = this.parse(wordParser, "pattern_value", tolerant);
    }

    @Override
    protected void toParsedText(StringBuilder writer, boolean actual) {
        if (this.stringExpression != null) {
            this.stringExpression.toParsedText(writer, actual);
            writer.append(' ');
        }
        writer.append(actual ? this.regexpIdentifier : "REGEXP");
        if (this.hasSpaceAfterIdentifier) {
            writer.append(' ');
        }
        if (this.patternValue != null) {
            this.patternValue.toParsedText(writer, actual);
        }
    }
}

