/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.rs.resources.common;

import java.util.List;
import java.util.Map;
import javax.persistence.Query;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.eclipse.persistence.internal.jpa.EJBQueryImpl;
import org.eclipse.persistence.jpa.rs.PersistenceContext;
import org.eclipse.persistence.jpa.rs.exceptions.JPARSException;
import org.eclipse.persistence.jpa.rs.features.FeatureResponseBuilder;
import org.eclipse.persistence.jpa.rs.features.FeatureSet;
import org.eclipse.persistence.jpa.rs.features.core.selflinks.SelfLinksResponseBuilder;
import org.eclipse.persistence.jpa.rs.features.fieldsfiltering.FieldsFilter;
import org.eclipse.persistence.jpa.rs.features.fieldsfiltering.FieldsFilteringValidator;
import org.eclipse.persistence.jpa.rs.features.paging.PageableQueryValidator;
import org.eclipse.persistence.jpa.rs.features.paging.PagingResponseBuilder;
import org.eclipse.persistence.jpa.rs.resources.common.AbstractResource;
import org.eclipse.persistence.jpa.rs.util.HrefHelper;
import org.eclipse.persistence.jpa.rs.util.JPARSLogger;
import org.eclipse.persistence.jpa.rs.util.StreamingOutputMarshaller;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReportQuery;

public abstract class AbstractQueryResource
extends AbstractResource {
    private static final String CLASS_NAME = AbstractQueryResource.class.getName();

    protected Response namedQueryUpdateInternal(String version, String persistenceUnit, String queryName, HttpHeaders headers, UriInfo uriInfo) {
        JPARSLogger.entering(CLASS_NAME, "namedQueryUpdateInternal", new Object[]{"POST", version, persistenceUnit, queryName, uriInfo.getRequestUri().toASCIIString()});
        try {
            PersistenceContext context = this.getPersistenceContext(persistenceUnit, null, uriInfo.getBaseUri(), version, null);
            int result = context.queryExecuteUpdate(AbstractQueryResource.getMatrixParameters(uriInfo, persistenceUnit), queryName, AbstractQueryResource.getMatrixParameters(uriInfo, queryName), AbstractQueryResource.getQueryParameters(uriInfo));
            JAXBElement jaxbElement = new JAXBElement(new QName("result"), Integer.class, (Object)result);
            return Response.ok((Object)new StreamingOutputMarshaller(context, (Object)jaxbElement, headers.getAcceptableMediaTypes())).build();
        }
        catch (Exception ex) {
            throw JPARSException.exceptionOccurred(ex);
        }
    }

    protected Response namedQueryInternal(String version, String persistenceUnit, String queryName, HttpHeaders headers, UriInfo uriInfo) {
        JPARSLogger.entering(CLASS_NAME, "namedQueryInternal", new Object[]{"GET", version, persistenceUnit, queryName, uriInfo.getRequestUri().toASCIIString()});
        try {
            PersistenceContext context = this.getPersistenceContext(persistenceUnit, null, uriInfo.getBaseUri(), version, null);
            Query query = context.buildQuery(AbstractQueryResource.getMatrixParameters(uriInfo, persistenceUnit), queryName, AbstractQueryResource.getMatrixParameters(uriInfo, queryName), AbstractQueryResource.getQueryParameters(uriInfo));
            DatabaseQuery dbQuery = ((EJBQueryImpl)query).getDatabaseQuery();
            FeatureSet featureSet = context.getSupportedFeatureSet();
            Response response = featureSet.isSupported(FeatureSet.Feature.PAGING) ? this.processPageableQuery(context, queryName, dbQuery, query, headers, uriInfo) : this.namedQueryResponse(context, queryName, dbQuery, query, headers, uriInfo, featureSet.getResponseBuilder(FeatureSet.Feature.NO_PAGING));
            return response;
        }
        catch (Exception ex) {
            throw JPARSException.exceptionOccurred(ex);
        }
    }

    protected Response buildQueryOptionsResponse(String version, String persistenceUnit, String queryName, HttpHeaders httpHeaders, UriInfo uriInfo) {
        JPARSLogger.entering(CLASS_NAME, "buildQueryOptionsResponse", new Object[]{"GET", version, persistenceUnit, queryName, uriInfo.getRequestUri().toASCIIString()});
        PersistenceContext context = this.getPersistenceContext(persistenceUnit, null, uriInfo.getBaseUri(), version, null);
        DatabaseQuery query = context.getServerSession().getQuery(queryName);
        if (query == null) {
            JPARSLogger.error(context.getSessionLog(), "jpars_could_not_find_query", new Object[]{queryName, persistenceUnit});
            throw JPARSException.responseCouldNotBeBuiltForNamedQueryRequest(queryName, context.getName());
        }
        String linkValue = "<" + HrefHelper.buildQueryMetadataHref(context, queryName) + ">; rel=describedby";
        httpHeaders.getRequestHeaders().putSingle((Object)"Link", (Object)linkValue);
        return Response.ok().header("Link", (Object)linkValue).build();
    }

    private Response processPageableQuery(PersistenceContext context, String queryName, DatabaseQuery dbQuery, Query query, HttpHeaders headers, UriInfo uriInfo) {
        PageableQueryValidator validator = new PageableQueryValidator(context, queryName, uriInfo);
        if (validator.isFeatureApplicable()) {
            query.setFirstResult(validator.getOffset());
            query.setMaxResults(validator.getLimit() + 1);
            return this.namedQueryResponse(context, queryName, dbQuery, query, headers, uriInfo, new PagingResponseBuilder());
        }
        return this.namedQueryResponse(context, queryName, dbQuery, query, headers, uriInfo, new SelfLinksResponseBuilder());
    }

    private Response namedQueryResponse(PersistenceContext context, String queryName, DatabaseQuery dbQuery, Query query, HttpHeaders headers, UriInfo uriInfo, FeatureResponseBuilder responseBuilder) {
        FieldsFilteringValidator fieldsFilteringValidator;
        Map<String, Object> queryParams = AbstractQueryResource.getQueryParameters(uriInfo);
        if (query.getMaxResults() != Integer.MAX_VALUE) {
            queryParams.put("limit", String.valueOf(query.getMaxResults() - 1));
            queryParams.put("offset", String.valueOf(query.getFirstResult()));
        }
        FieldsFilter fieldsFilter = null;
        if (context.getSupportedFeatureSet().isSupported(FeatureSet.Feature.FIELDS_FILTERING) && (fieldsFilteringValidator = new FieldsFilteringValidator(uriInfo)).isFeatureApplicable()) {
            fieldsFilter = fieldsFilteringValidator.getFilter();
        }
        if (dbQuery instanceof ReportQuery) {
            List reportItems = ((ReportQuery)dbQuery).getItems();
            List queryResults = query.getResultList();
            if (queryResults != null && !queryResults.isEmpty()) {
                Object list = responseBuilder.buildReportQueryResponse(context, queryParams, queryResults, reportItems, uriInfo);
                if (list != null) {
                    return Response.ok((Object)new StreamingOutputMarshaller(context, list, headers.getAcceptableMediaTypes(), fieldsFilter)).build();
                }
                throw JPARSException.responseCouldNotBeBuiltForNamedQueryRequest(queryName, context.getName());
            }
            return Response.ok((Object)new StreamingOutputMarshaller(context, queryResults, headers.getAcceptableMediaTypes(), fieldsFilter)).build();
        }
        List results = query.getResultList();
        if (results != null) {
            Object list = responseBuilder.buildReadAllQueryResponse(context, queryParams, results, uriInfo);
            return Response.ok((Object)new StreamingOutputMarshaller(context, list, headers.getAcceptableMediaTypes(), fieldsFilter)).build();
        }
        return Response.ok((Object)new StreamingOutputMarshaller(context, results, headers.getAcceptableMediaTypes(), fieldsFilter)).build();
    }
}

