/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWXmlSchema;
import org.eclipse.persistence.tools.workbench.uitools.Displayable;
import org.eclipse.persistence.tools.workbench.utility.AbstractModel;

public class XmlSchemaDisplayableAdapter
extends AbstractModel
implements Displayable {
    private MWXmlSchema schema;
    private ResourceRepository resourceRepository;

    XmlSchemaDisplayableAdapter(MWXmlSchema schema, ResourceRepository resourceRepository) {
        this.initialize(schema, resourceRepository);
    }

    private void initialize(MWXmlSchema schema, ResourceRepository resourceRepository) {
        this.schema = schema;
        this.schema.addPropertyChangeListener("name", this.buildPropertyChangeListener());
        this.resourceRepository = resourceRepository;
    }

    private PropertyChangeListener buildPropertyChangeListener() {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                XmlSchemaDisplayableAdapter.this.firePropertyChanged("displayString", XmlSchemaDisplayableAdapter.this.displayString((String)evt.getOldValue()), XmlSchemaDisplayableAdapter.this.displayString((String)evt.getNewValue()));
            }
        };
    }

    @Override
    public String displayString() {
        return this.displayString(this.schema.getName());
    }

    @Override
    public Icon icon() {
        return this.resourceRepository.getIcon("file.xml");
    }

    public int compareTo(Object o) {
        return DEFAULT_COMPARATOR.compare(this, o);
    }

    private String displayString(String schemaName) {
        return schemaName;
    }
}

