/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries.optimization;

import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class ReadAnyObjectJoinPhoneTest
extends AutoVerifyTestCase {
    public ReadAnyObjectJoinPhoneTest() {
        this.setDescription("Test read-object queries with no where clause an 1-m joining.");
    }

    public void test() {
        ReadObjectQuery query = new ReadObjectQuery();
        query.setReferenceClass(Employee.class);
        query.addJoinedAttribute(query.getExpressionBuilder().anyOf("phoneNumbers"));
        Employee employee = (Employee)this.getSession().executeQuery((DatabaseQuery)query);
        if (!employee.phoneNumbers.isInstantiated()) {
            throw new TestErrorException("Employee phones not populated from join.");
        }
        if (employee.getPhoneNumbers().size() > 5) {
            throw new TestErrorException("Employee phones not filtered.");
        }
    }
}

