/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.collections.map;

import java.util.Collection;
import java.util.List;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.indirection.IndirectMap;
import org.eclipse.persistence.mappings.AggregateCollectionMapping;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.collections.map.AggregateMapValue;
import org.eclipse.persistence.testing.models.collections.map.EntityAggregateMapHolder;
import org.eclipse.persistence.testing.models.collections.map.EntityMapKey;

public class TestReadEntityAggregateMapMapping
extends TestCase {
    protected List holders = null;
    protected int fetchJoinRelationship = 0;
    protected int oldFetchJoinValue = 0;
    protected AggregateCollectionMapping mapping = null;
    protected Expression holderExp;

    public TestReadEntityAggregateMapMapping() {
    }

    public TestReadEntityAggregateMapMapping(int fetchJoin) {
        this();
        this.fetchJoinRelationship = fetchJoin;
        this.setName("TestReadEntityAggregateMapMapping fetchJoin = " + fetchJoin);
    }

    public void setup() {
        this.mapping = (AggregateCollectionMapping)this.getSession().getProject().getDescriptor(EntityAggregateMapHolder.class).getMappingForAttributeName("entityToAggregateMap");
        this.oldFetchJoinValue = this.mapping.getJoinFetch();
        this.mapping.setJoinFetch(this.fetchJoinRelationship);
        this.getSession().getProject().getDescriptor(EntityAggregateMapHolder.class).reInitializeJoinedAttributes();
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        EntityAggregateMapHolder holder = new EntityAggregateMapHolder();
        AggregateMapValue value = new AggregateMapValue();
        value.setValue(1);
        EntityMapKey key = new EntityMapKey();
        key.setData("11");
        key.setId(1);
        holder.addEntityToAggregateMapItem(key, value);
        uow.registerObject((Object)key);
        AggregateMapValue value2 = new AggregateMapValue();
        value2.setValue(2);
        key = new EntityMapKey();
        key.setData("22");
        key.setId(2);
        holder.addEntityToAggregateMapItem(key, value2);
        uow.registerObject((Object)holder);
        uow.registerObject((Object)key);
        uow.commit();
        this.holderExp = new ExpressionBuilder().get("id").equal(holder.getId());
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public void test() {
        this.holders = this.getSession().readAllObjects(EntityAggregateMapHolder.class, this.holderExp);
    }

    public void verify() {
        if (this.holders == null || this.holders.size() != 1) {
            throw new TestErrorException("Incorrect number of MapHolders was read.");
        }
        EntityAggregateMapHolder holder = (EntityAggregateMapHolder)this.holders.get(0);
        if (!((IndirectMap)holder.getEntityToAggregateMap()).getValueHolder().isInstantiated() && this.fetchJoinRelationship > 0) {
            throw new TestErrorException("Relationship was not properly joined.");
        }
        if (holder.getEntityToAggregateMap().size() != 2) {
            throw new TestErrorException("Incorrect Number of MapEntityValues was read.");
        }
        EntityMapKey mapKey = new EntityMapKey();
        mapKey.setData("11");
        mapKey.setId(1);
        AggregateMapValue value = (AggregateMapValue)holder.getEntityToAggregateMap().get(mapKey);
        if (value.getValue() != 1) {
            throw new TestErrorException("Incorrect MapEntityValues was read.");
        }
    }

    public void reset() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        uow.deleteAllObjects((Collection)this.holders);
        uow.commit();
        if (!this.verifyDelete(this.holders.get(0))) {
            throw new TestErrorException("Delete was unsuccessful.");
        }
        this.mapping.setJoinFetch(this.oldFetchJoinValue);
    }
}

