/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.ui.tools;

import java.text.ParseException;
import java.util.StringTokenizer;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public final class IPAddress {
    private final String ipAddress;
    private final int[] ipAddresses;

    public IPAddress() {
        this.ipAddress = "0.0.0.0";
        this.ipAddresses = new int[4];
    }

    public IPAddress(int[] ipAddresses) throws ParseException {
        if (ipAddresses == null) {
            this.ipAddress = "0.0.0.0";
            this.ipAddresses = new int[4];
        } else {
            this.ipAddress = IPAddress.convert(ipAddresses);
            this.ipAddresses = ipAddresses;
        }
    }

    public IPAddress(String ipAddress) throws ParseException {
        if (ipAddress == null) {
            this.ipAddress = "0.0.0.0";
            this.ipAddresses = new int[4];
        } else {
            this.ipAddress = ipAddress;
            this.ipAddresses = IPAddress.convert(ipAddress);
        }
    }

    public static String convert(int[] ipAddresses) throws ParseException {
        if (ipAddresses == null) {
            throw new ParseException("The array of integers cannot be null", 0);
        }
        if (ipAddresses.length != 4) {
            throw new ParseException("The array does not have a length of 4", 0);
        }
        if (!IPAddress.isValid(ipAddresses)) {
            throw new ParseException("The values are not in the range [0, 255]", 0);
        }
        StringBuffer sb = new StringBuffer(15);
        sb.append(ipAddresses[0]);
        sb.append(".");
        sb.append(ipAddresses[1]);
        sb.append(".");
        sb.append(ipAddresses[2]);
        sb.append(".");
        sb.append(ipAddresses[3]);
        return sb.toString();
    }

    public static int[] convert(String ipAddress) throws ParseException {
        if (ipAddress == null) {
            throw new ParseException("The value cannot be null", 0);
        }
        StringTokenizer tokenizer = new StringTokenizer(ipAddress, ".");
        if (tokenizer.countTokens() != 4) {
            throw new ParseException("The IP address is not valid, it does not have 4 sets of digits", 0);
        }
        int[] ipAddresses = new int[4];
        try {
            for (int index = 0; index < 4; ++index) {
                ipAddresses[index] = new Integer(tokenizer.nextToken());
            }
        }
        catch (Throwable throwable) {
            throw new ParseException("The IP address is not valid, then cannot be converted into an array of integers", 0);
        }
        if (!IPAddress.isValid(ipAddresses)) {
            throw new ParseException("The values are not in the range [0, 255]", 0);
        }
        return ipAddresses;
    }

    public static boolean isValid(int[] ipAddresses) {
        if (ipAddresses == null || ipAddresses.length != 4) {
            return false;
        }
        int index = ipAddresses.length;
        while (--index >= 0) {
            if (ipAddresses[index] >= 0 && ipAddresses[index] <= 255) continue;
            return false;
        }
        return true;
    }

    public static boolean isValid(String ipAddress) {
        try {
            return IPAddress.isValid(IPAddress.convert(ipAddress));
        }
        catch (ParseException exception) {
            return false;
        }
    }

    public String ipAddress() {
        return this.ipAddress;
    }

    public int[] ipAddresses() {
        return this.ipAddresses;
    }

    public final String toString() {
        StringBuffer sb = new StringBuffer();
        StringTools.buildSimpleToStringOn((Object)this, (StringBuffer)sb);
        sb.append(" (");
        this.toString(sb);
        sb.append(')');
        return sb.toString();
    }

    public void toString(StringBuffer buffer) {
        buffer.append("ipAddress=");
        buffer.append(this.ipAddress);
    }
}

