/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.ui.pool.basic;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import org.eclipse.persistence.tools.workbench.framework.context.ApplicationContext;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractSubjectPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.ConnectionPoolAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.DatabaseSessionAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.LoginAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.ServerSessionAdapter;
import org.eclipse.persistence.tools.workbench.uitools.ComponentEnabler;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.TransformationPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.NumberSpinnerModelAdapter;

public final class ConnectionCountPane
extends AbstractSubjectPanel {
    public ConnectionCountPane(PropertyValueModel subjectHolder, ApplicationContext context) {
        super((ValueModel)subjectHolder, context);
    }

    private ComponentEnabler buildComponentEnabler() {
        return new ComponentEnabler((ValueModel)this.buildEnableStateHolder(), this.getComponents());
    }

    private PropertyValueModel buildEnableStateHolder() {
        PropertyAspectAdapter sessionHolder = new PropertyAspectAdapter(this.getSubjectHolder(), ""){

            @Override
            protected Object getValueFromSubject() {
                ConnectionPoolAdapter pool = (ConnectionPoolAdapter)this.subject;
                return pool.getParent().getParent();
            }
        };
        PropertyAspectAdapter loginHolder = new PropertyAspectAdapter(sessionHolder, "login"){

            @Override
            protected Object getValueFromSubject() {
                ServerSessionAdapter session = (ServerSessionAdapter)this.subject;
                return session.getLogin();
            }
        };
        PropertyAspectAdapter booleanHolder = new PropertyAspectAdapter(loginHolder, "externalConnectionPooling"){

            @Override
            protected Object getValueFromSubject() {
                LoginAdapter login = (LoginAdapter)this.subject;
                DatabaseSessionAdapter session = (DatabaseSessionAdapter)login.getParent();
                return session.usesExternalConnectionPooling();
            }
        };
        return new TransformationPropertyValueModel(booleanHolder){

            @Override
            protected Object transform(Object value) {
                return Boolean.FALSE.equals(value);
            }
        };
    }

    private PropertyValueModel buildMaximumCountHolder() {
        return new PropertyAspectAdapter(this.getSubjectHolder(), "maxConnections"){

            @Override
            protected Object getValueFromSubject() {
                ConnectionPoolAdapter pool = (ConnectionPoolAdapter)this.subject;
                return new Integer(pool.getMaxConnections());
            }

            @Override
            protected void setValueOnSubject(Object value) {
                ConnectionPoolAdapter pool = (ConnectionPoolAdapter)this.subject;
                pool.setMaxConnections((Integer)value);
            }
        };
    }

    private SpinnerNumberModel buildMaximumCountSpinnerAdapter() {
        return new NumberSpinnerModelAdapter(this.buildMaximumCountHolder(), 0, Integer.MAX_VALUE, 1);
    }

    private PropertyValueModel buildMinimumCountHolder() {
        return new PropertyAspectAdapter(this.getSubjectHolder(), "minConnections"){

            @Override
            protected Object getValueFromSubject() {
                ConnectionPoolAdapter pool = (ConnectionPoolAdapter)this.subject;
                return new Integer(pool.getMinConnections());
            }

            @Override
            protected void setValueOnSubject(Object value) {
                ConnectionPoolAdapter pool = (ConnectionPoolAdapter)this.subject;
                pool.setMinConnections((Integer)value);
            }
        };
    }

    private SpinnerNumberModel buildMinimumCountSpinnerAdapter() {
        return new NumberSpinnerModelAdapter(this.buildMinimumCountHolder(), 0, Integer.MAX_VALUE, 1);
    }

    @Override
    protected void initializeLayout() {
        this.setBorder(this.buildTitledBorder("CONNECTION_POOL_CONNECTION_COUNT_TITLE"));
        this.setName("CONNECTION_POOL_CONNECTION_COUNT_PANE");
        GridBagConstraints constraints = new GridBagConstraints();
        JLabel minimumConnectionsLabel = this.buildLabel("CONNECTION_POOL_MINIMUM_CONNECTIONS_SPINNER");
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 5, 0, 5);
        this.add((Component)minimumConnectionsLabel, constraints);
        JSpinner minimumConnectionsSpinner = SwingComponentFactory.buildSpinnerNumber(this.buildMinimumCountSpinnerAdapter());
        minimumConnectionsSpinner.setName("CONNECTION_POOL_MINIMUM_CONNECTIONS_SPINNER");
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 5, 0, 5);
        this.add((Component)minimumConnectionsSpinner, constraints);
        minimumConnectionsLabel.setLabelFor(minimumConnectionsSpinner);
        JLabel maximumConnectionsLabel = this.buildLabel("CONNECTION_POOL_MAXIMUM_CONNECTIONS_SPINNER");
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)maximumConnectionsLabel, constraints);
        JSpinner maximumConnectionsSpinner = SwingComponentFactory.buildSpinnerNumber(this.buildMaximumCountSpinnerAdapter());
        maximumConnectionsSpinner.setName("CONNECTION_POOL_MAXIMUM_CONNECTIONS_SPINNER");
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)maximumConnectionsSpinner, constraints);
        maximumConnectionsLabel.setLabelFor(maximumConnectionsSpinner);
        this.buildComponentEnabler();
    }
}

