/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.persistence.tools.workbench.framework.Plugin;
import org.eclipse.persistence.tools.workbench.framework.action.AbstractFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.action.FrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.app.GroupContainerDescription;
import org.eclipse.persistence.tools.workbench.framework.app.MenuGroupDescription;
import org.eclipse.persistence.tools.workbench.framework.app.RootMenuDescription;
import org.eclipse.persistence.tools.workbench.framework.app.ToolBarButtonGroupDescription;
import org.eclipse.persistence.tools.workbench.framework.app.ToolBarDescription;
import org.eclipse.persistence.tools.workbench.framework.context.ApplicationContext;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPropertiesPage;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWXmlSchema;
import org.eclipse.persistence.tools.workbench.mappingsplugin.RemovableNode;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.MappingsApplicationNode;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema.EditSchemaDialog;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema.SchemaDialogUtilities;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema.XmlSchemaPanel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema.XmlSchemaRepositoryNode;
import org.eclipse.persistence.tools.workbench.uitools.app.TreeNodeValueModel;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.TransformationIterator;

public final class XmlSchemaNode
extends MappingsApplicationNode
implements RemovableNode {
    Map propertiesPages;
    private WindowListener windowListener;
    protected static final String[] SCHEMA_DISPLAY_STRING_PROPERTY_NAMES = new String[]{"name"};

    public XmlSchemaNode(MWXmlSchema schema, XmlSchemaRepositoryNode schemaRepositoryNode) {
        this(schema, schemaRepositoryNode.getApplicationContext(), schemaRepositoryNode.getPlugin(), schemaRepositoryNode);
    }

    private XmlSchemaNode(MWXmlSchema schema, ApplicationContext context, Plugin plugin, XmlSchemaRepositoryNode schemaRepositoryNode) {
        super((MWModel)schema, (TreeNodeValueModel)schemaRepositoryNode, plugin, context);
    }

    protected void initialize() {
        super.initialize();
        this.propertiesPages = new HashMap();
        this.windowListener = this.buildWindowListener();
    }

    private WindowListener buildWindowListener() {
        return new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                XmlSchemaNode.this.disposePropertiesPage(e.getWindow());
            }
        };
    }

    FrameworkAction getReimportSchemaAction(WorkbenchContext context) {
        return new ReimportSchemaAction(context);
    }

    FrameworkAction getSchemaPropertiesAction(WorkbenchContext context) {
        return new SchemaPropertiesAction(context);
    }

    @Override
    public Component propertiesPage(WorkbenchContext context) {
        Window window = context.getCurrentWindow();
        Component propertiesPage = (Component)this.propertiesPages.get(window);
        if (propertiesPage == null) {
            propertiesPage = this.buildPropertiesPage(this.buildLocalWorkbenchContext(context));
            this.propertiesPages.put(window, propertiesPage);
            window.addWindowListener(this.windowListener);
        }
        return propertiesPage;
    }

    protected AbstractPropertiesPage buildPropertiesPage(WorkbenchContext context) {
        return new XmlSchemaPanel(this, context);
    }

    @Override
    protected void releasePropertiesPage(AbstractPropertiesPage propertiesPage) {
    }

    void disposePropertiesPages() {
        Iterator stream = this.propertiesPages.keySet().iterator();
        while (stream.hasNext()) {
            this.disposePropertiesPage((Window)stream.next());
        }
        this.propertiesPages.clear();
    }

    void disposePropertiesPage(Window keyWindow) {
        XmlSchemaPanel propertiesPage = (XmlSchemaPanel)this.propertiesPages.remove(keyWindow);
        propertiesPage.setNode(null, this.buildShellWorkbenchContext());
        keyWindow.removeWindowListener(this.windowListener);
    }

    @Override
    protected String buildDisplayString() {
        return this.getSchema().getName();
    }

    @Override
    protected String buildIconKey() {
        return "file.xml";
    }

    @Override
    protected String[] displayStringPropertyNames() {
        return SCHEMA_DISPLAY_STRING_PROPERTY_NAMES;
    }

    @Override
    public String helpTopicID() {
        return "xmlSchema";
    }

    MWXmlSchema getSchema() {
        return (MWXmlSchema)this.getValue();
    }

    @Override
    public GroupContainerDescription buildMenuDescription(WorkbenchContext workbenchContext) {
        WorkbenchContext localContext = this.buildLocalWorkbenchContext(workbenchContext);
        RootMenuDescription menuDesc = new RootMenuDescription();
        MenuGroupDescription groupDesc = new MenuGroupDescription();
        groupDesc.add(this.getReimportSchemaAction(localContext));
        groupDesc.add(this.getSchemaPropertiesAction(localContext));
        groupDesc.add(this.getMappingsPlugin().getRemoveAction(localContext));
        menuDesc.add(groupDesc);
        menuDesc.add(this.buildOracleHelpMenuGroup(localContext));
        return menuDesc;
    }

    @Override
    public GroupContainerDescription buildToolBarDescription(WorkbenchContext workbenchContext) {
        ToolBarDescription desc = new ToolBarDescription();
        ToolBarButtonGroupDescription buttonGroup = new ToolBarButtonGroupDescription();
        buttonGroup.add(this.getReimportSchemaAction(this.buildLocalWorkbenchContext(workbenchContext)));
        desc.add(buttonGroup);
        return desc;
    }

    @Override
    public String getName() {
        return this.getSchema().getName();
    }

    @Override
    public void remove() {
        this.getSchema().schemaRepository().removeSchema(this.getSchema());
    }

    private final class SchemaPropertiesAction
    extends AbstractFrameworkAction {
        private SchemaPropertiesAction(WorkbenchContext context) {
            super(context);
        }

        @Override
        protected void initialize() {
            this.setIcon(EMPTY_ICON);
            this.initializeTextAndMnemonic("SCHEMA_PROPERTIES_ACTION");
            this.initializeToolTipText("SCHEMA_PROPERTIES_ACTION.TOOL_TIP");
            this.setEnabled(true);
        }

        @Override
        protected void execute(ApplicationNode selectedNode) {
            new EditSchemaDialog(this.getWorkbenchContext(), ((XmlSchemaNode)selectedNode).getSchema()).promptToEditSchema();
            this.navigatorSelectionModel().setSelectedNode(selectedNode);
        }
    }

    private final class ReimportSchemaAction
    extends AbstractFrameworkAction {
        private ReimportSchemaAction(WorkbenchContext context) {
            super(context);
        }

        @Override
        protected void initialize() {
            this.initializeTextAndMnemonic("REIMPORT_SCHEMA_ACTION");
            this.initializeToolTipText("REIMPORT_SCHEMA_ACTION.TOOL_TIP");
            this.initializeIcon("file.xml.refresh");
            this.setEnabled(true);
        }

        @Override
        protected void execute() {
            Iterator nodesIterator = CollectionTools.iterator((Object[])this.selectedNodes());
            TransformationIterator schemasIterator = new TransformationIterator(nodesIterator){

                protected Object transform(Object next) {
                    return ((XmlSchemaNode)next).getSchema();
                }
            };
            SchemaDialogUtilities.reloadSchemas(this.getWorkbenchContext(), (Iterator)schemasIterator);
        }
    }
}

