/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPanel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWAttributeItem;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWGroupingItem;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWQueryItem;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWReportOrderingItem;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWReportQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.Ordering;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.AttributeItemDialog;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.GroupingAttributesPanel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.OrderingAttributesPanel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.ReportQueryOrderingAttributeDialog;
import org.eclipse.persistence.tools.workbench.uitools.app.FilteringPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.utility.filters.Filter;

final class ReportQueryGroupingOrderingPanel
extends AbstractPanel {
    private PropertyValueModel queryHolder;
    private OrderingAttributesPanel orderingPanel;
    private GroupingAttributesPanel groupingAttributesPanel;

    public ReportQueryGroupingOrderingPanel(PropertyValueModel queryHolder, WorkbenchContextHolder contextHolder) {
        super(contextHolder);
        this.queryHolder = this.buildReportQueryHolder(queryHolder);
        this.initializeLayout();
    }

    private PropertyValueModel buildReportQueryHolder(PropertyValueModel queryHolder) {
        return new FilteringPropertyValueModel(queryHolder){

            @Override
            protected boolean accept(Object value) {
                return value instanceof MWReportQuery;
            }
        };
    }

    private void initializeLayout() {
        GridBagConstraints constraints = new GridBagConstraints();
        this.groupingAttributesPanel = new GroupingAttributesPanel(this.queryHolder, this.getWorkbenchContextHolder());
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.groupingAttributesPanel, constraints);
        this.orderingPanel = new OrderingAttributesPanel(this.queryHolder, Filter.NULL_INSTANCE, this.buildOrderingChooseableFilter(), this.getWorkbenchContextHolder()){

            @Override
            AttributeItemDialog buildAttributeItemDialog(MWAttributeItem item) {
                return new ReportQueryOrderingAttributeDialog((MWReportQuery)this.getQuery(), (MWReportOrderingItem)item, this.getTraversableFilter(), this.getChooseableFilter(), this.getWorkbenchContext());
            }
        };
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.orderingPanel, constraints);
    }

    private Filter buildOrderingChooseableFilter() {
        return Filter.NULL_INSTANCE;
    }

    void selectOrderingItem(Ordering orderingItem) {
        this.orderingPanel.select((MWQueryItem)orderingItem);
    }

    void selectGroupingItem(MWGroupingItem groupingItem) {
        this.groupingAttributesPanel.select((MWQueryItem)groupingItem);
    }
}

