/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.Iterator;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.eclipse.persistence.tools.workbench.framework.context.DefaultWorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.ClassChooserPanel;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractDialog;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractValidatingDialog;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.Spacer;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassRepository;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQuery;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.meta.ClassChooserTools;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.meta.ClassRepositoryHolder;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.DocumentAdapter;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public class QueryParameterDialog
extends AbstractValidatingDialog {
    private JTextField parameterNameField;
    private PropertyValueModel parameterNameHolder;
    private PropertyValueModel parameterTypeHolder;
    private MWQuery query;

    public QueryParameterDialog(MWQuery query, MWClass type, String name, AbstractDialog dialog, WorkbenchContext context, String title) {
        super(context, title, dialog);
        this.query = query;
        this.parameterTypeHolder = new SimplePropertyValueModel(type);
        this.parameterNameHolder = new SimplePropertyValueModel(name);
    }

    public QueryParameterDialog(MWQuery query, MWClass type, String name, WorkbenchContext context, String title) {
        super(context, title);
        this.query = query;
        this.parameterTypeHolder = new SimplePropertyValueModel(type);
        this.parameterNameHolder = new SimplePropertyValueModel(name);
    }

    private ClassRepositoryHolder buildClassRepositoryHolder() {
        return new ClassRepositoryHolder(){

            @Override
            public MWClassRepository getClassRepository() {
                return QueryParameterDialog.this.query.getRepository();
            }
        };
    }

    @Override
    protected Component buildMainPanel() {
        return new MainPanel((WorkbenchContextHolder)new DefaultWorkbenchContextHolder(this.getWorkbenchContext()));
    }

    private Document buildParameterNameDocumentAdapter() {
        DocumentAdapter adapter = new DocumentAdapter(this.parameterNameHolder);
        adapter.addDocumentListener(this.buildParameterNameDocumentListener());
        return adapter;
    }

    private DocumentListener buildParameterNameDocumentListener() {
        return new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                if (QueryParameterDialog.this.isVisible()) {
                    QueryParameterDialog.this.updateDialogState();
                }
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                if (QueryParameterDialog.this.isVisible()) {
                    QueryParameterDialog.this.updateDialogState();
                }
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                if (QueryParameterDialog.this.isVisible()) {
                    QueryParameterDialog.this.updateDialogState();
                }
            }
        };
    }

    public String getParameterName() {
        return (String)this.parameterNameHolder.getValue();
    }

    public MWClass getParameterType() {
        return (MWClass)this.parameterTypeHolder.getValue();
    }

    private String getPotentialParameterName() {
        return this.parameterNameField.getText();
    }

    @Override
    protected String helpTopicId() {
        return "descriptor.queryManager.general.parameters.addParameter";
    }

    @Override
    protected Component initialFocusComponent() {
        return this.parameterNameField;
    }

    private void updateDialogState() {
        String parameterName = this.getPotentialParameterName();
        String message = null;
        if (StringTools.stringIsEmpty((String)parameterName)) {
            message = this.resourceRepository().getString("QUERY_PARAMETER_DIALOG_NO_PARAMETER_NAME_SPECIFIED");
        } else if (CollectionTools.contains((Iterator)this.query.parameterNames(), (Object)parameterName)) {
            message = this.resourceRepository().getString("QUERY_PARAMETER_DIALOG_CLASS_ALREADY_EXISTS", parameterName);
        }
        this.setErrorMessage(message);
        this.getOKAction().setEnabled(message == null);
    }

    private class MainPanel
    extends AbstractPanel {
        MainPanel(WorkbenchContextHolder contextHolder) {
            super(contextHolder);
            this.initializeLayout();
        }

        private void initializeLayout() {
            GridBagConstraints constraints = new GridBagConstraints();
            JLabel parameterTypeLabel = SwingComponentFactory.buildLabel("QUERY_PARAMETER_DIALOG.PARAMETER_TYPE_LABEL", this.resourceRepository());
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.weightx = 0.0;
            constraints.weighty = 0.0;
            constraints.fill = 0;
            constraints.anchor = 21;
            constraints.insets = new Insets(0, 0, 0, 0);
            this.add((Component)parameterTypeLabel, constraints);
            ClassChooserPanel parameterTypeChooserPanel = ClassChooserTools.buildPanel(QueryParameterDialog.this.parameterTypeHolder, QueryParameterDialog.this.buildClassRepositoryHolder(), ClassChooserTools.buildDeclarableNonVoidFilter(), parameterTypeLabel, new DefaultWorkbenchContextHolder(this.getWorkbenchContext()));
            this.helpManager().addTopicID(parameterTypeChooserPanel, QueryParameterDialog.this.helpTopicId() + ".type");
            constraints.gridx = 1;
            constraints.gridy = 0;
            constraints.gridwidth = 2;
            constraints.gridheight = 1;
            constraints.weightx = 1.0;
            constraints.weighty = 0.0;
            constraints.fill = 2;
            constraints.anchor = 10;
            constraints.insets = new Insets(0, 5, 0, 0);
            this.add((Component)parameterTypeChooserPanel, constraints);
            this.addPaneForAlignment(parameterTypeChooserPanel);
            JLabel parameterNameLabel = SwingComponentFactory.buildLabel("QUERY_PARAMETER_DIALOG.PARAMETER_NAME_LABEL", this.resourceRepository());
            constraints.gridx = 0;
            constraints.gridy = 1;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.weightx = 0.0;
            constraints.weighty = 0.0;
            constraints.fill = 0;
            constraints.anchor = 21;
            constraints.insets = new Insets(5, 0, 0, 0);
            this.add((Component)parameterNameLabel, constraints);
            QueryParameterDialog.this.parameterNameField = new JTextField(QueryParameterDialog.this.buildParameterNameDocumentAdapter(), null, 1);
            constraints.gridx = 1;
            constraints.gridy = 1;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.weightx = 1.0;
            constraints.weighty = 0.0;
            constraints.fill = 2;
            constraints.anchor = 10;
            constraints.insets = new Insets(5, 5, 0, 0);
            this.add((Component)QueryParameterDialog.this.parameterNameField, constraints);
            parameterNameLabel.setLabelFor(QueryParameterDialog.this.parameterNameField);
            Spacer spacer = new Spacer();
            constraints.gridx = 2;
            constraints.gridy = 1;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.weightx = 0.0;
            constraints.weighty = 0.0;
            constraints.fill = 0;
            constraints.anchor = 10;
            constraints.insets = new Insets(5, 5, 0, 0);
            this.add((Component)spacer, constraints);
            this.addAlignRight(spacer);
        }
    }
}

