/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Document;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.NewNameDialog;
import org.eclipse.persistence.tools.workbench.framework.ui.view.ScrollablePropertiesPage;
import org.eclipse.persistence.tools.workbench.framework.uitools.AddRemoveListPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.AddRemovePanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.RegexpDocument;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWMappingDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQueryManager;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQueryParameter;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWQueryItem;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWRelationalQueryManager;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.AddQueryDialog;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.QueryGeneralPanel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.QueryQuickViewItem;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.QuickViewPanel;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ItemPropertyListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SortedListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.TransformationPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.DocumentAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ObjectListSelectionModel;
import org.eclipse.persistence.tools.workbench.uitools.cell.SimpleListCellRenderer;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;

public abstract class QueriesPropertiesPage
extends ScrollablePropertiesPage {
    private PropertyValueModel queryManagerHolder;
    private PropertyValueModel queryHolder;
    private CollectionValueModel queriesHolder;

    protected QueriesPropertiesPage(PropertyValueModel relationalDescriptorNodeHolder, WorkbenchContextHolder contextHolder) {
        super(relationalDescriptorNodeHolder, contextHolder);
    }

    @Override
    protected void initialize(PropertyValueModel nodeHolder) {
        super.initialize(nodeHolder);
        this.queryManagerHolder = this.buildQueryManagerHolder();
        this.queryHolder = new SimplePropertyValueModel();
        this.queriesHolder = this.buildQueriesHolder();
    }

    protected abstract PropertyValueModel buildQueryManagerHolder();

    protected ListCellRenderer buildQueriesListCellRenderer() {
        return new SimpleListCellRenderer(){

            @Override
            protected String buildText(Object value) {
                return ((MWQuery)value).signature();
            }
        };
    }

    private ListValueModel buildItemListValueModelAdapter() {
        return new ItemPropertyListValueModelAdapter(this.buildSortedQueryListValueModelAdapter(), "signature");
    }

    private ListValueModel buildSortedQueryListValueModelAdapter() {
        return new SortedListValueModelAdapter(this.buildItemNameListValueModelAdapter());
    }

    private ListValueModel buildItemNameListValueModelAdapter() {
        return new ItemPropertyListValueModelAdapter(this.queriesHolder, "name");
    }

    private CollectionValueModel buildQueriesHolder() {
        return new CollectionAspectAdapter(this.queryManagerHolder, "queries"){

            @Override
            protected Iterator getValueFromSubject() {
                return ((MWQueryManager)this.subject).queries();
            }

            @Override
            protected int sizeFromSubject() {
                return ((MWQueryManager)this.subject).queriesSize();
            }
        };
    }

    protected ListSelectionListener buildQueryListSelectionListener() {
        return new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    ObjectListSelectionModel listSelectionModel = (ObjectListSelectionModel)e.getSource();
                    Object[] values = listSelectionModel.getSelectedValues();
                    if (values.length == 1) {
                        QueriesPropertiesPage.this.queryHolder.setValue(values[0]);
                    } else {
                        QueriesPropertiesPage.this.queryHolder.setValue(null);
                    }
                }
            }
        };
    }

    protected AddRemoveListPanel buildQueriesListPanel() {
        AddRemoveListPanel queriesListPanel = new AddRemoveListPanel(this.getApplicationContext(), (AddRemovePanel.Adapter)this.buildAddRemoveListPanelAdapter(), this.buildItemListValueModelAdapter(), this.resourceRepository().getString("NAMED_QUERIES_LIST"));
        queriesListPanel.setCellRenderer(this.buildQueriesListCellRenderer());
        queriesListPanel.addListSelectionListener(this.buildQueryListSelectionListener());
        return queriesListPanel;
    }

    protected AddRemovePanel.OptionAdapter buildAddRemoveListPanelAdapter() {
        return new AddRemovePanel.OptionAdapter(){

            @Override
            public void addNewItem(ObjectListSelectionModel listSelectionModel) {
                QueriesPropertiesPage.this.promptToAddQuery(listSelectionModel);
            }

            @Override
            public void removeSelectedItems(ObjectListSelectionModel listSelectionModel) {
                QueriesPropertiesPage.this.removeSelectedQueries(listSelectionModel);
            }

            @Override
            public void optionOnSelection(ObjectListSelectionModel listSelectionModel) {
                QueriesPropertiesPage.this.promptToRenameQuery(listSelectionModel);
            }

            @Override
            public boolean enableOptionOnSelectionChange(ObjectListSelectionModel listSelectionModel) {
                return listSelectionModel.getSelectedValuesSize() == 1;
            }

            @Override
            public String optionalButtonKey() {
                return "RENAME_BUTTON";
            }
        };
    }

    protected void promptToAddQuery(ObjectListSelectionModel listSelectionModel) {
        MWMappingDescriptor descriptor = this.getQueryManager().getOwningDescriptor();
        AddQueryDialog dlg = new AddQueryDialog(this.getWorkbenchContext(), descriptor.getTransactionalPolicy().getQueryManager().supportsReportQueries());
        dlg.show();
        if (dlg.wasConfirmed()) {
            String queryType = dlg.getQueryType();
            String queryName = dlg.getQueryName();
            Object newQuery = queryType == "READ_OBJECT_QUERY" ? this.getQueryManager().addReadObjectQuery(queryName) : (queryType == "READ_ALL_QUERY" ? this.getQueryManager().addReadAllQuery(queryName) : ((MWRelationalQueryManager)this.getQueryManager()).addReportQuery(queryName));
            listSelectionModel.setSelectedValue(newQuery);
        }
    }

    protected void removeSelectedQueries(ObjectListSelectionModel listSelectionModel) {
        Iterator queries = CollectionTools.iterator((Object[])listSelectionModel.getSelectedValues());
        while (queries.hasNext()) {
            this.getQueryManager().removeQuery((MWQuery)queries.next());
        }
    }

    public void promptToRenameQuery(ObjectListSelectionModel listSelectionModel) {
        final MWQuery selectedQuery = (MWQuery)listSelectionModel.getSelectedValue();
        NewNameDialog.Builder builder = new NewNameDialog.Builder(){

            @Override
            public String getTitle() {
                return QueriesPropertiesPage.this.resourceRepository().getString("RENAME_QUERY_DIALOG.title");
            }

            @Override
            public String getTextFieldDescription() {
                return QueriesPropertiesPage.this.resourceRepository().getString("RENAME_QUERY_DIALOG.message");
            }

            @Override
            public String getOriginalName() {
                return selectedQuery.getName();
            }

            @Override
            public String getHelpTopicId() {
                return "descriptor.queryManager.namedQueries";
            }

            @Override
            protected NewNameDialog.DocumentFactory buildDefaultDocumentFactory() {
                return new NewNameDialog.DocumentFactory(){

                    @Override
                    public Document buildDocument() {
                        return new RegexpDocument(5);
                    }
                };
            }
        };
        NewNameDialog dialog = builder.buildDialog(this.getWorkbenchContext());
        dialog.show();
        if (dialog.wasConfirmed()) {
            selectedQuery.setName(dialog.getNewName());
            listSelectionModel.setSelectedValue(selectedQuery);
        }
    }

    protected final MWQueryManager getQueryManager() {
        return (MWQueryManager)this.getQueryManagerHolder().getValue();
    }

    protected String helpTopicId() {
        return "descriptor.queries";
    }

    protected PropertyValueModel getQueryManagerHolder() {
        return this.queryManagerHolder;
    }

    protected PropertyValueModel getQueryHolder() {
        return this.queryHolder;
    }

    protected QuickViewPanel.QuickViewItem buildQueryParameterQuickViewItem(MWQueryItem queryItem) {
        return new QueryQuickViewItem(queryItem){

            @Override
            public void select() {
                QueriesPropertiesPage.this.selectGeneralPanel();
                QueriesPropertiesPage.this.getQueryGeneralPanel().selectParameter((MWQueryParameter)this.getValue());
            }

            @Override
            public String displayString() {
                MWQueryParameter parameter = (MWQueryParameter)this.getValue();
                return QueriesPropertiesPage.this.resourceRepository().getString("QUICK_VIEW_PARAMETER_LABEL", parameter.getName(), ClassTools.shortNameForClassNamed((String)parameter.getType().getName()));
            }
        };
    }

    protected abstract QueryGeneralPanel getQueryGeneralPanel();

    protected abstract JTabbedPane getQueryTabbedPane();

    protected void selectGeneralPanel() {
        this.getQueryTabbedPane().setSelectedComponent(this.getQueryGeneralPanel());
    }

    protected JComponent buildEmptyPanel() {
        GridBagConstraints constraints = new GridBagConstraints();
        JPanel container = new JPanel(new GridBagLayout());
        JPanel emptyPanel = new JPanel();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 10;
        constraints.insets = new Insets(3, 3, 3, 3);
        container.add((Component)emptyPanel, constraints);
        JTabbedPane pane = new JTabbedPane(1);
        pane.setFocusable(false);
        pane.setRequestFocusEnabled(false);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 0, 0, 0);
        container.add((Component)pane, constraints);
        return container;
    }

    protected final Document buildQueryVarietyDocumentAdapter() {
        return new DocumentAdapter(this.buildVarietyTypeHolder());
    }

    private PropertyValueModel buildVarietyTypeHolder() {
        return new TransformationPropertyValueModel(this.getQueryHolder()){

            @Override
            protected Object transform(Object value) {
                MWQuery query = (MWQuery)value;
                if (query == null || QueriesPropertiesPage.this.getQueryManager() == null) {
                    return QueriesPropertiesPage.this.resourceRepository().getString("QUERY_VARIETY_NONE_SELECTED");
                }
                return QueriesPropertiesPage.this.resourceRepository().getString("QUERY_VARIETY_TOPLINK_NAMED_QUERY");
            }
        };
    }
}

