/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.xml;

import javax.swing.ButtonModel;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.mappingsmodel.xml.MWXmlField;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.xml.AbstractXmlFieldPanel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.xml.XmlMappingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.xml.SchemaComplexTypeChooser;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.xml.XpathChooser;
import org.eclipse.persistence.tools.workbench.uitools.ComponentEnabler;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.RadioButtonModelAdapter;

public abstract class AbstractAggregatableXmlFieldPanel
extends AbstractXmlFieldPanel {
    private ValueModel mappingHolder;
    private String mappingPropertyString;

    protected AbstractAggregatableXmlFieldPanel(ValueModel mappingHolder, ValueModel xmlFieldHolder, WorkbenchContextHolder contextHolder, String mappingPropertyString) {
        super(xmlFieldHolder, contextHolder);
        this.mappingHolder = mappingHolder;
        this.mappingPropertyString = mappingPropertyString;
        this.initializeLayoutWithAggregatable();
    }

    @Override
    protected void initializeLayout() {
        super.initializeLayout();
    }

    protected abstract void initializeLayoutWithAggregatable();

    protected JLabel buildElementTypeLabel() {
        return XmlMappingComponentFactory.buildElementTypeLabel(this.resourceRepository());
    }

    protected SchemaComplexTypeChooser buildElementTypeChooser(JLabel label) {
        return XmlMappingComponentFactory.buildElementTypeChooser(this.mappingHolder, this.getWorkbenchContextHolder(), label, this.mappingPropertyString);
    }

    protected JRadioButton buildAggregateRadioButton() {
        JRadioButton button = this.buildRadioButton("XML_FIELD_AGGREGATE_RADIO_BUTTON", this.buildAggregateButtonModel());
        this.addHelpTopicId(button, "mapping.xmlField.aggregate");
        return button;
    }

    protected ButtonModel buildAggregateButtonModel() {
        return new RadioButtonModelAdapter(this.buildAggregatedValue(), Boolean.TRUE);
    }

    protected PropertyValueModel buildAggregatedValue() {
        return new PropertyAspectAdapter(this.getSubjectHolder(), "aggregated"){

            @Override
            protected Object getValueFromSubject() {
                return ((MWXmlField)this.subject).isAggregated();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                ((MWXmlField)this.subject).setAggregated(((Boolean)value).booleanValue());
            }
        };
    }

    protected JRadioButton buildXpathRadioButton() {
        JRadioButton button = this.buildRadioButton("XML_FIELD_XPATH_RADIO_BUTTON", this.buildXpathButtonModel());
        this.addHelpTopicId(button, "mapping.xmlField.xpath");
        return button;
    }

    private ButtonModel buildXpathButtonModel() {
        return new RadioButtonModelAdapter(this.buildAggregatedValue(), Boolean.FALSE);
    }

    @Override
    protected XpathChooser buildXpathChooser() {
        XpathChooser chooser = super.buildXpathChooser();
        this.createXpathChooserEnabler(chooser);
        return chooser;
    }

    private void createXpathChooserEnabler(XpathChooser chooser) {
        new ComponentEnabler(this.buildSpecifyXpathHolder(), chooser);
    }

    private ValueModel buildSpecifyXpathHolder() {
        return new PropertyAspectAdapter(this.getSubjectHolder(), "aggregated"){

            @Override
            protected Object getValueFromSubject() {
                return !((MWXmlField)this.subject).isAggregated();
            }
        };
    }
}

