/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.xml;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.ListCellRenderer;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractSubjectPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.AddRemoveListPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.AddRemovePanel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.xml.MWXmlDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.xml.MWXmlPrimaryKeyPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.xml.MWXmlField;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.xml.XpathChooserDialog;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ObjectListSelectionModel;
import org.eclipse.persistence.tools.workbench.uitools.cell.SimpleListCellRenderer;

final class EisPrimaryKeysPanel
extends AbstractSubjectPanel {
    EisPrimaryKeysPanel(ValueModel eisDescriptorHolder, WorkbenchContextHolder ctxHolder) {
        super((LayoutManager)new GridBagLayout(), eisDescriptorHolder, ctxHolder);
    }

    @Override
    protected void initializeLayout() {
        this.setBorder(BorderFactory.createCompoundBorder(this.buildTitledBorder("PRIMARY_KEYS_PANEL.TITLE"), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        GridBagConstraints constraints = new GridBagConstraints();
        AddRemoveListPanel addRemoveListPanel = this.buildPrimaryKeysList();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)addRemoveListPanel, constraints);
        this.addPaneForAlignment(addRemoveListPanel);
        this.addHelpTopicId(this, this.helpTopicId());
    }

    private AddRemoveListPanel buildPrimaryKeysList() {
        AddRemoveListPanel listPanel = new AddRemoveListPanel(this.getApplicationContext(), this.buildPrimaryKeysAddRemoveAdapter(), this.buildPrimaryKeysHolder(), 3);
        listPanel.setBorder(this.buildStandardEmptyBorder());
        listPanel.setCellRenderer(this.buildPrimaryKeysListCellRenderer());
        return listPanel;
    }

    private AddRemovePanel.Adapter buildPrimaryKeysAddRemoveAdapter() {
        return new AddRemovePanel.Adapter(){

            @Override
            public void addNewItem(ObjectListSelectionModel listSelectionModel) {
                listSelectionModel.setSelectedValues(EisPrimaryKeysPanel.this.addPrimaryKeys());
            }

            @Override
            public void removeSelectedItems(ObjectListSelectionModel listSelectionModel) {
                EisPrimaryKeysPanel.this.removePrimaryKeys(listSelectionModel.getSelectedValues());
            }
        };
    }

    private Object[] addPrimaryKeys() {
        MWXmlPrimaryKeyPolicy primaryKeyPolicy = this.xmlDescriptor().primaryKeyPolicy();
        MWXmlField primaryKey = primaryKeyPolicy.buildEmptyPrimaryKey();
        XpathChooserDialog.promptToSelectXpath(primaryKey, this.getWorkbenchContext());
        if (primaryKey.isSpecified()) {
            primaryKeyPolicy.addPrimaryKey(primaryKey);
            return new Object[]{primaryKey};
        }
        return new Object[0];
    }

    private void removePrimaryKeys(Object[] primaryKeys) {
        for (int i = 0; i < primaryKeys.length; ++i) {
            this.xmlDescriptor().primaryKeyPolicy().removePrimaryKey((MWXmlField)primaryKeys[i]);
        }
    }

    private ListValueModel buildPrimaryKeysHolder() {
        return new CollectionListValueModelAdapter(new CollectionAspectAdapter(this.buildPrimaryKeyPolicyHolder(), "primaryKeys"){

            @Override
            protected Iterator getValueFromSubject() {
                return ((MWXmlPrimaryKeyPolicy)this.subject).primaryKeys();
            }

            @Override
            protected int sizeFromSubject() {
                return ((MWXmlPrimaryKeyPolicy)this.subject).primaryKeysSize();
            }
        });
    }

    private ValueModel buildPrimaryKeyPolicyHolder() {
        return new PropertyAspectAdapter(this.getSubjectHolder()){

            @Override
            protected Object getValueFromSubject() {
                return ((MWXmlDescriptor)this.subject).primaryKeyPolicy();
            }
        };
    }

    private ListCellRenderer buildPrimaryKeysListCellRenderer() {
        return new SimpleListCellRenderer(){

            @Override
            protected String buildText(Object value) {
                return ((MWXmlField)value).getXpath();
            }
        };
    }

    private MWXmlDescriptor xmlDescriptor() {
        return (MWXmlDescriptor)this.getSubjectHolder().getValue();
    }

    public String helpTopicId() {
        return "descriptor.eis.primaryKeys";
    }
}

