/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import org.eclipse.persistence.tools.workbench.framework.action.FrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.app.GroupContainerDescription;
import org.eclipse.persistence.tools.workbench.framework.app.MenuDescription;
import org.eclipse.persistence.tools.workbench.framework.app.MenuGroupDescription;
import org.eclipse.persistence.tools.workbench.framework.app.NavigatorSelectionModel;
import org.eclipse.persistence.tools.workbench.framework.app.ToolBarDescription;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWMappingDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassAttribute;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWMethod;
import org.eclipse.persistence.tools.workbench.mappingsplugin.AutomapAction;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.DescriptorNode;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.DescriptorPackageNode;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.MapInheritedAttributesToRootMinusOneAction;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.MapInheritedAttributesToSelectedClassAction;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.MapInheritedAttributesToSuperclassAction;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.MappingDescriptorTabbedPropertiesPage;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.RemoveInheritedAttributesAction;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.UnmapAllDescriptorsInPackageAction;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.UnmapDescriptorAction;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.MappingNode;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.CompositeCollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ItemPropertyListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimpleCollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SortedListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.utility.Transformer;
import org.eclipse.persistence.tools.workbench.utility.events.CollectionChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.events.CollectionChangeListener;
import org.eclipse.persistence.tools.workbench.utility.iterators.FilteringIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.TransformationIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public abstract class MappingDescriptorNode
extends DescriptorNode {
    private ListValueModel childrenModel;
    private SimpleCollectionValueModel mappingNodesHolder;
    private SimpleCollectionValueModel unmappedMappingNodesHolder;
    private CollectionChangeListener mappingsListener;
    private CollectionChangeListener attributesListener;
    private PropertyChangeListener attributeModifierListener;
    private PropertyChangeListener unknownPrimaryKeyListener;

    protected MappingDescriptorNode(MWDescriptor descriptor, DescriptorPackageNode parentNode) {
        super(descriptor, parentNode);
    }

    protected void initialize() {
        super.initialize();
        this.mappingsListener = this.buildMappingsListener();
        this.attributesListener = this.buildAttributesListener();
        this.attributeModifierListener = this.buildAttributeModifierListener();
        this.unknownPrimaryKeyListener = this.buildUnknownPrimaryKeyListener();
        this.mappingNodesHolder = new SimpleCollectionValueModel();
        this.unmappedMappingNodesHolder = new SimpleCollectionValueModel();
        this.childrenModel = this.buildChildrenModel();
    }

    private CollectionChangeListener buildMappingsListener() {
        return new CollectionChangeListener(){

            public void itemsAdded(CollectionChangeEvent e) {
                MappingDescriptorNode.this.mappingsAdded(e);
            }

            public void itemsRemoved(CollectionChangeEvent e) {
                MappingDescriptorNode.this.mappingsRemoved(e);
            }

            public void collectionChanged(CollectionChangeEvent e) {
                MappingDescriptorNode.this.mappingsChanged(e);
            }

            public String toString() {
                return "mappings listener";
            }
        };
    }

    private CollectionChangeListener buildAttributesListener() {
        return new CollectionChangeListener(){

            public void itemsAdded(CollectionChangeEvent e) {
                MappingDescriptorNode.this.attributesAdded(e);
            }

            public void itemsRemoved(CollectionChangeEvent e) {
                MappingDescriptorNode.this.attributesRemoved(e);
            }

            public void collectionChanged(CollectionChangeEvent e) {
                throw new UnsupportedOperationException();
            }

            public String toString() {
                return "attributes listener";
            }
        };
    }

    private PropertyChangeListener buildAttributeModifierListener() {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                MappingDescriptorNode.this.attributeModifierChanged(e);
            }

            public String toString() {
                return "attribute modifier listener";
            }
        };
    }

    private PropertyChangeListener buildUnknownPrimaryKeyListener() {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                MappingDescriptorNode.this.unknownPrimaryKeyChanged(e);
            }

            public String toString() {
                return "unknown primary key listener";
            }
        };
    }

    protected ListValueModel buildChildrenModel() {
        return new SortedListValueModelAdapter(this.buildDisplayStringAdapter());
    }

    protected ListValueModel buildDisplayStringAdapter() {
        return new ItemPropertyListValueModelAdapter(this.buildUnsortedChildrenModel(), "displayString");
    }

    private CollectionValueModel buildUnsortedChildrenModel() {
        SimpleCollectionValueModel container = new SimpleCollectionValueModel();
        container.addItem(this.mappingNodesHolder);
        container.addItem(this.unmappedMappingNodesHolder);
        return new CompositeCollectionValueModel(container, Transformer.NULL_INSTANCE);
    }

    public MWMappingDescriptor getMappingDescriptor() {
        return (MWMappingDescriptor)this.getDescriptor();
    }

    private Iterator mappingNodes() {
        return (Iterator)this.mappingNodesHolder.getValue();
    }

    private MappingNode mappingNodeFor(MWMapping mapping) {
        Iterator stream = this.mappingNodes();
        while (stream.hasNext()) {
            MappingNode node = (MappingNode)stream.next();
            if (node.getValue() != mapping) continue;
            return node;
        }
        return null;
    }

    private MappingNode mappingNodeFor(MWClassAttribute attribute) {
        Iterator stream = this.mappingNodes();
        while (stream.hasNext()) {
            MappingNode node = (MappingNode)stream.next();
            if (node.instanceVariable() != attribute) continue;
            return node;
        }
        return null;
    }

    private Iterator unmappedMappingNodes() {
        return (Iterator)this.unmappedMappingNodesHolder.getValue();
    }

    private MappingNode unmappedMappingNodeFor(MWClassAttribute attribute) {
        Iterator stream = this.unmappedMappingNodes();
        while (stream.hasNext()) {
            MappingNode node = (MappingNode)stream.next();
            if (node.instanceVariable() != attribute) continue;
            return node;
        }
        return null;
    }

    private Iterator unmappedAttributes(Iterator attributes) {
        return new FilteringIterator(attributes){

            protected boolean accept(Object o) {
                MWMappingDescriptor descriptor = MappingDescriptorNode.this.getMappingDescriptor();
                return descriptor.mappingForAttribute((MWClassAttribute)o) == null;
            }
        };
    }

    public abstract String mappingHelpTopicPrefix();

    void mappingsAdded(CollectionChangeEvent e) {
        this.removeUnmappedMappingNodesFor(this.attributes(e.items()));
        this.addMappingNodesFor(e.items());
    }

    private void removeUnmappedMappingNodesFor(Iterator attributes) {
        while (attributes.hasNext()) {
            this.removeUnmappedMappingNodeFor((MWClassAttribute)attributes.next());
        }
    }

    private void removeUnmappedMappingNodeFor(MWClassAttribute attribute) {
        this.unmappedMappingNodesHolder.removeItem(this.unmappedMappingNodeFor(attribute));
    }

    private void addMappingNodesFor(Iterator mappings) {
        while (mappings.hasNext()) {
            this.addMappingNodeFor((MWMapping)mappings.next());
        }
    }

    private void addMappingNodeFor(MWMapping mapping) {
        this.mappingNodesHolder.addItem(this.buildMappingNode(mapping));
    }

    void mappingsRemoved(CollectionChangeEvent e) {
        this.removeMappingNodesFor(e.items());
        Iterator stream = this.attributes(e.items());
        while (stream.hasNext()) {
            MWClassAttribute attribute = (MWClassAttribute)stream.next();
            String attributeName = attribute.getName();
            if (!this.type().containsCombinedAttributeNamed(attributeName) && !this.getMappingDescriptor().containsInheritedAttributeNamed(attributeName)) continue;
            this.addUnmappedMappingNodeFor(attribute);
        }
    }

    private void removeMappingNodesFor(Iterator mappings) {
        while (mappings.hasNext()) {
            this.removeMappingNodeFor((MWMapping)mappings.next());
        }
    }

    private void removeMappingNodeFor(MWMapping mapping) {
        this.mappingNodesHolder.removeItem(this.mappingNodeFor(mapping));
    }

    private void addUnmappedMappingNodeFor(MWClassAttribute attribute) {
        this.unmappedMappingNodesHolder.addItem(this.buildUnmappedMappingNode(attribute));
    }

    private Iterator attributes(Iterator mappings) {
        return new TransformationIterator(mappings){

            protected Object transform(Object next) {
                return ((MWMapping)next).getInstanceVariable();
            }
        };
    }

    void mappingsChanged(CollectionChangeEvent e) {
        this.rebuildAllMappingNodes();
    }

    void attributesAdded(CollectionChangeEvent e) {
        this.engageAttributes(e.items());
        this.addUnmappedMappingNodesFor(e.items());
    }

    private void addUnmappedMappingNodesFor(Iterator attributes) {
        while (attributes.hasNext()) {
            this.addUnmappedMappingNodeFor((MWClassAttribute)attributes.next());
        }
    }

    void attributesRemoved(CollectionChangeEvent e) {
        this.removeUnmappedMappingNodesFor(e.items());
        this.disengageAttributes(e.items());
    }

    private void rebuildAllMappingNodes() {
        this.clearAllMappingNodes();
        this.addAllMappingNodes();
    }

    private void clearAllMappingNodes() {
        this.mappingNodesHolder.clear();
        this.unmappedMappingNodesHolder.clear();
    }

    private void addAllMappingNodes() {
        MWMappingDescriptor descriptor = this.getMappingDescriptor();
        MWClass type = descriptor.getMWClass();
        this.addMappingNodesFor(descriptor.mappings());
        this.addUnmappedMappingNodesFor(this.unmappedAttributes(type.attributes()));
        this.addUnmappedMappingNodesFor(this.unmappedAttributes(type.ejb20Attributes()));
        this.addUnmappedMappingNodesFor(this.unmappedAttributes(descriptor.inheritedAttributes()));
    }

    void attributeModifierChanged(PropertyChangeEvent e) {
        MWClassAttribute attribute = (MWClassAttribute)e.getSource();
        if (this.mappingNodeFor(attribute) != null) {
            return;
        }
        int oldCode = (Integer)e.getOldValue();
        int newCode = (Integer)e.getNewValue();
        this.checkModifier(attribute, Modifier.isStatic(oldCode), Modifier.isStatic(newCode));
        this.checkModifier(attribute, Modifier.isFinal(oldCode), Modifier.isFinal(newCode));
    }

    private void checkModifier(MWClassAttribute attribute, boolean oldModifierIsNotMappable, boolean newModifierIsNotMappable) {
        if (oldModifierIsNotMappable) {
            if (!newModifierIsNotMappable && this.unmappedMappingNodeFor(attribute) == null) {
                this.addUnmappedMappingNodeFor(attribute);
            }
        } else if (newModifierIsNotMappable) {
            this.removeUnmappedMappingNodeFor(attribute);
        }
    }

    void unknownPrimaryKeyChanged(PropertyChangeEvent e) {
        if (e.getNewValue() == null) {
            this.removeUnmappedMappingNodeFor((MWClassAttribute)e.getOldValue());
        }
    }

    public void selectMethod(MWMethod method, WorkbenchContext context) {
        ((MappingDescriptorTabbedPropertiesPage)context.getPropertiesPage()).selectMethod(method);
    }

    public void selectMappingNodeFor(MWClassAttribute attribute, NavigatorSelectionModel nsm) {
        MWMapping mapping = this.getMappingDescriptor().mappingForAttribute(attribute);
        this.selectMappingNodeFor(mapping, nsm);
    }

    public void selectMappingNodeFor(MWMapping mapping, NavigatorSelectionModel nsm) {
        this.selectDescendantNodeForValue((Node)mapping, nsm);
    }

    protected abstract MappingNode buildMappingNode(MWMapping var1);

    protected abstract MappingNode buildUnmappedMappingNode(MWClassAttribute var1);

    @Override
    public ListValueModel getChildrenModel() {
        return this.childrenModel;
    }

    @Override
    protected void engageValue() {
        super.engageValue();
        MWMappingDescriptor descriptor = this.getMappingDescriptor();
        MWClass type = descriptor.getMWClass();
        descriptor.addCollectionChangeListener("mappings", this.mappingsListener);
        descriptor.addCollectionChangeListener("inheritedAttributes", this.attributesListener);
        type.addCollectionChangeListener("attributes", this.attributesListener);
        type.addCollectionChangeListener("ejb20Attributes", this.attributesListener);
        type.addPropertyChangeListener("unknownPKAttribute", this.unknownPrimaryKeyListener);
        this.engageAttributes(type.combinedAttributes());
        this.engageAttributes(descriptor.inheritedAttributes());
        this.addAllMappingNodes();
    }

    protected void engageAttributes(Iterator attributes) {
        while (attributes.hasNext()) {
            this.engageAttribute((MWClassAttribute)attributes.next());
        }
    }

    protected void engageAttribute(MWClassAttribute attribute) {
        attribute.addPropertyChangeListener("modifierCode", this.attributeModifierListener);
    }

    @Override
    protected void disengageValue() {
        MWMappingDescriptor descriptor = this.getMappingDescriptor();
        MWClass type = descriptor.getMWClass();
        this.clearAllMappingNodes();
        this.disengageAttributes(descriptor.inheritedAttributes());
        this.disengageAttributes(type.combinedAttributes());
        type.removePropertyChangeListener("unknownPKAttribute", this.unknownPrimaryKeyListener);
        type.removeCollectionChangeListener("ejb20Attributes", this.attributesListener);
        type.removeCollectionChangeListener("attributes", this.attributesListener);
        descriptor.removeCollectionChangeListener("inheritedAttributes", this.attributesListener);
        descriptor.removeCollectionChangeListener("mappings", this.mappingsListener);
        super.disengageValue();
    }

    protected void disengageAttributes(Iterator attributes) {
        while (attributes.hasNext()) {
            this.disengageAttribute((MWClassAttribute)attributes.next());
        }
    }

    protected void disengageAttribute(MWClassAttribute attribute) {
        attribute.removePropertyChangeListener("modifierCode", this.attributeModifierListener);
    }

    @Override
    protected boolean supportsAdvancedProperties() {
        return true;
    }

    @Override
    public GroupContainerDescription buildToolBarDescription(WorkbenchContext workbenchContext) {
        return new ToolBarDescription();
    }

    protected MenuDescription buildMapInheritedAttributesMenuDescription(WorkbenchContext workbenchContext) {
        MenuDescription menuDesc = new MenuDescription(this.resourceRepository().getString("MAP_INHERITED_ATTRIBUTES_MENU_ITEM"), this.resourceRepository().getString("MAP_INHERITED_ATTRIBUTES_MENU_ITEM"), this.resourceRepository().getMnemonic("MAP_INHERITED_ATTRIBUTES_MENU_ITEM"), EMPTY_ICON);
        MenuGroupDescription mapGroupDesc = new MenuGroupDescription();
        mapGroupDesc.add(this.getMapInheritedAttributesToSuperClassAction(workbenchContext));
        mapGroupDesc.add(this.getMapInheritedAttributesToRootMinusOneAction(workbenchContext));
        mapGroupDesc.add(this.getMapInheritedAttributesToSelectedClassAction(workbenchContext));
        menuDesc.add(mapGroupDesc);
        MenuGroupDescription removeGroupDesc = new MenuGroupDescription();
        removeGroupDesc.add(this.getRemoveInheritedAttributesAction(workbenchContext));
        menuDesc.add(removeGroupDesc);
        return menuDesc;
    }

    protected MenuDescription buildUnmapMenuDescription(WorkbenchContext context) {
        MenuDescription menuDesc = new MenuDescription(this.resourceRepository().getString("UNMAP_MENU"), this.resourceRepository().getString("UNMAP_MENU"), this.resourceRepository().getMnemonic("UNMAP_MENU"), EMPTY_ICON);
        MenuGroupDescription groupDesc = new MenuGroupDescription();
        groupDesc.add(this.getUnmapDescriptorAction(context));
        groupDesc.add(this.getUnmapAllDescriptorsInPackageAction(context));
        menuDesc.add(groupDesc);
        return menuDesc;
    }

    protected AutomapAction getAutomapAction(WorkbenchContext workbenchContext) {
        return this.getMappingsPlugin().getAutomapAction(workbenchContext);
    }

    private FrameworkAction getMapInheritedAttributesToSuperClassAction(WorkbenchContext context) {
        return new MapInheritedAttributesToSuperclassAction(context);
    }

    private FrameworkAction getMapInheritedAttributesToRootMinusOneAction(WorkbenchContext context) {
        return new MapInheritedAttributesToRootMinusOneAction(context);
    }

    private FrameworkAction getMapInheritedAttributesToSelectedClassAction(WorkbenchContext context) {
        return new MapInheritedAttributesToSelectedClassAction(context);
    }

    protected FrameworkAction getRemoveInheritedAttributesAction(WorkbenchContext context) {
        return new RemoveInheritedAttributesAction(context);
    }

    private FrameworkAction getUnmapAllDescriptorsInPackageAction(WorkbenchContext context) {
        return new UnmapAllDescriptorsInPackageAction(context);
    }

    private FrameworkAction getUnmapDescriptorAction(WorkbenchContext context) {
        return new UnmapDescriptorAction(context);
    }
}

