/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappings;

import java.io.File;
import java.util.ListIterator;
import org.eclipse.persistence.tools.workbench.framework.resources.DefaultStringRepository;
import org.eclipse.persistence.tools.workbench.framework.resources.StringRepository;
import org.eclipse.persistence.tools.workbench.mappings.Generator;
import org.eclipse.persistence.tools.workbench.mappings.MappingsBundle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.MWProject;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ProblemsBundle;
import org.eclipse.persistence.tools.workbench.utility.node.Problem;

public class ProblemReportGenerator
implements Generator.Adapter {
    private StringRepository mappingsStringRepository = new DefaultStringRepository(MappingsBundle.class);
    private StringRepository problemsStringRepository = new DefaultStringRepository(ProblemsBundle.class);

    public static void main(String[] args) {
        new Generator(new ProblemReportGenerator()).execute(args);
        System.out.println();
    }

    @Override
    public void export(MWProject project, File outputFile) {
        System.out.println(this.mappingsStringRepository.getString("projectsProblems", project.displayString(), String.valueOf(project.branchProblemsSize())));
        ListIterator i = project.branchProblems();
        while (i.hasNext()) {
            Problem problem = (Problem)i.next();
            String source = problem.getSource().displayString();
            String key = problem.getMessageKey();
            String problemMsg = this.problemsStringRepository.getString(key, problem.getMessageArguments());
            System.err.println(source + " - " + key + ":" + problemMsg);
        }
    }
}

