/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.ui.dialog;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import org.eclipse.persistence.tools.workbench.uitools.LabelArea;

public final class WaitDialog
extends JDialog {
    private LabelArea message;

    public WaitDialog(Frame owner, Icon icon, String title, String message) {
        super(owner, true);
        this.initialize(owner, icon, title, message);
    }

    public WaitDialog(Dialog owner, Icon icon, String title, String message) {
        super(owner, true);
        this.initialize(owner, icon, title, message);
    }

    private void initialize(Window owner, Icon icon, String title, String specificMessage) {
        this.setTitle(title);
        this.setDefaultCloseOperation(0);
        this.setResizable(false);
        Container contentPane = this.getContentPane();
        GridBagConstraints constraints = new GridBagConstraints();
        contentPane.setLayout(new GridBagLayout());
        JLabel iconLabel = new JLabel();
        iconLabel.setIcon(icon);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 1.0;
        constraints.fill = 0;
        constraints.anchor = 19;
        constraints.insets = new Insets(15, 20, 10, 0);
        contentPane.add((Component)iconLabel, constraints);
        this.message = new LabelArea(specificMessage);
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 2;
        constraints.anchor = 19;
        constraints.insets = new Insets(20, 15, 15, 15);
        contentPane.add((Component)this.message, constraints);
        this.pack();
        this.setSize(Math.max(400, this.getWidth()), this.getHeight());
        Point ownerLocation = owner.getLocationOnScreen();
        int x = ownerLocation.x + (owner.getWidth() - this.getWidth()) / 2;
        x = Math.max(0, x);
        int y = ownerLocation.y + (owner.getHeight() - this.getHeight()) / 2;
        y = Math.max(0, y);
        this.setLocation(x, y);
    }

    public void setMessage(String text) {
        this.message.setText(text);
    }
}

