/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.internal;

import java.awt.Cursor;
import java.awt.EventQueue;
import org.eclipse.persistence.tools.workbench.framework.action.AbstractFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.internal.FrameworkApplication;
import org.eclipse.persistence.tools.workbench.framework.internal.PreferencesDialog;

final class PreferencesAction
extends AbstractFrameworkAction {
    private FrameworkApplication application;

    PreferencesAction(WorkbenchContext context, FrameworkApplication application) {
        super(context);
        this.application = application;
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.initializeTextAndMnemonic("PREFERENCES");
        this.initializeToolTipText("PREFERENCES.TOOL_TIP");
        this.initializeIcon("PREFERENCES");
    }

    @Override
    protected void execute() {
        EventQueue.invokeLater(new LaunchPreferencesDialog(this.getWorkbenchContext(), this.application));
    }

    private final class LaunchPreferencesDialog
    implements Runnable {
        private final WorkbenchContext context;
        private final FrameworkApplication application;

        LaunchPreferencesDialog(WorkbenchContext context, FrameworkApplication application) {
            this.context = context;
            this.application = application;
        }

        @Override
        public void run() {
            PreferencesAction.this.getWorkbenchContext().getCurrentWindow().setCursor(Cursor.getPredefinedCursor(3));
            PreferencesDialog dialog = new PreferencesDialog(this.context, this.application.getPreferencesView());
            dialog.show();
            PreferencesAction.this.getWorkbenchContext().getCurrentWindow().setCursor(Cursor.getDefaultCursor());
        }
    }
}

