/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.internal;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.eclipse.persistence.tools.workbench.framework.context.ApplicationContext;
import org.eclipse.persistence.tools.workbench.framework.help.HelpManager;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.uitools.Console;

public class FrameworkConsole
extends Console {
    private ApplicationContext appContext;

    public FrameworkConsole(ApplicationContext context) {
        this.initialize(context);
    }

    @Override
    protected void initialize() {
        if (this.appContext != null) {
            super.initialize();
        }
    }

    private void initialize(ApplicationContext context) {
        this.appContext = context;
        this.initialize();
    }

    @Override
    protected JPanel buildMainPanel() {
        JPanel mainPanel = super.buildMainPanel();
        mainPanel.add(this.buildErrorLabel(), "First");
        return mainPanel;
    }

    private Component buildErrorLabel() {
        JLabel errorLabel = new JLabel(this.resourceRepository().getString("UNEXPECTED_OUTPUT_ERROR_MESSAGE"));
        errorLabel.setIcon(this.resourceRepository().getIcon("error.large"));
        return errorLabel;
    }

    @Override
    protected Component buildControlPanel() {
        JPanel controlPanel = new JPanel(new BorderLayout());
        JPanel controlPanel2 = new JPanel(new BorderLayout());
        controlPanel2.add(this.buildHelpButton(), "Before");
        controlPanel2.add(this.buildOKButton(), "After");
        controlPanel2.setBorder(BorderFactory.createEmptyBorder(4, 0, 2, 0));
        controlPanel.add((Component)controlPanel2, "Center");
        return controlPanel;
    }

    private Component buildHelpButton() {
        return new JButton(this.buildHelpAction());
    }

    private Action buildHelpAction() {
        AbstractAction action = new AbstractAction(this.resourceRepository().getString("DIALOG.HELP_BUTTON_TEXT")){

            @Override
            public void actionPerformed(ActionEvent event) {
                FrameworkConsole.this.helpManager().showTopic(FrameworkConsole.this.helpTopicId());
            }
        };
        action.setEnabled(true);
        return action;
    }

    private Component buildOKButton() {
        return new JButton(this.buildOKAction());
    }

    private Action buildOKAction() {
        AbstractAction action = new AbstractAction(this.resourceRepository().getString("DIALOG.OK_BUTTON_TEXT")){

            @Override
            public void actionPerformed(ActionEvent event) {
                FrameworkConsole.this.clear();
                FrameworkConsole.this.hide();
            }
        };
        action.setEnabled(true);
        return action;
    }

    private ResourceRepository resourceRepository() {
        return this.appContext.getResourceRepository();
    }

    HelpManager helpManager() {
        return this.appContext.getHelpManager();
    }

    String helpTopicId() {
        return "dialog.unexpected.output";
    }

    @Override
    protected String title() {
        return this.resourceRepository().getString("UNEXPECTED_OUTPUT_LOG_TITLE");
    }
}

