/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.help;

import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.prefs.Preferences;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import org.eclipse.persistence.tools.workbench.framework.help.InternalHelpManager;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;

class DefaultHelpManager
implements InternalHelpManager {
    private ExternalBrowserHandler browser;
    private HashMap<String, String> topicIdtoUrlMap;
    private LocalMouseListener mouseListener;
    private KeyListener keyListener;
    private Map topicIDs;
    private ResourceRepository resourceRepository;
    private boolean localHelpFailed;
    static final String BROWSER_PREFERENCE = "external web browser";
    static final String BROWSER_PREFERENCE_DEFAULT = "";

    private DefaultHelpManager() {
        this.initialize();
    }

    DefaultHelpManager(ResourceRepository resourceRepository, Preferences preferences) {
        this();
        this.resourceRepository = resourceRepository;
        this.localHelpFailed = false;
        this.initialize(preferences);
    }

    protected void initialize() {
        this.keyListener = this.buildKeyListener();
        this.topicIDs = new WeakHashMap();
    }

    private void initialize(Preferences preferences) {
        Icon icon = this.resourceRepository.getIcon("oracle.logo.large");
        this.mouseListener = this.buildMouseListener(this.resourceRepository.getString("CSH_HELP"));
        this.browser = new ExternalBrowserHandler(preferences);
        this.topicIdtoUrlMap = this.initializeTopicMap();
    }

    private KeyListener buildKeyListener() {
        return new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (!e.isConsumed() && e.getKeyCode() == 112) {
                    DefaultHelpManager.this.showTopic((Component)e.getSource());
                    e.consume();
                }
            }
        };
    }

    private LocalMouseListener buildMouseListener(String menuItemLabel) {
        return new LocalMouseListener(menuItemLabel);
    }

    @Override
    public void setLocalHelpFailed(boolean localHelpFailed) {
        this.localHelpFailed = localHelpFailed;
    }

    @Override
    public void launchComplete() {
        if (this.localHelpFailed) {
            this.showTopic("noHelp");
        }
    }

    @Override
    public void showHelp() {
        this.showTopic("default");
    }

    @Override
    public void showTopic(String topicID) {
        this.showTopicInternal(topicID);
    }

    public void showUrl(String url) {
        this.browser.handleValue(url);
    }

    @Override
    public void showTopic(Component component) {
        String topicID = this.getTopicID(component);
        if (topicID != null) {
            this.showTopicInternal(topicID, component);
        }
    }

    @Override
    public void addTopicIDs(Map componentsToTopicIDs) {
        for (Map.Entry entry : componentsToTopicIDs.entrySet()) {
            this.addTopicID((Component)entry.getKey(), (String)entry.getValue());
        }
    }

    @Override
    public void addTopicID(Component component, String topicID) {
        this.listenTo(component);
        this.topicIDs.put(component, topicID);
    }

    @Override
    public void removeTopicIDs(Map componentsToTopicIDs) {
        this.removeTopicIDs(componentsToTopicIDs.keySet());
    }

    @Override
    public void removeTopicIDs(Collection components) {
        Iterator stream = components.iterator();
        while (stream.hasNext()) {
            this.removeTopicID((Component)stream.next());
        }
    }

    @Override
    public void removeTopicID(Component component) {
        this.topicIDs.remove(component);
        this.stopListeningTo(component);
    }

    @Override
    public void addItemsToPopupMenuForComponent(JMenuItem[] menuItems, Component component) {
        this.mouseListener.addItemsToPopupMenuForComponent(menuItems, component);
    }

    @Override
    public void shutDown() {
    }

    private String getTopicID(Component component) {
        if (component == null) {
            return null;
        }
        String topicID = (String)this.topicIDs.get(component);
        if (topicID == null) {
            return this.getTopicID(component.getParent());
        }
        return topicID;
    }

    protected void showTopicInternal(String topicID) {
        String url = this.topicIdtoUrlMap.get(topicID);
        if (url == null) {
            url = this.topicIdtoUrlMap.get("default");
        }
        this.browser.handleValue(url);
    }

    protected void showTopicInternal(String topicID, Component component) {
        String url = this.topicIdtoUrlMap.get(topicID);
        if (url == null) {
            url = this.topicIdtoUrlMap.get("default");
        }
        this.browser.handleValue(url, component);
    }

    private void listenTo(Component component) {
        if (CollectionTools.contains((Object[])component.getMouseListeners(), (Object)this.mouseListener)) {
            return;
        }
        component.addMouseListener(this.mouseListener);
        component.addKeyListener(this.keyListener);
        if (component instanceof Container) {
            this.listenTo(((Container)component).getComponents());
        }
    }

    private void listenTo(Component[] components) {
        int i = components.length;
        while (i-- > 0) {
            this.listenTo(components[i]);
        }
    }

    private void stopListeningTo(Component component) {
        if (!CollectionTools.contains((Object[])component.getMouseListeners(), (Object)this.mouseListener)) {
            return;
        }
        component.removeMouseListener(this.mouseListener);
        component.removeKeyListener(this.keyListener);
        if (component instanceof Container) {
            this.stopListeningTo(((Container)component).getComponents());
        }
    }

    private void stopListeningTo(Component[] components) {
        int i = components.length;
        while (i-- > 0) {
            this.stopListeningTo(components[i]);
        }
    }

    private void showNavigatorWindow(Class navigatorClass) {
    }

    private HashMap<String, String> initializeTopicMap() {
        HashMap<String, String> topicMap = new HashMap<String, String>(1);
        topicMap.put("default", "http://www.eclipse.org/eclipselink/documentation/");
        topicMap.put("eclipselink_home", "http://www.eclipse.org/eclipselink/");
        topicMap.put("eclipslink_userguide", "http://www.eclipse.org/eclipselink/documentation/");
        topicMap.put("eclipselink_api", "http://www.eclipse.org/eclipselink/api/2.6/index.html");
        topicMap.put("eclipselink_examples", "http://wiki.eclipse.org/EclipseLink/Examples");
        return topicMap;
    }

    private class ExternalBrowserHandler {
        private Preferences preferences;
        public static final String PROTOCOL_NAME = "external";

        public ExternalBrowserHandler(Preferences preferences) {
            this.preferences = preferences;
        }

        public void handleValue(String value, Component component) {
            String browser = this.preferences.get(DefaultHelpManager.BROWSER_PREFERENCE, DefaultHelpManager.BROWSER_PREFERENCE_DEFAULT);
            try {
                if (browser.isEmpty()) {
                    Desktop.getDesktop().browse(new URI(value));
                } else {
                    Runtime.getRuntime().exec(browser + " " + value);
                }
            }
            catch (IOException | URISyntaxException ex) {
                if (component == null) {
                    throw new RuntimeException(DefaultHelpManager.this.resourceRepository.getString("CONFIGURE_EXTERNAL_BROWSER"));
                }
                this.showBrowserConfigMessages(component);
            }
        }

        public void handleValue(String value) {
            this.handleValue(value, null);
        }

        private void showBrowserConfigMessages(Component component) {
            JOptionPane.showMessageDialog(component, DefaultHelpManager.this.resourceRepository.getString("CONFIGURE_EXTERNAL_BROWSER"), DefaultHelpManager.this.resourceRepository.getString("CONFIGURE_EXTERNAL_BROWSER_TITLE"), 2);
        }
    }

    private class LocalMouseListener
    extends MouseAdapter {
        JPopupMenu popupMenu;
        private Component component;
        private Map popupMenuItems;

        LocalMouseListener(String menuItemLabel) {
            this.initialize(menuItemLabel);
        }

        private void initialize(String menuItemLabel) {
            this.popupMenuItems = new WeakHashMap();
            JMenuItem item = new JMenuItem(menuItemLabel);
            item.addActionListener(this.buildMenuItemListener());
            item.setAccelerator(KeyStroke.getKeyStroke(112, 0));
            this.popupMenu = new JPopupMenu();
            this.popupMenu.add(item);
        }

        private ActionListener buildMenuItemListener() {
            return new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LocalMouseListener.this.showHelp();
                }
            };
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.handleMouseEvent(e);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.handleMouseEvent(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.handleMouseEvent(e);
        }

        private void handleMouseEvent(MouseEvent e) {
            if (!e.isPopupTrigger()) {
                return;
            }
            if (this.component != null) {
                this.removeMenuItemsFor(this.component);
            }
            this.component = (Component)e.getSource();
            this.insertMenuItemsFor(this.component);
            this.popupMenu.show(this.component, e.getX(), e.getY());
        }

        private synchronized void insertMenuItemsFor(Component c) {
            JMenuItem[] menuItems = this.menuItemsFor(c);
            if (menuItems != null) {
                for (int i = 0; i < menuItems.length; ++i) {
                    this.popupMenu.insert(menuItems[i], i);
                }
            }
        }

        private synchronized void removeMenuItemsFor(Component c) {
            JMenuItem[] menuItems = this.menuItemsFor(c);
            if (menuItems != null) {
                for (int i = 0; i < menuItems.length; ++i) {
                    this.popupMenu.remove(menuItems[i]);
                }
            }
        }

        void showHelp() {
            DefaultHelpManager.this.showTopic(this.component);
        }

        void addItemsToPopupMenuForComponent(JMenuItem[] menuItems, Component c) {
            this.popupMenuItems.put(c, menuItems);
        }

        private JMenuItem[] menuItemsFor(Component c) {
            return (JMenuItem[])this.popupMenuItems.get(c);
        }
    }
}

