/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.diff;

import java.util.Collection;
import org.eclipse.persistence.tools.workbench.utility.diff.CompositeDiff;
import org.eclipse.persistence.tools.workbench.utility.diff.Diff;
import org.eclipse.persistence.tools.workbench.utility.diff.Differentiator;
import org.eclipse.persistence.tools.workbench.utility.diff.DifferentiatorAdapter;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public class CompositeDifferentiator
implements Differentiator {
    private final Differentiator[] differentiators;
    private final boolean comparesValueObjects;

    public CompositeDifferentiator(Collection differentiators) {
        this(differentiators.toArray(new Differentiator[differentiators.size()]));
    }

    public CompositeDifferentiator(Differentiator[] differentiators) {
        this.differentiators = differentiators;
        this.comparesValueObjects = this.buildcomparesValueObjects();
    }

    private boolean buildcomparesValueObjects() {
        int len = this.differentiators.length;
        if (len == 0) {
            return false;
        }
        boolean result = this.differentiators[len - 1].comparesValueObjects();
        int i = len - 1;
        while (i-- > 0) {
            if (this.differentiators[i].comparesValueObjects() == result) continue;
            throw new IllegalStateException("all the component differentiators must match on Differentiator.comparesValueObjects()");
        }
        return result;
    }

    @Override
    public Diff diff(Object object1, Object object2) {
        return this.diff(object1, object2, DifferentiatorAdapter.NORMAL);
    }

    @Override
    public Diff keyDiff(Object object1, Object object2) {
        return this.diff(object1, object2, DifferentiatorAdapter.KEY);
    }

    private Diff diff(Object object1, Object object2, DifferentiatorAdapter adapter) {
        int len = this.differentiators.length;
        Diff[] diffs = new Diff[len];
        for (int i = 0; i < len; ++i) {
            diffs[i] = adapter.diff(this.differentiators[i], object1, object2);
        }
        return new CompositeDiff(object1, object2, diffs, this);
    }

    @Override
    public boolean comparesValueObjects() {
        return this.comparesValueObjects;
    }

    public String toString() {
        return StringTools.buildToStringFor(this);
    }
}

