/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility;

import java.io.PrintStream;
import java.io.Serializable;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.ExceptionBroadcaster;
import org.eclipse.persistence.tools.workbench.utility.ExceptionListener;

public class SimpleExceptionBroadcaster
implements ExceptionBroadcaster,
Serializable {
    private ExceptionListener[] listeners;
    private final PrintStream defaultStream;
    private static final ExceptionListener[] EMPTY_LISTENERS = new ExceptionListener[0];
    private static final long serialVersionUID = 1L;

    public SimpleExceptionBroadcaster(PrintStream defaultStream) {
        this.defaultStream = defaultStream;
    }

    public SimpleExceptionBroadcaster() {
        this(System.err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void broadcast(Thread thread, Throwable exception) {
        ExceptionListener[] currentListeners = null;
        SimpleExceptionBroadcaster simpleExceptionBroadcaster = this;
        synchronized (simpleExceptionBroadcaster) {
            if (this.listeners != null) {
                int len = this.listeners.length;
                currentListeners = new ExceptionListener[len];
                System.arraycopy(this.listeners, 0, currentListeners, 0, len);
            }
        }
        if (currentListeners == null) {
            this.broadcastOnDefaultStream(thread, exception);
        } else {
            int i = currentListeners.length;
            while (i-- > 0) {
                try {
                    currentListeners[i].exceptionThrown(thread, exception);
                }
                catch (Throwable ex2) {
                    this.broadcastOnDefaultStream(Thread.currentThread(), ex2);
                    this.broadcastOnDefaultStream(thread, exception);
                }
            }
        }
    }

    @Override
    public synchronized void addExceptionListener(ExceptionListener listener) {
        ExceptionListener[] newListeners;
        if (listener == null) {
            throw new NullPointerException();
        }
        int len = 0;
        if (this.listeners == null) {
            newListeners = new ExceptionListener[1];
        } else {
            len = this.listeners.length;
            newListeners = new ExceptionListener[len + 1];
            System.arraycopy(this.listeners, 0, newListeners, 0, len);
        }
        newListeners[len] = listener;
        this.listeners = newListeners;
    }

    @Override
    public synchronized void removeExceptionListener(ExceptionListener listener) {
        int len;
        if (this.listeners == null) {
            throw new IllegalArgumentException("listener not registered");
        }
        int index = len = this.listeners.length;
        while (index-- > 0 && this.listeners[index] != listener) {
        }
        if (index == -1) {
            throw new IllegalArgumentException("listener not registered");
        }
        if (len == 1) {
            this.listeners = null;
        } else {
            int next;
            ExceptionListener[] newListeners = new ExceptionListener[len - 1];
            if (index != 0) {
                System.arraycopy(this.listeners, 0, newListeners, 0, index);
            }
            if ((next = index + 1) != len) {
                System.arraycopy(this.listeners, next, newListeners, index, len - next);
            }
            this.listeners = newListeners;
        }
    }

    public synchronized ExceptionListener[] getExceptionListeners() {
        if (this.listeners == null) {
            return EMPTY_LISTENERS;
        }
        int len = this.listeners.length;
        ExceptionListener[] result = new ExceptionListener[len];
        System.arraycopy(this.listeners, 0, result, 0, len);
        return result;
    }

    public synchronized boolean hasExceptionListeners() {
        return this.listeners != null;
    }

    public synchronized boolean hasNoExceptionListeners() {
        return this.listeners == null;
    }

    public String toString() {
        return ClassTools.shortClassNameForObject(this);
    }

    protected void broadcastOnDefaultStream(Thread thread, Throwable exception) {
        this.broadcastOn(thread, exception, this.defaultStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void broadcastOn(Thread thread, Throwable exception, PrintStream stream) {
        PrintStream printStream = stream;
        synchronized (printStream) {
            stream.println(thread);
            exception.printStackTrace(stream);
        }
    }
}

