/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational;

import java.util.List;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.relational.MWRelationalProject;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.relational.MWRelationalProjectDefaultsPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWAbstractQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWAutoGeneratedQueryFormat;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWEJBQLQueryFormat;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWExpressionQueryFormat;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWQueryFormat;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWRelationalQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWSQLQueryFormat;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWStoredProcedureQueryFormat;
import org.eclipse.persistence.tools.workbench.utility.TriStateBoolean;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWRelationalSpecificQueryOptions
extends MWModel
implements MWRelationalQuery {
    private volatile TriStateBoolean cacheStatement;
    private volatile TriStateBoolean bindAllParameters;
    private volatile boolean prepare;
    private volatile MWQueryFormat queryFormat;

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWRelationalSpecificQueryOptions.class);
        XMLCompositeObjectMapping formatMapping = new XMLCompositeObjectMapping();
        formatMapping.setAttributeName("queryFormat");
        formatMapping.setReferenceClass(MWQueryFormat.class);
        formatMapping.setXPath("format");
        descriptor.addMapping((DatabaseMapping)formatMapping);
        XMLDirectMapping bindAllParameters = (XMLDirectMapping)descriptor.addDirectMapping("bindAllParameters", "getBindAllParametersForTopLink", "setBindAllParametersForTopLink", "bind-all-parameters/text()");
        bindAllParameters.setNullValue(null);
        XMLDirectMapping cacheStatement = (XMLDirectMapping)descriptor.addDirectMapping("cacheStatement", "getCacheStatementForTopLink", "setCacheStatementForTopLink", "cache-statement/text()");
        cacheStatement.setNullValue(null);
        ((XMLDirectMapping)descriptor.addDirectMapping("prepare", "prepare/text()")).setNullValue((Object)Boolean.TRUE);
        return descriptor;
    }

    private MWRelationalSpecificQueryOptions() {
    }

    MWRelationalSpecificQueryOptions(MWRelationalQuery parent) {
        super(parent);
    }

    @Override
    protected void initialize(Node parent) {
        super.initialize(parent);
        this.cacheStatement = TriStateBoolean.UNDEFINED;
        this.bindAllParameters = TriStateBoolean.TRUE;
        this.prepare = true;
        this.queryFormat = new MWExpressionQueryFormat(this);
    }

    @Override
    protected void addChildrenTo(List list) {
        super.addChildrenTo(list);
        list.add(this.queryFormat);
    }

    public MWAbstractQuery getQuery() {
        return (MWAbstractQuery)this.getParent();
    }

    void initializeFrom(MWRelationalSpecificQueryOptions oldOptions) {
        this.setCacheStatement(oldOptions.isCacheStatement());
        this.setBindAllParameters(oldOptions.isBindAllParameters());
        this.setPrepare(oldOptions.isPrepare());
        this.setQueryFormat(oldOptions.getQueryFormat());
        this.getQueryFormat().setParent(this);
    }

    @Override
    public TriStateBoolean isBindAllParameters() {
        return this.bindAllParameters;
    }

    @Override
    public void setBindAllParameters(TriStateBoolean bindAllParameters) {
        TriStateBoolean oldBindAllParameters = this.isBindAllParameters();
        this.bindAllParameters = bindAllParameters;
        this.firePropertyChanged("bindAllParameters", oldBindAllParameters, bindAllParameters);
    }

    @Override
    public TriStateBoolean isCacheStatement() {
        return this.cacheStatement;
    }

    @Override
    public void setCacheStatement(TriStateBoolean cacheStatement) {
        TriStateBoolean oldCacheStatement = this.isCacheStatement();
        this.cacheStatement = cacheStatement;
        this.firePropertyChanged("cacheStatement", oldCacheStatement, cacheStatement);
    }

    @Override
    public boolean isPrepare() {
        return this.prepare;
    }

    @Override
    public void setPrepare(boolean prepare) {
        boolean oldPrepare = this.isPrepare();
        this.prepare = prepare;
        this.firePropertyChanged("prepare", oldPrepare, prepare);
    }

    @Override
    public MWQueryFormat getQueryFormat() {
        return this.queryFormat;
    }

    @Override
    public String getQueryFormatType() {
        return this.queryFormat.getType();
    }

    @Override
    public void setQueryFormatType(String queryFormat) {
        String oldValue = this.getQueryFormatType();
        if (oldValue == queryFormat) {
            return;
        }
        if (queryFormat == "expressionFormat") {
            this.setQueryFormatToExpression();
        } else if (queryFormat == "autoGenerateFormat") {
            this.setQueryFormatToAutoGenerated();
        } else if (queryFormat == "sqlFormat") {
            this.setQueryFormatToSql();
        } else if (queryFormat == "ejbqlFormat") {
            this.setQueryFormatToEjbql();
        } else if (queryFormat == "storedProcedure") {
            this.setQueryFormatToStoredProcedure();
        } else {
            throw new IllegalArgumentException("queryFormatType must be set to : MWQuery.EXPRESSION_FORMAT, MWQuery.AUTO_GENERATED_FORMAT, MWQuery.SQL_FORMAT, MWQuery.STORED_PROCEDURE_FORMAT, or MWQuery.EJBQL_FORMAT");
        }
        this.firePropertyChanged("queryFormatType", oldValue, this.getQueryFormatType());
    }

    private void setDefaultQueryFormat() {
        this.setQueryFormat(new MWExpressionQueryFormat(this));
    }

    MWAutoGeneratedQueryFormat setQueryFormatToAutoGenerated() {
        MWAutoGeneratedQueryFormat queryFormat = new MWAutoGeneratedQueryFormat(this);
        this.setQueryFormat(queryFormat);
        return queryFormat;
    }

    void setQueryFormatToEjbql() {
        MWEJBQLQueryFormat queryFormat = new MWEJBQLQueryFormat(this);
        this.setQueryFormat(queryFormat);
        ((MWRelationalQuery)this.getParent()).formatSetToEjbql();
    }

    void setQueryFormatToExpression() {
        MWExpressionQueryFormat queryFormat = new MWExpressionQueryFormat(this);
        this.setQueryFormat(queryFormat);
    }

    void setQueryFormatToStoredProcedure() {
        MWStoredProcedureQueryFormat queryFormat = new MWStoredProcedureQueryFormat(this);
        this.setQueryFormat(queryFormat);
    }

    void setQueryFormatToSql() {
        MWSQLQueryFormat queryFormat = new MWSQLQueryFormat(this);
        this.setQueryFormat(queryFormat);
        ((MWRelationalQuery)this.getParent()).formatSetToSql();
    }

    private void setQueryFormat(MWQueryFormat queryFormat) {
        this.queryFormat = queryFormat;
    }

    @Override
    public void notifyExpressionsToRecalculateQueryables() {
        if (this.getQueryFormat().getExpression() != null) {
            this.getQueryFormat().getExpression().recalculateQueryables();
        }
    }

    @Override
    public MWRelationalSpecificQueryOptions getRelationalOptions() {
        return this;
    }

    @Override
    public void formatSetToEjbql() {
    }

    @Override
    public void formatSetToSql() {
    }

    @Override
    protected void addProblemsTo(List currentProblems) {
        super.addProblemsTo(currentProblems);
        this.checkCachesStatementButDoesNotBindParameters(currentProblems);
    }

    private void checkCachesStatementButDoesNotBindParameters(List currentProblems) {
        if (this.isCacheStatement().isTrue()) {
            if (this.isBindAllParameters().isUndefined()) {
                MWRelationalProject project = (MWRelationalProject)this.getProject();
                if (!((MWRelationalProjectDefaultsPolicy)project.getDefaultsPolicy()).shouldQueriesBindAllParameters()) {
                    currentProblems.add(this.buildProblem("0241", this.getQuery().getName()));
                }
            } else if (this.isBindAllParameters().isFalse()) {
                currentProblems.add(this.buildProblem("0241", this.getQuery().getName()));
            }
        }
    }

    void adjustRuntimeQuery(DatabaseQuery runtimeQuery) {
        runtimeQuery.setShouldPrepare(this.isPrepare());
        if (!this.isBindAllParameters().isUndefined()) {
            runtimeQuery.setShouldBindAllParameters(this.isBindAllParameters().booleanValue());
        }
        if (!this.isCacheStatement().isUndefined()) {
            runtimeQuery.setShouldCacheStatement(this.isCacheStatement().booleanValue());
        }
        this.getQueryFormat().convertToRuntime(runtimeQuery);
    }

    public void adjustFromRuntime(DatabaseQuery runtimeQuery) {
        this.setPrepare(runtimeQuery.shouldPrepare());
        if (!runtimeQuery.shouldIgnoreBindAllParameters()) {
            this.setBindAllParameters(new TriStateBoolean(runtimeQuery.shouldBindAllParameters()));
        } else {
            this.setBindAllParameters(TriStateBoolean.UNDEFINED);
        }
        if (!runtimeQuery.shouldIgnoreCacheStatement()) {
            this.setCacheStatement(new TriStateBoolean(runtimeQuery.shouldCacheStatement()));
        } else {
            this.setCacheStatement(TriStateBoolean.UNDEFINED);
        }
        this.setDefaultQueryFormat();
        if (runtimeQuery.getSQLString() != null) {
            this.setQueryFormatToSql();
        } else if (runtimeQuery.getEJBQLString() != null) {
            this.setQueryFormatToEjbql();
        }
        this.getQueryFormat().convertFromRuntime(runtimeQuery);
    }

    private Boolean getBindAllParametersForTopLink() {
        return this.bindAllParameters.getValue();
    }

    void setBindAllParametersForTopLink(Boolean bindAllParameters) {
        this.bindAllParameters = new TriStateBoolean(bindAllParameters);
    }

    private Boolean getCacheStatementForTopLink() {
        return this.cacheStatement.getValue();
    }

    private void setCacheStatementForTopLink(Boolean cacheStatement) {
        this.cacheStatement = new TriStateBoolean(cacheStatement);
    }
}

