/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational;

import java.util.Iterator;
import java.util.List;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.DescriptorEvent;
import org.eclipse.persistence.descriptors.DescriptorQueryManager;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.DeleteObjectQuery;
import org.eclipse.persistence.queries.InsertObjectQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.queries.UpdateObjectQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalTransactionalPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQueryManager;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWReadAllQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWReadObjectQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWCustomReadAllQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWCustomReadObjectQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWDeleteQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWInsertQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWRelationalQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWRelationalReadAllQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWRelationalReadObjectQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWReportQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWSQLQueryFormat;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWUpdateQuery;

public final class MWRelationalQueryManager
extends MWQueryManager {
    private volatile MWInsertQuery insertQuery;
    public static final String INSERT_QUERY_PROPERTY = "insertQuery";
    private volatile MWUpdateQuery updateQuery;
    public static final String UPDATE_QUERY_PROPERTY = "updateQuery";
    private volatile MWDeleteQuery deleteQuery;
    public static final String DELETE_QUERY_PROPERTY = "deleteQuery";
    private volatile MWCustomReadObjectQuery readObjectQuery;
    public static final String READ_OBJECT_QUERY_PROPERTY = "readObjectQuery";
    private volatile MWCustomReadAllQuery readAllQuery;
    public static final String READ_ALL_QUERY_PROPERTY = "readAllQuery";
    private String legacyDescriptorAlias;

    private MWRelationalQueryManager() {
    }

    public MWRelationalQueryManager(MWRelationalTransactionalPolicy descriptor) {
        super(descriptor);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.insertQuery = new MWInsertQuery(this);
        this.deleteQuery = new MWDeleteQuery(this);
        this.updateQuery = new MWUpdateQuery(this);
        this.readObjectQuery = new MWCustomReadObjectQuery(this);
        this.readAllQuery = new MWCustomReadAllQuery(this);
    }

    @Override
    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        children.add(this.insertQuery);
        children.add(this.deleteQuery);
        children.add(this.updateQuery);
        children.add(this.readObjectQuery);
        children.add(this.readAllQuery);
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWRelationalQueryManager.class);
        descriptor.getInheritancePolicy().setParentClass(MWQueryManager.class);
        XMLCompositeObjectMapping insertQueryMapping = new XMLCompositeObjectMapping();
        insertQueryMapping.setAttributeName(INSERT_QUERY_PROPERTY);
        insertQueryMapping.setGetMethodName("getInsertQueryForTopLink");
        insertQueryMapping.setSetMethodName("setInsertQueryForTopLink");
        insertQueryMapping.setReferenceClass(MWInsertQuery.class);
        insertQueryMapping.setXPath("insert-query");
        descriptor.addMapping((DatabaseMapping)insertQueryMapping);
        XMLCompositeObjectMapping deleteQueryMapping = new XMLCompositeObjectMapping();
        deleteQueryMapping.setAttributeName(DELETE_QUERY_PROPERTY);
        deleteQueryMapping.setGetMethodName("getDeleteQueryForTopLink");
        deleteQueryMapping.setSetMethodName("setDeleteQueryForTopLink");
        deleteQueryMapping.setReferenceClass(MWDeleteQuery.class);
        deleteQueryMapping.setXPath("delete-query");
        descriptor.addMapping((DatabaseMapping)deleteQueryMapping);
        XMLCompositeObjectMapping updateQueryMapping = new XMLCompositeObjectMapping();
        updateQueryMapping.setAttributeName(UPDATE_QUERY_PROPERTY);
        updateQueryMapping.setGetMethodName("getUpdateQueryForTopLink");
        updateQueryMapping.setSetMethodName("setUpdateQueryForTopLink");
        updateQueryMapping.setReferenceClass(MWUpdateQuery.class);
        updateQueryMapping.setXPath("update-query");
        descriptor.addMapping((DatabaseMapping)updateQueryMapping);
        XMLCompositeObjectMapping readObjectQueryMapping = new XMLCompositeObjectMapping();
        readObjectQueryMapping.setAttributeName(READ_OBJECT_QUERY_PROPERTY);
        readObjectQueryMapping.setGetMethodName("getReadObjectQueryForTopLink");
        readObjectQueryMapping.setSetMethodName("setReadObjectQueryForTopLink");
        readObjectQueryMapping.setReferenceClass(MWCustomReadObjectQuery.class);
        readObjectQueryMapping.setXPath("read-object-query");
        descriptor.addMapping((DatabaseMapping)readObjectQueryMapping);
        XMLCompositeObjectMapping readAllQueryMapping = new XMLCompositeObjectMapping();
        readAllQueryMapping.setAttributeName(READ_ALL_QUERY_PROPERTY);
        readAllQueryMapping.setGetMethodName("getReadAllQueryForTopLink");
        readAllQueryMapping.setSetMethodName("setReadAllQueryForTopLink");
        readAllQueryMapping.setReferenceClass(MWCustomReadAllQuery.class);
        readAllQueryMapping.setXPath("read-all-query");
        descriptor.addMapping((DatabaseMapping)readAllQueryMapping);
        descriptor.addDirectMapping("insertSQLString", "legacyGetInsertSQLString", "legacySetInsertSQLString", "insert-string/text()");
        descriptor.addDirectMapping("updateSQLString", "legacyGetUpdateSQLString", "legacySetUpdateSQLString", "update-string/text()");
        descriptor.addDirectMapping("deleteSQLString", "legacyGetDeleteSQLString", "legacySetDeleteSQLString", "delete-string/text()");
        descriptor.addDirectMapping("readObjectSQLString", "legacyGetReadObjectSQLString", "legacySetReadObjectSQLString", "read-object-string/text()");
        descriptor.addDirectMapping("readAllSQLString", "legacyGetReadAllSQLString", "legacySetReadAllSQLString", "read-all-string/text()");
        return descriptor;
    }

    public static XMLDescriptor buildStandalone60Descriptor() {
        XMLDescriptor descriptor = MWModel.legacy60BuildStandardDescriptor();
        descriptor.setJavaClass(MWRelationalQueryManager.class);
        descriptor.getInheritancePolicy().setParentClass(MWQueryManager.class);
        descriptor.addDirectMapping("insertSQLString", "legacyGetInsertSQLString", "legacySetInsertSQLString", "insert-string/text()");
        descriptor.addDirectMapping("updateSQLString", "legacyGetUpdateSQLString", "legacySetUpdateSQLString", "update-string/text()");
        descriptor.addDirectMapping("deleteSQLString", "legacyGetDeleteSQLString", "legacySetDeleteSQLString", "delete-string/text()");
        descriptor.addDirectMapping("readObjectSQLString", "legacyGetReadObjectSQLString", "legacySetReadObjectSQLString", "read-object-string/text()");
        descriptor.addDirectMapping("readAllSQLString", "legacyGetReadAllSQLString", "legacySetReadAllSQLString", "read-all-string/text()");
        return descriptor;
    }

    public MWReportQuery addReportQuery(String queryName) {
        return (MWReportQuery)this.addQuery(new MWReportQuery(this, queryName));
    }

    @Override
    public MWReadAllQuery buildReadAllQuery(String queryName) {
        return new MWRelationalReadAllQuery(this, queryName);
    }

    @Override
    public MWReadObjectQuery buildReadObjectQuery(String queryName) {
        return new MWRelationalReadObjectQuery(this, queryName);
    }

    @Override
    public boolean supportsReportQueries() {
        return true;
    }

    public MWDeleteQuery getDeleteQuery() {
        return this.deleteQuery;
    }

    public MWInsertQuery getInsertQuery() {
        return this.insertQuery;
    }

    public MWCustomReadAllQuery getReadAllQuery() {
        return this.readAllQuery;
    }

    public MWCustomReadObjectQuery getReadObjectQuery() {
        return this.readObjectQuery;
    }

    public MWUpdateQuery getUpdateQuery() {
        return this.updateQuery;
    }

    public void setDeleteQuery(MWDeleteQuery delete) {
        MWDeleteQuery oldDelete = this.getDeleteQuery();
        this.deleteQuery = delete;
        this.firePropertyChanged(DELETE_QUERY_PROPERTY, oldDelete, delete);
    }

    public void setDeleteSQLString(String sqlString) {
        this.deleteQuery.setSQLString(sqlString);
    }

    public void setInsertQuery(MWInsertQuery insert) {
        MWInsertQuery oldInsert = this.getInsertQuery();
        this.insertQuery = insert;
        this.firePropertyChanged(INSERT_QUERY_PROPERTY, oldInsert, insert);
    }

    public void setInsertSQLString(String sqlString) {
        this.insertQuery.setSQLString(sqlString);
    }

    public void setReadAllQuery(MWCustomReadAllQuery readAll) {
        MWCustomReadAllQuery oldReadAll = this.getReadAllQuery();
        this.readAllQuery = readAll;
        this.firePropertyChanged(READ_ALL_QUERY_PROPERTY, oldReadAll, readAll);
    }

    public void setReadAllSQLString(String sqlString) {
        this.readAllQuery.setSQLString(sqlString);
    }

    public void setReadObjectQuery(MWCustomReadObjectQuery readObject) {
        MWCustomReadObjectQuery oldReadObject = this.getReadObjectQuery();
        this.readObjectQuery = readObject;
        this.firePropertyChanged(READ_OBJECT_QUERY_PROPERTY, oldReadObject, readObject);
    }

    public void setReadObjectSQLString(String sqlString) {
        this.readObjectQuery.setSQLString(sqlString);
    }

    public void setUpdateQuery(MWUpdateQuery update) {
        MWUpdateQuery oldUpdate = this.getUpdateQuery();
        this.updateQuery = update;
        this.firePropertyChanged(UPDATE_QUERY_PROPERTY, oldUpdate, update);
    }

    public void setUpdateSQLString(String sqlString) {
        this.updateQuery.setSQLString(sqlString);
    }

    public void notifyExpressionsToRecalculateQueryables() {
        Iterator queries = this.queries();
        while (queries.hasNext()) {
            ((MWRelationalQuery)queries.next()).notifyExpressionsToRecalculateQueryables();
        }
    }

    private MWInsertQuery getInsertQueryForTopLink() {
        return this.insertQuery;
    }

    private MWDeleteQuery getDeleteQueryForTopLink() {
        return this.deleteQuery;
    }

    private MWUpdateQuery getUpdateQueryForTopLink() {
        return this.updateQuery;
    }

    private MWCustomReadObjectQuery getReadObjectQueryForTopLink() {
        return this.readObjectQuery;
    }

    private MWCustomReadAllQuery getReadAllQueryForTopLink() {
        return this.readAllQuery;
    }

    private void setInsertQueryForTopLink(MWInsertQuery query) {
        if (query != null) {
            this.insertQuery = query;
        }
    }

    private void setDeleteQueryForTopLink(MWDeleteQuery query) {
        if (query != null) {
            this.deleteQuery = query;
        }
    }

    private void setUpdateQueryForTopLink(MWUpdateQuery query) {
        if (query != null) {
            this.updateQuery = query;
        }
    }

    private void setReadObjectQueryForTopLink(MWCustomReadObjectQuery query) {
        if (query != null) {
            this.readObjectQuery = query;
        }
    }

    private void setReadAllQueryForTopLink(MWCustomReadAllQuery query) {
        if (query != null) {
            this.readAllQuery = query;
        }
    }

    @Override
    protected void legacy60PostBuild(DescriptorEvent event) {
        super.legacy60PostBuild(event);
        if (this.deleteQuery == null) {
            this.deleteQuery = new MWDeleteQuery(this);
        }
        if (this.insertQuery == null) {
            this.insertQuery = new MWInsertQuery(this);
        }
        if (this.readAllQuery == null) {
            this.readAllQuery = new MWCustomReadAllQuery(this);
        }
        if (this.readObjectQuery == null) {
            this.readObjectQuery = new MWCustomReadObjectQuery(this);
        }
        if (this.updateQuery == null) {
            this.updateQuery = new MWUpdateQuery(this);
        }
    }

    private String legacyGetInsertSQLString() {
        return null;
    }

    private String legacyGetUpdateSQLString() {
        return null;
    }

    private String legacyGetDeleteSQLString() {
        return null;
    }

    private String legacyGetReadObjectSQLString() {
        return null;
    }

    private String legacyGetReadAllSQLString() {
        return null;
    }

    private void legacySetInsertSQLString(String sql) {
        if (sql != null) {
            this.insertQuery = new MWInsertQuery(this);
            this.insertQuery.setQueryFormatType("sqlFormat");
            MWSQLQueryFormat queryFormat = (MWSQLQueryFormat)this.insertQuery.getQueryFormat();
            queryFormat.legacySetQueryStringForTopLink(sql);
        }
    }

    private void legacySetUpdateSQLString(String sql) {
        if (sql != null) {
            this.updateQuery = new MWUpdateQuery(this);
            this.updateQuery.setQueryFormatType("sqlFormat");
            MWSQLQueryFormat queryFormat = (MWSQLQueryFormat)this.updateQuery.getQueryFormat();
            queryFormat.legacySetQueryStringForTopLink(sql);
        }
    }

    private void legacySetDeleteSQLString(String sql) {
        if (sql != null) {
            this.deleteQuery = new MWDeleteQuery(this);
            this.deleteQuery.setQueryFormatType("sqlFormat");
            MWSQLQueryFormat queryFormat = (MWSQLQueryFormat)this.deleteQuery.getQueryFormat();
            queryFormat.legacySetQueryStringForTopLink(sql);
        }
    }

    private void legacySetReadObjectSQLString(String sql) {
        if (sql != null) {
            this.readObjectQuery = new MWCustomReadObjectQuery(this);
            this.readObjectQuery.setQueryFormatType("sqlFormat");
            MWSQLQueryFormat queryFormat = (MWSQLQueryFormat)this.readObjectQuery.getQueryFormat();
            queryFormat.legacySetQueryStringForTopLink(sql);
        }
    }

    private void legacySetReadAllSQLString(String sql) {
        if (sql != null) {
            this.readAllQuery = new MWCustomReadAllQuery(this);
            this.readAllQuery.setQueryFormatType("sqlFormat");
            MWSQLQueryFormat queryFormat = (MWSQLQueryFormat)this.readAllQuery.getQueryFormat();
            queryFormat.legacySetQueryStringForTopLink(sql);
        }
    }

    @Override
    public void adjustRuntimeDescriptor(ClassDescriptor runtimeDescriptor) {
        super.adjustRuntimeDescriptor(runtimeDescriptor);
        DescriptorQueryManager rtQueryManager = runtimeDescriptor.getQueryManager();
        if (!this.deleteQuery.isContentEmpty()) {
            DeleteObjectQuery rtDeleteQuery = (DeleteObjectQuery)this.deleteQuery.buildRuntimeQuery();
            this.deleteQuery.adjustRuntimeQuery((DatabaseQuery)rtDeleteQuery);
            rtQueryManager.setDeleteQuery(rtDeleteQuery);
        }
        if (!this.insertQuery.isContentEmpty()) {
            InsertObjectQuery rtInsertQuery = (InsertObjectQuery)this.insertQuery.buildRuntimeQuery();
            this.insertQuery.adjustRuntimeQuery((DatabaseQuery)rtInsertQuery);
            rtQueryManager.setInsertQuery(rtInsertQuery);
        }
        if (!this.updateQuery.isContentEmpty()) {
            UpdateObjectQuery rtUpdateQuery = (UpdateObjectQuery)this.updateQuery.buildRuntimeQuery();
            this.updateQuery.adjustRuntimeQuery((DatabaseQuery)rtUpdateQuery);
            rtQueryManager.setUpdateQuery(rtUpdateQuery);
        }
        if (!this.readAllQuery.isContentEmpty()) {
            ReadAllQuery rtReadAllQuery = (ReadAllQuery)this.readAllQuery.buildRuntimeQuery();
            this.readAllQuery.adjustRuntimeQuery((DatabaseQuery)rtReadAllQuery);
            rtQueryManager.setReadAllQuery(rtReadAllQuery);
        }
        if (!this.readObjectQuery.isContentEmpty()) {
            ReadObjectQuery rtReadObjectQuery = (ReadObjectQuery)this.readObjectQuery.buildRuntimeQuery();
            this.readObjectQuery.adjustRuntimeQuery((DatabaseQuery)rtReadObjectQuery);
            rtQueryManager.setReadObjectQuery(rtReadObjectQuery);
        }
    }

    public void adjustFromRuntimeDescriptor(ClassDescriptor runtimeDescriptor) {
        super.adjustFromRuntime(runtimeDescriptor);
        DescriptorQueryManager rtQueryManager = runtimeDescriptor.getQueryManager();
        DeleteObjectQuery rtDeleteQuery = (DeleteObjectQuery)this.deleteQuery.buildRuntimeQuery();
        this.deleteQuery.adjustRuntimeQuery((DatabaseQuery)rtDeleteQuery);
        rtQueryManager.setDeleteQuery(rtDeleteQuery);
        InsertObjectQuery rtInsertQuery = (InsertObjectQuery)this.insertQuery.buildRuntimeQuery();
        this.insertQuery.adjustRuntimeQuery((DatabaseQuery)rtInsertQuery);
        rtQueryManager.setInsertQuery(rtInsertQuery);
        UpdateObjectQuery rtUpdateQuery = (UpdateObjectQuery)this.updateQuery.buildRuntimeQuery();
        this.updateQuery.adjustRuntimeQuery((DatabaseQuery)rtUpdateQuery);
        rtQueryManager.setUpdateQuery(rtUpdateQuery);
        ReadAllQuery rtReadAllQuery = (ReadAllQuery)this.readAllQuery.buildRuntimeQuery();
        this.readAllQuery.adjustRuntimeQuery((DatabaseQuery)rtReadAllQuery);
        rtQueryManager.setReadAllQuery(rtReadAllQuery);
        ReadObjectQuery rtReadObjectQuery = (ReadObjectQuery)this.readObjectQuery.buildRuntimeQuery();
        this.readObjectQuery.adjustRuntimeQuery((DatabaseQuery)rtReadObjectQuery);
        rtQueryManager.setReadObjectQuery(rtReadObjectQuery);
    }

    public static XMLDescriptor legacy60BuildDescriptor() {
        XMLDescriptor descriptor = MWModel.legacy60BuildStandardDescriptor();
        descriptor.setJavaClass(MWRelationalQueryManager.class);
        descriptor.getInheritancePolicy().setParentClass(MWQueryManager.class);
        descriptor.addDirectMapping("insertSQLString", "legacyGetInsertSQLString", "legacySetInsertSQLString", "insert-string/text()");
        descriptor.addDirectMapping("updateSQLString", "legacyGetUpdateSQLString", "legacySetUpdateSQLString", "update-string/text()");
        descriptor.addDirectMapping("deleteSQLString", "legacyGetDeleteSQLString", "legacySetDeleteSQLString", "delete-string/text()");
        descriptor.addDirectMapping("readObjectSQLString", "legacyGetReadObjectSQLString", "legacySetReadObjectSQLString", "read-object-string/text()");
        descriptor.addDirectMapping("readAllSQLString", "legacyGetReadAllSQLString", "legacySetReadAllSQLString", "read-all-string/text()");
        return descriptor;
    }
}

